/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CTCubeRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] ctSprites;

    public CTCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.ctSprites = new TextureAtlasSprite[16];
        for (int i = 0; i < 16; ++i) {
            this.ctSprites[i] = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/" + this.basePath + "_" + i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.ctSprites[this.ctSprites.length - 1];
    }

    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, int connectionMask) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            int backFaceTextureMask;
            if (CTCubeRenderer.hasFaceBit(connectionMask, renderSide)) continue;
            int resultTextureMask = 15;
            if (renderSide.func_176740_k().func_176722_c()) {
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.UP)) {
                    resultTextureMask &= 0xFFFFFFFE;
                }
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.DOWN)) {
                    resultTextureMask &= 0xFFFFFFFD;
                }
                EnumFacing leftFacing = renderSide.func_176746_e();
                EnumFacing rightFacing = renderSide.func_176735_f();
                if (CTCubeRenderer.hasFaceBit(connectionMask, leftFacing)) {
                    resultTextureMask &= 0xFFFFFFFB;
                }
                if (CTCubeRenderer.hasFaceBit(connectionMask, rightFacing)) {
                    resultTextureMask &= 0xFFFFFFF7;
                }
            } else {
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.NORTH)) {
                    resultTextureMask &= 0xFFFFFFFE;
                }
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.SOUTH)) {
                    resultTextureMask &= 0xFFFFFFFD;
                }
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.WEST)) {
                    resultTextureMask &= 0xFFFFFFFB;
                }
                if (CTCubeRenderer.hasFaceBit(connectionMask, EnumFacing.EAST)) {
                    resultTextureMask &= 0xFFFFFFF7;
                }
            }
            TextureAtlasSprite sideSprite = this.ctSprites[resultTextureMask];
            Textures.renderFace(renderState, translation, pipeline, renderSide, Cuboid6.full, sideSprite);
            Matrix4 backTranslation = translation.copy();
            backTranslation.translate((double)renderSide.func_82601_c(), (double)renderSide.func_96559_d() * 0.999, (double)renderSide.func_82599_e());
            if (renderSide.func_176740_k().func_176722_c()) {
                backFaceTextureMask = resultTextureMask & 0xFFFFFFF3;
                if ((resultTextureMask & 8) > 0) {
                    backFaceTextureMask |= 4;
                }
                if ((resultTextureMask & 4) > 0) {
                    backFaceTextureMask |= 8;
                }
            } else {
                backFaceTextureMask = resultTextureMask;
            }
            TextureAtlasSprite backSideSprite = this.ctSprites[backFaceTextureMask];
            Textures.renderFace(renderState, backTranslation, pipeline, renderSide.func_176734_d(), Cuboid6.full, backSideSprite);
        }
    }

    public static boolean hasFaceBit(int mask, EnumFacing side) {
        return (mask & 1 << side.func_176745_a()) > 0;
    }

    private static class TextureDirection {
        private static final int TOP = 1;
        private static final int BOTTOM = 2;
        private static final int LEFT = 4;
        private static final int RIGHT = 8;

        private TextureDirection() {
        }
    }
}

