/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import crafttweaker.annotations.ZenRegister;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.Element")
@ZenRegister
public enum Element {
    H(1L, 0L, -1L, null, "Hydrogen", false),
    D(1L, 1L, -1L, "H", "Deuterium", true),
    T(1L, 2L, -1L, "D", "Tritium", true),
    He(2L, 2L, -1L, null, "Helium", false),
    He_3(2L, 1L, -1L, "H&D", "Helium-3", true),
    Li(3L, 4L, -1L, null, "Lithium", false),
    Be(4L, 5L, -1L, null, "Beryllium", false),
    B(5L, 5L, -1L, null, "Boron", false),
    C(6L, 6L, -1L, null, "Carbon", false),
    N(7L, 7L, -1L, null, "Nitrogen", false),
    O(8L, 8L, -1L, null, "Oxygen", false),
    F(9L, 9L, -1L, null, "Fluorine", false),
    Ne(10L, 10L, -1L, null, "Neon", false),
    Na(11L, 11L, -1L, null, "Sodium", false),
    Mg(12L, 12L, -1L, null, "Magnesium", false),
    Al(13L, 13L, -1L, null, "Aluminium", false),
    Si(14L, 14L, -1L, null, "Silicon", false),
    P(15L, 15L, -1L, null, "Phosphor", false),
    S(16L, 16L, -1L, null, "Sulfur", false),
    Cl(17L, 18L, -1L, null, "Chlorine", false),
    Ar(18L, 22L, -1L, null, "Argon", false),
    K(19L, 20L, -1L, null, "Potassium", false),
    Ca(20L, 20L, -1L, null, "Calcium", false),
    Sc(21L, 24L, -1L, null, "Scandium", false),
    Ti(22L, 26L, -1L, null, "Titanium", false),
    V(23L, 28L, -1L, null, "Vanadium", false),
    Cr(24L, 28L, -1L, null, "Chrome", false),
    Mn(25L, 30L, -1L, null, "Manganese", false),
    Fe(26L, 30L, -1L, null, "Iron", false),
    Co(27L, 32L, -1L, null, "Cobalt", false),
    Ni(28L, 30L, -1L, null, "Nickel", false),
    Cu(29L, 34L, -1L, null, "Copper", false),
    Zn(30L, 35L, -1L, null, "Zinc", false),
    Ga(31L, 39L, -1L, null, "Gallium", false),
    Ge(32L, 40L, -1L, null, "Germanium", false),
    As(33L, 42L, -1L, null, "Arsenic", false),
    Se(34L, 45L, -1L, null, "Selenium", false),
    Br(35L, 45L, -1L, null, "Bromine", false),
    Kr(36L, 48L, -1L, null, "Krypton", false),
    Rb(37L, 48L, -1L, null, "Rubidium", false),
    Sr(38L, 49L, -1L, null, "Strontium", false),
    Y(39L, 50L, -1L, null, "Yttrium", false),
    Zr(40L, 51L, -1L, null, "Zirconium", false),
    Nb(41L, 53L, -1L, null, "Niobium", false),
    Mo(42L, 53L, -1L, null, "Molybdenum", false),
    Tc(43L, 55L, -1L, null, "Technetium", false),
    Ru(44L, 57L, -1L, null, "Ruthenium", false),
    Rh(45L, 58L, -1L, null, "Rhodium", false),
    Pd(46L, 60L, -1L, null, "Palladium", false),
    Ag(47L, 60L, -1L, null, "Silver", false),
    Cd(48L, 64L, -1L, null, "Cadmium", false),
    In(49L, 65L, -1L, null, "Indium", false),
    Sn(50L, 68L, -1L, null, "Tin", false),
    Sb(51L, 70L, -1L, null, "Antimony", false),
    Te(52L, 75L, -1L, null, "Tellurium", false),
    I(53L, 74L, -1L, null, "Iodine", false),
    Xe(54L, 77L, -1L, null, "Xenon", false),
    Cs(55L, 77L, -1L, null, "Caesium", false),
    Ba(56L, 81L, -1L, null, "Barium", false),
    La(57L, 81L, -1L, null, "Lantanium", false),
    Ce(58L, 82L, -1L, null, "Cerium", false),
    Pr(59L, 81L, -1L, null, "Praseodymium", false),
    Nd(60L, 84L, -1L, null, "Neodymium", false),
    Pm(61L, 83L, -1L, null, "Promethium", false),
    Sm(62L, 88L, -1L, null, "Samarium", false),
    Eu(63L, 88L, -1L, null, "Europium", false),
    Gd(64L, 93L, -1L, null, "Gadolinium", false),
    Tb(65L, 93L, -1L, null, "Terbium", false),
    Dy(66L, 96L, -1L, null, "Dysprosium", false),
    Ho(67L, 97L, -1L, null, "Holmium", false),
    Er(68L, 99L, -1L, null, "Erbium", false),
    Tm(69L, 99L, -1L, null, "Thulium", false),
    Yb(70L, 103L, -1L, null, "Ytterbium", false),
    Lu(71L, 103L, -1L, null, "Lutetium", false),
    Hf(72L, 106L, -1L, null, "Hafnium", false),
    Ta(73L, 107L, -1L, null, "Tantalum", false),
    W(74L, 109L, -1L, null, "Wolframium", false),
    Re(75L, 111L, -1L, null, "Rhenium", false),
    Os(76L, 114L, -1L, null, "Osmium", false),
    Ir(77L, 115L, -1L, null, "Iridium", false),
    Pt(78L, 117L, -1L, null, "Platinum", false),
    Au(79L, 117L, -1L, null, "Gold", false),
    Hg(80L, 120L, -1L, null, "Mercury", false),
    Tl(81L, 123L, -1L, null, "Thallium", false),
    Pb(82L, 125L, -1L, null, "Lead", false),
    Bi(83L, 125L, -1L, null, "Bismuth", false),
    Po(84L, 124L, -1L, null, "Polonium", false),
    At(85L, 124L, -1L, null, "Astatine", false),
    Rn(86L, 134L, -1L, null, "Radon", false),
    Fr(87L, 134L, -1L, null, "Francium", false),
    Ra(88L, 136L, -1L, null, "Radium", false),
    Ac(89L, 136L, -1L, null, "Actinium", false),
    Th(90L, 140L, -1L, null, "Thorium", false),
    Pa(91L, 138L, -1L, null, "Protactinium", false),
    U(92L, 146L, -1L, null, "Uranium", false),
    U_235(92L, 143L, -1L, null, "Uranium-235", true),
    Np(93L, 144L, -1L, null, "Neptunium", false),
    Pu(94L, 152L, -1L, null, "Plutonium", false),
    Pu_241(94L, 149L, -1L, null, "Plutonium-241", true),
    Am(95L, 150L, -1L, null, "Americium", false),
    Cm(96L, 153L, -1L, null, "Curium", false),
    Bk(97L, 152L, -1L, null, "Berkelium", false),
    Cf(98L, 153L, -1L, null, "Californium", false),
    Es(99L, 153L, -1L, null, "Einsteinium", false),
    Fm(100L, 157L, -1L, null, "Fermium", false),
    Md(101L, 157L, -1L, null, "Mendelevium", false),
    No(102L, 157L, -1L, null, "Nobelium", false),
    Lr(103L, 159L, -1L, null, "Lawrencium", false),
    Rf(104L, 161L, -1L, null, "Rutherfordium", false),
    Db(105L, 163L, -1L, null, "Dubnium", false),
    Sg(106L, 165L, -1L, null, "Seaborgium", false),
    Bh(107L, 163L, -1L, null, "Bohrium", false),
    Hs(108L, 169L, -1L, null, "Hassium", false),
    Mt(109L, 167L, -1L, null, "Meitnerium", false),
    Ds(110L, 171L, -1L, null, "Darmstadtium", false),
    Rg(111L, 169L, -1L, null, "Roentgenium", false),
    Cn(112L, 173L, -1L, null, "Copernicium", false),
    Nh(113L, 171L, -1L, null, "Nihonium", false),
    Fl(114L, 175L, -1L, null, "Flerovium", false),
    Mc(115L, 173L, -1L, null, "Moscovium", false),
    Lv(116L, 177L, -1L, null, "Livermorium", false),
    Ts(117L, 177L, -1L, null, "Tennessine", false),
    Og(118L, 176L, -1L, null, "Oganesson", false),
    Tr(119L, 178L, -1L, null, "Tritanium", false),
    Dr(120L, 180L, -1L, null, "Duranium", false),
    Nq(121L, 172L, 140L, null, "Naquadah", true);

    public final String name;
    public final long protons;
    public final long neutrons;
    @ZenProperty(value="isotope")
    public final boolean isIsotope;
    @ZenProperty(value="halfLifeSeconds")
    public final long halfLifeSeconds;
    @ZenProperty(value="decayTo")
    public final String decayTo;

    private Element(long protons, long neutrons, long halfLifeSeconds, String decayTo, String name, boolean isIsotope) {
        this.protons = protons;
        this.neutrons = neutrons;
        this.halfLifeSeconds = halfLifeSeconds;
        this.decayTo = decayTo;
        this.name = name;
        this.isIsotope = isIsotope;
    }

    @ZenMethod
    public static Element get(String materialName) {
        try {
            return Element.valueOf(materialName);
        }
        catch (IllegalArgumentException notFound) {
            return H;
        }
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.name;
    }

    @ZenGetter(value="protons")
    public long getProtons() {
        return this.protons;
    }

    @ZenGetter(value="neutrons")
    public long getNeutrons() {
        return this.neutrons;
    }

    @ZenGetter(value="mass")
    public long getMass() {
        return this.protons + this.neutrons;
    }

    @ZenMethod
    public String toString() {
        return super.toString();
    }
}

