/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.material.FluidMaterial")
@ZenRegister
public class FluidMaterial
extends Material {
    @Nullable
    private Fluid materialFluid;
    @Nullable
    private Fluid materialPlasma;
    private int fluidTemperature = 300;

    public FluidMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element) {
        super(metaItemSubId, name, materialRGB, materialIconSet, materialComponents, materialGenerationFlags, element);
    }

    public FluidMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags) {
        super(metaItemSubId, name, materialRGB, materialIconSet, materialComponents, materialGenerationFlags, null);
    }

    @ZenGetter(value="hasFluid")
    public boolean shouldGenerateFluid() {
        return true;
    }

    @ZenGetter(value="hasPlasma")
    public boolean shouldGeneratePlasma() {
        return this.shouldGenerateFluid() && this.hasFlag(MatFlags.GENERATE_PLASMA);
    }

    @ZenGetter(value="isGaseous")
    public boolean isGas() {
        return this.hasFlag(MatFlags.STATE_GAS);
    }

    public final void setMaterialFluid(@Nonnull Fluid materialFluid) {
        Preconditions.checkNotNull((Object)materialFluid);
        this.materialFluid = materialFluid;
    }

    public final void setMaterialPlasma(@Nonnull Fluid materialPlasma) {
        Preconditions.checkNotNull((Object)materialPlasma);
        this.materialPlasma = materialPlasma;
    }

    @Nullable
    public final Fluid getMaterialFluid() {
        return this.materialFluid;
    }

    @Nullable
    public final Fluid getMaterialPlasma() {
        return this.materialPlasma;
    }

    @Nullable
    public final FluidStack getFluid(int amount) {
        return this.materialFluid == null ? null : new FluidStack(this.materialFluid, amount);
    }

    @Nullable
    public final FluidStack getPlasma(int amount) {
        return this.materialPlasma == null ? null : new FluidStack(this.materialPlasma, amount);
    }

    @ZenMethod(value="setFluidTemperature")
    public FluidMaterial setFluidTemperature(int fluidTemperature) {
        Preconditions.checkArgument((fluidTemperature > 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        this.fluidTemperature = fluidTemperature;
        return this;
    }

    @ZenGetter(value="fluidTemperature")
    public int getFluidTemperature() {
        return this.fluidTemperature;
    }

    @ZenGetter(value="fluid")
    @Optional.Method(modid="crafttweaker")
    @Nullable
    public ILiquidDefinition ctGetFluid() {
        Fluid materialFluid = this.getMaterialFluid();
        return materialFluid == null ? null : CraftTweakerMC.getILiquidDefinition((Fluid)materialFluid);
    }

    @ZenGetter(value="plasma")
    @Optional.Method(modid="crafttweaker")
    @Nullable
    public ILiquidDefinition ctGetPlasma() {
        Fluid materialFluid = this.getMaterialPlasma();
        return materialFluid == null ? null : CraftTweakerMC.getILiquidDefinition((Fluid)materialFluid);
    }

    public static final class MatFlags {
        public static final long GENERATE_FLUID_BLOCK = GTUtility.createFlag(44);
        public static final long GENERATE_PLASMA = GTUtility.createFlag(9);
        public static final long STATE_GAS = GTUtility.createFlag(10);

        static {
            Material.MatFlags.registerMaterialFlagsHolder(MatFlags.class, FluidMaterial.class);
        }
    }
}

