/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.items.IToolItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GTUtility {
    private static final Transformation REVERSE_HORIZONTAL_ROTATION = new Rotation(Math.PI, new Vector3(0.0, 1.0, 0.0)).at(Vector3.center);
    private static final Transformation REVERSE_VERTICAL_ROTATION = new Rotation(Math.PI, new Vector3(1.0, 0.0, 0.0)).at(Vector3.center);
    public static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public static <T> String[] mapToString(T[] array, Function<T, String> mapper) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, Class<R> declaringClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != declaringClass) {
            if (type instanceof ParameterizedType) {
                type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                continue;
            }
            type = ((Class)type).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static PotionEffect copyPotionEffect(PotionEffect sample) {
        PotionEffect potionEffect = new PotionEffect(sample.func_188419_a(), sample.func_76459_b(), sample.func_76458_c(), sample.func_82720_e(), sample.func_188418_e());
        potionEffect.setCurativeItems(sample.getCurativeItems());
        return potionEffect;
    }

    public static EnumDyeColor determineDyeColor(int rgbColor) {
        Color c = new Color(rgbColor);
        HashMap<Double, EnumDyeColor> distances = new HashMap<Double, EnumDyeColor>();
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            Color c2 = new Color(dyeColor.field_193351_w);
            double distance = (c.getRed() - c2.getRed()) * (c.getRed() - c2.getRed()) + (c.getGreen() - c2.getGreen()) * (c.getGreen() - c2.getGreen()) + (c.getBlue() - c2.getBlue()) * (c.getBlue() - c2.getBlue());
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (EnumDyeColor)distances.get(min);
    }

    public static int convertRGBtoOpaqueRGBA_CL(int colorValue) {
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | 0xFF;
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue) {
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static void setItem(ItemStack itemStack, ItemStack newStack) {
        try {
            Field itemField = Arrays.stream(ItemStack.class.getDeclaredFields()).filter(field -> field.getType() == Item.class).findFirst().orElseThrow(ReflectiveOperationException::new);
            itemField.setAccessible(true);
            itemField.set(itemStack, newStack.func_77973_b());
            itemStack.func_77964_b(newStack.func_77952_i());
            itemStack.func_77982_d(newStack.func_77978_p());
            Method forgeInit = ItemStack.class.getDeclaredMethod("forgeInit", new Class[0]);
            forgeInit.setAccessible(true);
            forgeInit.invoke((Object)itemStack, new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int getActualItemDamageFromStack(ItemStack itemStack) {
        return Items.field_151008_G.getDamage(itemStack);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.func_75214_a(itemStack) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.func_77976_d(), slot.func_178170_b(stackInSlot));
            int amountToInsert = Math.min(itemStack.func_190916_E(), slotMaxStackSize - stackInSlot.func_190916_E());
            if (amountToInsert == 0) continue;
            stackInSlot.func_190917_f(amountToInsert);
            itemStack.func_190918_g(amountToInsert);
            slot.func_75218_e();
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.func_75214_a(itemStack) || slot.func_75216_d() || (amountToInsert = Math.min(itemStack.func_190916_E(), slot.func_178170_b(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.func_77979_a(amountToInsert);
            slot.func_75215_d(stackInSlot);
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return merged;
    }

    public static boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos)) {
            return false;
        }
        if (!blockState.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player)) {
            return false;
        }
        int expToDrop = 0;
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            expToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
            if (expToDrop == -1) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                return false;
            }
        }
        world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
        boolean wasRemovedByPlayer = blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, !player.field_71075_bZ.field_75098_d);
        if (wasRemovedByPlayer) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack stackInHand = player.func_184614_ca();
                blockState.func_177230_c().func_180657_a(world, player, pos, blockState, tileEntity, stackInHand);
                if (expToDrop > 0) {
                    blockState.func_177230_c().func_180637_b(world, pos, expToDrop);
                }
            }
        }
        if (!world.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, mc.field_71476_x.field_178784_b));
        }
        return wasRemovedByPlayer;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCenteredSizedText(int x, int y, String string, int color, double sizeMultiplier) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(string);
        int textHeight = fontRenderer.field_78288_b;
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)sizeMultiplier, (double)sizeMultiplier, (double)0.0);
        GlStateManager.func_179137_b((double)((double)(-textWidth) * sizeMultiplier / 2.0), (double)((double)(-textHeight) * sizeMultiplier / 2.0), (double)0.0);
        fontRenderer.func_78276_b(string, x, y, color);
        GlStateManager.func_179121_F();
    }

    public static boolean doDamageItem(ItemStack itemStack, int vanillaDamage, boolean simulate) {
        Item item = itemStack.func_77973_b();
        if (item instanceof IToolItem) {
            IToolItem damagableItem = (IToolItem)item;
            return damagableItem.damageItem(itemStack, vanillaDamage, simulate);
        }
        if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            int energyNeeded;
            IElectricItem capability = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            return capability.discharge(energyNeeded = vanillaDamage * ConfigHolder.energyUsageMultiplier, Integer.MAX_VALUE, true, false, simulate) == (long)energyNeeded;
        }
        if (itemStack.func_77984_f()) {
            if (!simulate && itemStack.func_96631_a(vanillaDamage, new Random(), null)) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public static void writeItems(IItemHandler handler, String tagName, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a("Slot", i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, String tagName, NBTTagCompound tag) {
        if (tag.func_74764_b(tagName)) {
            NBTTagList tagList = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e("Slot");
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, new ItemStack(tagList.func_150305_b(i)));
            }
        }
    }

    public static boolean isBetweenInclusive(long start, long end, long value) {
        return start <= value && value <= end;
    }

    public static String capitalizeString(String string) {
        if (string != null && string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return "";
    }

    public static byte getTierByVoltage(long voltage) {
        byte tier = 0;
        while ((tier = (byte)((byte)(tier + 1))) < GTValues.V.length) {
            if (voltage == GTValues.V[tier]) {
                return tier;
            }
            if (voltage >= GTValues.V[tier]) continue;
            return (byte)Math.max(0, tier - 1);
        }
        return tier;
    }

    public static BiomeDictionary.Type getBiomeTypeTagByName(String name) {
        Map byName = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String[])new String[]{"byName"});
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static List<Tuple<ItemStack, Integer>> getGrassSeedEntries() {
        ArrayList<Tuple<ItemStack, Integer>> result = new ArrayList<Tuple<ItemStack, Integer>>();
        try {
            Field seedListField = ForgeHooks.class.getDeclaredField("seedList");
            seedListField.setAccessible(true);
            Class<?> seedEntryClass = Class.forName("net.minecraftforge.common.ForgeHooks$SeedEntry");
            Field seedField = seedEntryClass.getDeclaredField("seed");
            seedField.setAccessible(true);
            List seedList = (List)seedListField.get(null);
            for (WeightedRandom.Item seedEntryObject : seedList) {
                ItemStack seedStack = (ItemStack)seedField.get(seedEntryObject);
                int chanceValue = seedEntryObject.field_76292_a;
                if (seedStack.func_190926_b()) continue;
                result.add((Tuple<ItemStack, Integer>)new Tuple((Object)seedStack, (Object)chanceValue));
            }
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to get forge grass seed list", (Throwable)exception);
        }
        return result;
    }

    public static <T> int getRandomItem(Random random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.nextInt(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    @Nullable
    public static EnumFacing determineWrenchingSide(EnumFacing facing, float x, float y, float z) {
        EnumFacing opposite = facing.func_176734_d();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)z < 0.25) {
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    return EnumFacing.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.SOUTH;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
        }
        return null;
    }

    public static List<ItemStack> itemHandlerToList(final IItemHandlerModifiable inputs) {
        return new AbstractList<ItemStack>(){

            @Override
            public ItemStack set(int index, ItemStack element) {
                ItemStack oldStack = inputs.getStackInSlot(index);
                inputs.setStackInSlot(index, element == null ? ItemStack.field_190927_a : element);
                return oldStack;
            }

            @Override
            public ItemStack get(int index) {
                return inputs.getStackInSlot(index);
            }

            @Override
            public int size() {
                return inputs.getSlots();
            }
        };
    }

    public static List<FluidStack> fluidHandlerToList(IMultipleTankHandler fluidInputs) {
        final List<IFluidTank> backedList = fluidInputs.getFluidTanks();
        return new AbstractList<FluidStack>(){

            @Override
            public FluidStack set(int index, FluidStack element) {
                IFluidTank fluidTank = (IFluidTank)backedList.get(index);
                FluidStack oldStack = fluidTank.getFluid();
                if (!(fluidTank instanceof FluidTank)) {
                    return oldStack;
                }
                ((FluidTank)backedList.get(index)).setFluid(element);
                return oldStack;
            }

            @Override
            public FluidStack get(int index) {
                return ((IFluidTank)backedList.get(index)).getFluid();
            }

            @Override
            public int size() {
                return backedList.size();
            }
        };
    }

    public static List<EntityPlayerMP> findPlayersUsing(MetaTileEntity metaTileEntity, double radius) {
        ArrayList<EntityPlayerMP> result = new ArrayList<EntityPlayerMP>();
        AxisAlignedBB box = new AxisAlignedBB(metaTileEntity.getPos()).func_72321_a(radius, radius, radius);
        List entities = metaTileEntity.getWorld().func_72872_a(EntityPlayerMP.class, box);
        for (EntityPlayerMP player : entities) {
            if (!(player.field_71070_bA instanceof ModularUIContainer)) continue;
            ModularUI modularUI = ((ModularUIContainer)player.field_71070_bA).getModularUI();
            if (!(modularUI.holder instanceof MetaTileEntityHolder) || ((MetaTileEntityHolder)modularUI.holder).getMetaTileEntity() != metaTileEntity) continue;
            result.add(player);
        }
        return result;
    }

    public static <T> boolean iterableContains(Iterable<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static int amountOfNonNullElements(List<?> collection) {
        int amount = 0;
        for (Object object : collection) {
            if (object == null) continue;
            ++amount;
        }
        return amount;
    }

    public static int amountOfNonEmptyStacks(List<ItemStack> collection) {
        int amount = 0;
        for (ItemStack object : collection) {
            if (object == null || object.func_190926_b()) continue;
            ++amount;
        }
        return amount;
    }

    public static NBTTagCompound getOrCreateNbtCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return compound == null ? new NBTTagCompound() : compound;
    }

    public static NonNullList<ItemStack> copyStackList(List<ItemStack> itemStacks) {
        Object[] stacks = new ItemStack[itemStacks.size()];
        for (int i = 0; i < itemStacks.size(); ++i) {
            stacks[i] = GTUtility.copy(itemStacks.get(i));
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public static List<FluidStack> copyFluidList(List<FluidStack> fluidStacks) {
        Object[] stacks = new FluidStack[fluidStacks.size()];
        for (int i = 0; i < fluidStacks.size(); ++i) {
            stacks[i] = fluidStacks.get(i).copy();
        }
        return Lists.newArrayList((Object[])stacks);
    }

    public static ItemStack copy(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack copyAmount(int amount, ItemStack ... stacks) {
        ItemStack stack = GTUtility.copy(stacks);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.func_190920_e(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        FluidStack stack = fluidStack.copy();
        stack.amount = amount;
        return stack;
    }

    public static <T extends Comparable<T>> IBlockState[] getAllPropertyValues(IBlockState blockState, IProperty<T> property) {
        Collection allowedValues = property.func_177700_c();
        IBlockState[] resultArray = new IBlockState[allowedValues.size()];
        int index = 0;
        for (Comparable propertyValue : allowedValues) {
            resultArray[index++] = blockState.func_177226_a(property, propertyValue);
        }
        return resultArray;
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList::builder, ImmutableList.Builder::add, (b1, b2) -> {
            b1.addAll((Iterable)b2.build());
            return b2;
        }, ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <M, E extends M> E selectItemInList(int index, E replacement, List<? extends M> list, Class<E> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (minClass.isAssignableFrom(maybeResult.getClass())) {
            return minClass.cast(maybeResult);
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static long createFlag(int id) {
        return 1L << id;
    }

    public static void doOvervoltageExplosion(MetaTileEntity metaTileEntity, long voltage) {
        BlockPos pos = metaTileEntity.getPos();
        metaTileEntity.getWorld().func_175698_g(pos);
        if (!metaTileEntity.getWorld().field_72995_K) {
            double posX = (double)pos.func_177958_n() + 0.5;
            double posY = (double)pos.func_177956_o() + 0.5;
            double posZ = (double)pos.func_177952_p() + 0.5;
            ((WorldServer)metaTileEntity.getWorld()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 10, 0.2, 0.2, 0.2, 0.0, new int[0]);
            metaTileEntity.getWorld().func_72876_a(null, posX, posY, posZ, (float)GTUtility.getTierByVoltage(voltage), ConfigHolder.doExplosions);
        }
    }

    public static int getRedstonePower(World world, BlockPos blockPos, EnumFacing side) {
        BlockPos offsetPos = blockPos.func_177972_a(side);
        int worldPower = world.func_175651_c(offsetPos, side);
        if (worldPower >= 15) {
            return worldPower;
        }
        IBlockState offsetState = world.func_180495_p(offsetPos);
        if (offsetState.func_177230_c() instanceof BlockRedstoneWire) {
            int wirePower = (Integer)offsetState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            return Math.max(worldPower, wirePower);
        }
        return worldPower;
    }
}

