/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class LongItemStack {
    private final ItemStack itemStack;

    public LongItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public LongItemStack(NBTTagCompound tagCompound) {
        this.itemStack = new ItemStack(tagCompound);
        this.itemStack.func_190920_e(tagCompound.func_74762_e("Count"));
    }

    public int getStackSize() {
        return this.itemStack.func_190916_E();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        this.itemStack.func_77955_b(tagCompound);
        tagCompound.func_74768_a("Count", this.itemStack.func_190916_E());
        return tagCompound;
    }

    public void writeItemStack(PacketBuffer packetBuffer) {
        if (this.itemStack.func_190926_b()) {
            packetBuffer.writeShort(-1);
        } else {
            packetBuffer.writeShort(Item.func_150891_b((Item)this.itemStack.func_77973_b()));
            packetBuffer.func_150787_b(this.itemStack.func_190916_E());
            packetBuffer.writeShort(this.itemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (this.itemStack.func_77973_b().func_77645_m() || this.itemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = this.itemStack.func_77973_b().getNBTShareTag(this.itemStack);
            }
            packetBuffer.func_150786_a(nbttagcompound);
        }
    }

    public static LongItemStack readItemStack(PacketBuffer packetBuffer) {
        short itemId = packetBuffer.readShort();
        if (itemId < 0) {
            return new LongItemStack(ItemStack.field_190927_a);
        }
        int stackSize = packetBuffer.func_150792_a();
        short metadata = packetBuffer.readShort();
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)itemId), stackSize, (int)metadata);
        try {
            itemStack.func_77973_b().readNBTShareTag(itemStack, packetBuffer.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new LongItemStack(itemStack);
    }
}

