/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.gui.ISizeProvider;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    private static Stack<int[]> scissorFrameStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useScissor(ISizeProvider provider, int x, int y, int width, int height, Runnable codeBlock) {
        RenderUtil.pushScissorFrame(x += provider.getGuiLeft(), y += provider.getGuiTop(), width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtil.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            return new int[]{0, 0, minecraft.field_71443_c, minecraft.field_71440_d};
        }
        return currentTopFrame;
    }

    public static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = RenderUtil.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = x >= parentX ? x : parentX;
            int newY = y >= parentY ? y : parentY;
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = maxWidth > newWidth ? newWidth : maxWidth;
                newHeight = maxHeight > newHeight ? newHeight : maxHeight;
                RenderUtil.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    public static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = RenderUtil.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        RenderUtil.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        ScaledResolution r = ((GuiIngameForge)Minecraft.func_71410_x().field_71456_v).getResolution();
        int s = r.func_78325_e();
        int translatedY = r.func_78328_b() - y - h;
        GL11.glScissor((int)(x * s), (int)(translatedY * s), (int)(w * s), (int)(h * s));
    }
}

