/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.ElectricItem;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedOreEnergyTransferRecipe
extends ShapedOreRecipe {
    private final Predicate<ItemStack> chargePredicate;
    private final boolean transferMaxCharge;

    public ShapedOreEnergyTransferRecipe(ResourceLocation group, @Nonnull ItemStack result, Predicate<ItemStack> chargePredicate, boolean transferMaxCharge, Object ... recipe) {
        this(group, result, chargePredicate, transferMaxCharge, CraftingHelper.parseShaped((Object[])recipe));
    }

    public ShapedOreEnergyTransferRecipe(ResourceLocation group, @Nonnull ItemStack result, Predicate<ItemStack> chargePredicate, boolean transferMaxCharge, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
        this.chargePredicate = chargePredicate;
        this.transferMaxCharge = transferMaxCharge;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        ItemStack resultStack = super.func_77572_b(inventoryCrafting);
        ShapedOreEnergyTransferRecipe.chargeStackFromComponents(resultStack, (IInventory)inventoryCrafting, this.chargePredicate, this.transferMaxCharge);
        return resultStack;
    }

    public static void chargeStackFromComponents(ItemStack toolStack, IInventory ingredients, Predicate<ItemStack> chargePredicate, boolean transferMaxCharge) {
        IElectricItem electricItem = (IElectricItem)toolStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        long totalMaxCharge = 0L;
        if (electricItem != null && electricItem.getMaxCharge() > 0L) {
            for (int slotIndex = 0; slotIndex < ingredients.func_70302_i_(); ++slotIndex) {
                IElectricItem batteryItem;
                ItemStack stackInSlot = ingredients.func_70301_a(slotIndex);
                if (!chargePredicate.test(stackInSlot) || (batteryItem = (IElectricItem)stackInSlot.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) == null) continue;
                totalMaxCharge += batteryItem.getMaxCharge();
                long discharged = batteryItem.discharge(Long.MAX_VALUE, Integer.MAX_VALUE, true, true, false);
                electricItem.charge(discharged, Integer.MAX_VALUE, true, false);
                if (discharged <= 0L) continue;
                ingredients.func_70299_a(slotIndex, stackInSlot);
            }
        }
        if (electricItem instanceof ElectricItem && transferMaxCharge) {
            ((ElectricItem)electricItem).setMaxChargeOverride(totalMaxCharge);
        }
    }
}

