/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.StoneType;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreConfigUtils {
    public static List<IBlockState> getOreDictBlocks(String oreDictName) {
        List<ItemStack> allOres = OreDictUnifier.getAllWithOreDictionaryName(oreDictName);
        ArrayList<IBlockState> allBlocks = new ArrayList<IBlockState>();
        for (ItemStack oreStack : allOres) {
            Block itemStackBlock = Block.func_149634_a((Item)oreStack.func_77973_b());
            if (itemStackBlock == Blocks.field_150350_a) continue;
            int placementMetadata = oreStack.func_77973_b().func_77647_b(oreStack.func_77960_j());
            IBlockState placementState = itemStackBlock.func_176203_a(placementMetadata);
            allBlocks.add(placementState);
        }
        if (allBlocks.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find any blocks matching " + oreDictName + " oredict tag");
        }
        return allBlocks;
    }

    public static Map<StoneType, IBlockState> getOreStateMap(String stringDeclaration) {
        if (!stringDeclaration.startsWith("ore:")) {
            throw new IllegalArgumentException("Invalid string ore declaration: " + stringDeclaration);
        }
        String materialName = stringDeclaration.substring(4);
        DustMaterial material = OreConfigUtils.getMaterialByName(materialName);
        return OreConfigUtils.getOreForMaterial(material);
    }

    public static Map<StoneType, IBlockState> getOreForMaterial(DustMaterial material) {
        List oreBlocks = MetaBlocks.ORES.stream().filter(ore -> ore.material == material).collect(Collectors.toList());
        HashMap<StoneType, IBlockState> stoneTypeMap = new HashMap<StoneType, IBlockState>();
        for (BlockOre blockOre : oreBlocks) {
            for (StoneType stoneType : blockOre.STONE_TYPE.getAllowedValues()) {
                IBlockState blockState = blockOre.getOreBlock(stoneType);
                stoneTypeMap.put(stoneType, blockState);
            }
        }
        if (stoneTypeMap.isEmpty()) {
            throw new IllegalArgumentException("There is no ore generated for material " + material);
        }
        return stoneTypeMap;
    }

    public static DustMaterial getMaterialByName(String name) {
        Material material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(name);
        if (!(material instanceof DustMaterial)) {
            throw new IllegalArgumentException("Material with name " + name + " not found!");
        }
        return (DustMaterial)material;
    }

    public static Block getBlockByName(String name) {
        ResourceLocation blockName = new ResourceLocation(name);
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(blockName);
        if (block == null) {
            throw new IllegalArgumentException("Block with identifier " + blockName + " not found!");
        }
        return block;
    }

    public static int[] getIntRange(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray dataArray = element.getAsJsonArray();
            int max = dataArray.get(1).getAsInt();
            int min = Math.min(max, dataArray.get(0).getAsInt());
            return new int[]{min, max};
        }
        if (element.isJsonObject()) {
            JsonObject dataObject = element.getAsJsonObject();
            int max = dataObject.get("max").getAsInt();
            int min = Math.min(max, dataObject.get("min").getAsInt());
            return new int[]{min, max};
        }
        if (element.isJsonPrimitive()) {
            int size = element.getAsInt();
            return new int[]{size, size};
        }
        throw new IllegalArgumentException("size range not defined");
    }
}

