/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.common.base.Optional;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.WorldBlockPredicate;
import gregtech.api.worldgen.config.OreConfigUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class PredicateConfigUtils {
    public static IBlockState parseBlockStateDefinition(JsonObject object) {
        Block block = OreConfigUtils.getBlockByName(object.get("block").getAsString());
        IBlockState blockState = block.func_176223_P();
        for (IProperty property : block.func_176194_O().func_177623_d()) {
            JsonElement valueElement = object.get(property.func_177701_a());
            if (valueElement == null || !valueElement.isJsonPrimitive()) continue;
            String stringValue = valueElement.getAsString();
            Optional parsedValue = property.func_185929_b(stringValue);
            if (!parsedValue.isPresent()) {
                throw new IllegalArgumentException("Couldn't parse property " + property.func_177701_a() + " value " + valueElement);
            }
            IProperty areYouFuckingSerious = property;
            Comparable fuckJava = (Comparable)parsedValue.get();
            blockState = blockState.func_177226_a(areYouFuckingSerious, fuckJava);
        }
        return blockState;
    }

    private static WorldBlockPredicate createSimpleStatePredicate(String stringDeclaration) {
        if (stringDeclaration.equals("any")) {
            return (state, world, pos) -> true;
        }
        if (stringDeclaration.equals("stone_type")) {
            return (state, world, pos) -> StoneType.computeStoneType(state, world, pos) != null;
        }
        if (stringDeclaration.startsWith("stone_type:")) {
            String typeName = stringDeclaration.substring(11);
            return (state, world, pos) -> {
                StoneType stoneType = StoneType.computeStoneType(state, world, pos);
                return stoneType != null && stoneType.name.equalsIgnoreCase(typeName);
            };
        }
        if (stringDeclaration.startsWith("block:")) {
            Block block = OreConfigUtils.getBlockByName(stringDeclaration.substring(6));
            return (state, world, pos) -> state.func_177230_c() == block;
        }
        if (stringDeclaration.startsWith("ore_dict:")) {
            String oreDictName = stringDeclaration.substring(9);
            List<IBlockState> allMatching = OreConfigUtils.getOreDictBlocks(oreDictName);
            return (state, world, pos) -> allMatching.contains(state);
        }
        throw new IllegalArgumentException("Unknown string block state predicate: " + stringDeclaration);
    }

    public static WorldBlockPredicate createBlockStatePredicate(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            String stringDeclaration = element.getAsString();
            return PredicateConfigUtils.createSimpleStatePredicate(stringDeclaration);
        }
        if (element instanceof JsonObject) {
            JsonObject object = element.getAsJsonObject();
            if (!object.has("block")) {
                throw new IllegalArgumentException("Block state predicate missing required block key!");
            }
            Predicate<IBlockState> predicate = PredicateConfigUtils.parseBlockStatePropertyPredicate(object);
            return (state, world, pos) -> predicate.test(state);
        }
        if (element instanceof JsonArray) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<WorldBlockPredicate> allPredicates = new ArrayList<WorldBlockPredicate>();
            for (JsonElement arrayElement : array) {
                allPredicates.add(PredicateConfigUtils.createBlockStatePredicate(arrayElement));
            }
            return (state, world, pos) -> allPredicates.stream().anyMatch(p -> p.test(state, world, pos));
        }
        throw new IllegalArgumentException("Unsupported block state variant predicate type: " + element);
    }

    private static Predicate<IBlockState> parseBlockStatePropertyPredicate(JsonObject object) {
        Block block = OreConfigUtils.getBlockByName(object.get("block").getAsString());
        HashMap allowedValues = new HashMap();
        for (IProperty property : block.func_176194_O().func_177623_d()) {
            JsonElement valueElement = object.get(property.func_177701_a());
            if (valueElement == null) continue;
            if (valueElement.isJsonPrimitive()) {
                JsonElement singleValue = valueElement;
                valueElement = new JsonArray();
                valueElement.getAsJsonArray().add(singleValue);
            }
            if (!valueElement.isJsonArray()) continue;
            ArrayList<Object> allValues = new ArrayList<Object>();
            JsonArray valuesArray = valueElement.getAsJsonArray();
            boolean isBlacklist = false;
            for (JsonElement allowedValue : valuesArray) {
                Optional parsedValue;
                String elementValue = allowedValue.getAsString();
                if (elementValue.startsWith("!")) {
                    elementValue = elementValue.substring(1);
                    isBlacklist = true;
                }
                if (!(parsedValue = property.func_185929_b(elementValue)).isPresent()) {
                    throw new IllegalArgumentException("Couldn't parse property " + property.func_177701_a() + " value " + valueElement);
                }
                allValues.add(parsedValue.get());
            }
            if (isBlacklist) {
                ArrayList<Object> blacklistValues = allValues;
                allValues = new ArrayList(property.func_177700_c());
                allValues.removeAll(blacklistValues);
            }
            allowedValues.put(property, allValues);
        }
        return blockState -> {
            for (IProperty property : blockState.func_177227_a()) {
                if (!allowedValues.containsKey(property)) continue;
                Comparable propertyValue = blockState.func_177229_b(property);
                if (((List)allowedValues.get(property)).contains(propertyValue)) continue;
                return false;
            }
            return true;
        };
    }
}

