/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.generator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gregtech.api.util.GTUtility;
import gregtech.api.util.XSTR;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.api.worldgen.generator.GTWorldGenCapability;
import gregtech.api.worldgen.generator.GridEntryInfo;
import gregtech.api.worldgen.populator.IBlockModifierAccess;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.VeinBufferPopulator;
import gregtech.api.worldgen.populator.VeinChunkPopulator;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class CachedGridEntry
implements GridEntryInfo,
IBlockGeneratorAccess,
IBlockModifierAccess {
    private static final Map<World, Cache<Long, CachedGridEntry>> gridEntryCache = new WeakHashMap<World, Cache<Long, CachedGridEntry>>();
    private final TLongObjectMap<ChunkDataEntry> dataByChunkPos = new TLongObjectHashMap();
    private static final Comparator<OreDepositDefinition> COMPARATOR = Comparator.comparing(OreDepositDefinition::getPriority).reversed();
    private static final BlockPos[] CHUNK_CORNER_SPOTS = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(15, 0, 0), new BlockPos(0, 0, 15), new BlockPos(15, 0, 15)};
    private final Random gridRandom;
    private final int gridX;
    private final int gridZ;
    private List<Map.Entry<Integer, OreDepositDefinition>> cachedDepositMap;
    private GTWorldGenCapability masterEntry;
    private int worldSeaLevel;
    private Map<OreDepositDefinition, BlockPos> veinGeneratedMap;
    private int veinCenterX;
    private int veinCenterY;
    private int veinCenterZ;
    private OreDepositDefinition currentOreVein;

    public static CachedGridEntry getOrCreateEntry(World world, int gridX, int gridZ, int primerChunkX, int primerChunkZ) {
        Long gridEntryKey;
        CachedGridEntry gridEntry;
        Cache<Long, CachedGridEntry> currentValue = gridEntryCache.get(world);
        if (currentValue == null) {
            currentValue = CachedGridEntry.createGridCache();
            gridEntryCache.put(world, currentValue);
        }
        if ((gridEntry = (CachedGridEntry)currentValue.getIfPresent((Object)(gridEntryKey = Long.valueOf((long)gridX << 32 | (long)gridZ & 0xFFFFFFFFL)))) == null) {
            gridEntry = new CachedGridEntry(world, gridX, gridZ, primerChunkX, primerChunkZ);
            currentValue.put((Object)gridEntryKey, (Object)gridEntry);
        }
        return gridEntry;
    }

    private static Cache<Long, CachedGridEntry> createGridCache() {
        return CacheBuilder.newBuilder().maximumSize(300L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    public CachedGridEntry(World world, int gridX, int gridZ, int primerChunkX, int primerChunkZ) {
        this.gridX = gridX;
        this.gridZ = gridZ;
        long worldSeed = world.func_72905_C();
        this.gridRandom = new XSTR(961 * gridX + gridZ * 31 + Long.hashCode(worldSeed));
        int gridSizeX = 48;
        int gridSizeZ = 48;
        BlockPos blockPos = new BlockPos(gridX * gridSizeX + gridSizeX / 2, world.func_72940_L(), gridZ * gridSizeZ + gridSizeZ / 2);
        Biome currentBiome = world.func_72959_q().func_180631_a(blockPos);
        this.cachedDepositMap = new ArrayList<Map.Entry<Integer, OreDepositDefinition>>(WorldGenRegistry.INSTANCE.getCachedBiomeVeins(world.field_73011_w, currentBiome));
        this.worldSeaLevel = world.func_181545_F();
        this.masterEntry = this.searchMasterOrNull(world);
        if (this.masterEntry == null) {
            Chunk primerChunk = world.func_72964_e(primerChunkX, primerChunkZ);
            BlockPos heightSpot = this.findOptimalSpot(gridX, gridZ, primerChunkX, primerChunkZ);
            int masterHeight = world.func_175645_m(heightSpot).func_177956_o();
            int masterBottomHeight = world.func_175672_r(heightSpot).func_177956_o();
            this.masterEntry = (GTWorldGenCapability)primerChunk.getCapability(GTWorldGenCapability.CAPABILITY, null);
            this.masterEntry = new GTWorldGenCapability();
            this.masterEntry.setMaxHeight(masterHeight, masterBottomHeight);
        }
        this.triggerVeinsGeneration();
    }

    private BlockPos findOptimalSpot(int gridX, int gridZ, int chunkX, int chunkZ) {
        int gridCenterX = (gridX * 3 + 1) * 16 + 7;
        int gridCenterZ = (gridZ * 3 + 1) * 16 + 7;
        int chunkBaseX = chunkX * 16;
        int chunkBaseZ = chunkZ * 16;
        BlockPos mostClosePos = null;
        double mostCloseDistance = Double.MAX_VALUE;
        for (BlockPos pos : CHUNK_CORNER_SPOTS) {
            double diffZ;
            double diffX = chunkBaseX + pos.func_177958_n() - gridCenterX;
            double distance = diffX * diffX + (diffZ = (double)(chunkBaseZ + pos.func_177952_p() - gridCenterZ)) * diffZ;
            if (!(mostCloseDistance > distance)) continue;
            mostCloseDistance = distance;
            mostClosePos = pos;
        }
        return mostClosePos;
    }

    private GTWorldGenCapability searchMasterOrNull(World world) {
        int gridSizeX = 3;
        int gridSizeZ = 3;
        int startChunkX = this.gridX * gridSizeX;
        int startChunkZ = this.gridZ * gridSizeZ;
        for (int x = 0; x < gridSizeX; ++x) {
            for (int z = 0; z < gridSizeZ; ++z) {
                int chunkX = startChunkX + x;
                int chunkZ = startChunkZ + z;
                if (!world.func_190526_b(chunkX, chunkZ)) continue;
                return this.retrieveCapability(world, chunkX, chunkZ);
            }
        }
        return null;
    }

    @Override
    public int getTerrainHeight() {
        return this.masterEntry.getMaxHeight();
    }

    @Override
    public int getBottomHeight() {
        return this.masterEntry.getMaxBottomHeight();
    }

    @Override
    public int getSeaLevel() {
        return this.worldSeaLevel;
    }

    @Override
    public Set<OreDepositDefinition> getGeneratedVeins() {
        return this.veinGeneratedMap.keySet();
    }

    @Override
    public BlockPos getCenterPos(OreDepositDefinition definition) {
        return this.veinGeneratedMap.get(definition);
    }

    public boolean populateChunk(World world, int chunkX, int chunkZ, Random random) {
        long chunkId = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
        ChunkDataEntry chunkDataEntry = (ChunkDataEntry)this.dataByChunkPos.get(chunkId);
        GTWorldGenCapability capability = this.retrieveCapability(world, chunkX, chunkZ);
        capability.setFrom(this.masterEntry);
        if (chunkDataEntry != null && chunkDataEntry.populateChunk(world)) {
            for (OreDepositDefinition definition : chunkDataEntry.generatedOres) {
                IVeinPopulator veinPopulator = definition.getVeinPopulator();
                if (!(veinPopulator instanceof VeinChunkPopulator)) continue;
                ((VeinChunkPopulator)veinPopulator).populateChunk(world, chunkX, chunkZ, random, definition, this);
            }
            return true;
        }
        return false;
    }

    private GTWorldGenCapability retrieveCapability(World world, int chunkX, int chunkZ) {
        return (GTWorldGenCapability)world.func_72964_e(chunkX, chunkZ).getCapability(GTWorldGenCapability.CAPABILITY, null);
    }

    public void triggerVeinsGeneration() {
        this.veinGeneratedMap = new HashMap<OreDepositDefinition, BlockPos>();
        if (!this.cachedDepositMap.isEmpty()) {
            int maxCycles = ConfigHolder.minVeinsInSection + (ConfigHolder.additionalVeinsInSection == 0 ? 0 : this.gridRandom.nextInt(ConfigHolder.additionalVeinsInSection + 1));
            ArrayList<OreDepositDefinition> veins = new ArrayList<OreDepositDefinition>();
            for (int currentCycle = 0; currentCycle < this.cachedDepositMap.size() && currentCycle < maxCycles; ++currentCycle) {
                int randomEntryIndex = GTUtility.getRandomItem(this.gridRandom, this.cachedDepositMap, this.cachedDepositMap.size() - currentCycle);
                OreDepositDefinition randomEntry = this.cachedDepositMap.get(randomEntryIndex).getValue();
                Collections.swap(this.cachedDepositMap, randomEntryIndex, this.cachedDepositMap.size() - 1 - currentCycle);
                veins.add(randomEntry);
                if (randomEntry.isVein()) continue;
                ++maxCycles;
            }
            veins.sort(COMPARATOR);
            for (OreDepositDefinition depositDefinition : veins) {
                this.doGenerateVein(depositDefinition);
            }
        }
    }

    private void doGenerateVein(OreDepositDefinition definition) {
        this.currentOreVein = definition;
        int gridSizeX = 48;
        int gridSizeZ = 48;
        int topHeightOffset = this.currentOreVein.getShapeGenerator().getMaxSize().func_177956_o() / 2 + 4;
        int maximumHeight = Math.min(this.masterEntry.getMaxBottomHeight(), this.currentOreVein.getHeightLimit()[1] - topHeightOffset);
        int minimumHeight = Math.max(3, this.currentOreVein.getHeightLimit()[0]);
        if (minimumHeight >= maximumHeight) {
            return;
        }
        this.veinCenterX = this.gridX * gridSizeX + this.gridRandom.nextInt(gridSizeX);
        this.veinCenterY = minimumHeight + this.gridRandom.nextInt(maximumHeight - minimumHeight);
        this.veinCenterZ = this.gridZ * gridSizeZ + this.gridRandom.nextInt(gridSizeZ);
        this.currentOreVein.getShapeGenerator().generate(this.gridRandom, this);
        this.veinGeneratedMap.put(definition, new BlockPos(this.veinCenterX, this.veinCenterY, this.veinCenterZ));
        IVeinPopulator veinPopulator = this.currentOreVein.getVeinPopulator();
        if (veinPopulator instanceof VeinBufferPopulator) {
            ((VeinBufferPopulator)veinPopulator).populateBlockBuffer(this.gridRandom, this, this, this.currentOreVein);
        }
        this.currentOreVein = null;
    }

    @Override
    public boolean generateBlock(int x, int y, int z) {
        if (this.currentOreVein == null) {
            throw new IllegalStateException("Attempted to call generateBlock without current ore vein!");
        }
        int globalBlockX = this.veinCenterX + x;
        int globalBlockY = this.veinCenterY + y;
        int globalBlockZ = this.veinCenterZ + z;
        float randomDensityValue = this.gridRandom.nextFloat();
        if (this.currentOreVein.getDensity() < randomDensityValue) {
            return false;
        }
        this.setBlock(globalBlockX, globalBlockY, globalBlockZ, this.currentOreVein, 0);
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int index) {
        if (this.currentOreVein == null) {
            throw new IllegalStateException("Attempted to call generateBlock without current ore vein!");
        }
        int globalBlockX = this.veinCenterX + x;
        int globalBlockY = this.veinCenterY + y;
        int globalBlockZ = this.veinCenterZ + z;
        this.setBlock(globalBlockX, globalBlockY, globalBlockZ, this.currentOreVein, index + 1);
        return true;
    }

    private void setBlock(int worldX, int worldY, int worldZ, OreDepositDefinition definition, int index) {
        int chunkX = worldX >> 4;
        int chunkZ = worldZ >> 4;
        int localX = worldX - chunkX * 16;
        int localZ = worldZ - chunkZ * 16;
        if (worldY > 0) {
            long chunkKey = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
            ChunkDataEntry dataEntry = (ChunkDataEntry)this.dataByChunkPos.get(chunkKey);
            if (dataEntry == null) {
                dataEntry = new ChunkDataEntry(chunkX, chunkZ);
                this.dataByChunkPos.put(chunkKey, (Object)dataEntry);
            }
            dataEntry.setBlock(localX, worldY, localZ, definition, index);
        }
    }

    public static class ChunkDataEntry {
        private final Map<OreDepositDefinition, TLongList> oreBlocks = new HashMap<OreDepositDefinition, TLongList>();
        private final List<OreDepositDefinition> generatedOres = new ArrayList<OreDepositDefinition>();
        private final int chunkX;
        private final int chunkZ;

        public ChunkDataEntry(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public void setBlock(int x, int y, int z, OreDepositDefinition definition, int index) {
            int xzValue = x & 0xFF | (z & 0xFF) << 8 | (y & 0xFF) << 16;
            long blockIndex = (long)xzValue << 32 | (long)index & 0xFFFFFFFFL;
            TLongList longList = this.oreBlocks.get(definition);
            if (longList == null) {
                longList = new TLongArrayList();
                this.oreBlocks.put(definition, longList);
            }
            longList.add(blockIndex);
        }

        public boolean populateChunk(World world) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            boolean generatedAnything = false;
            for (OreDepositDefinition definition : this.oreBlocks.keySet()) {
                TLongList blockIndexList = this.oreBlocks.get(definition);
                boolean generatedOreVein = false;
                for (int i = 0; i < blockIndexList.size(); ++i) {
                    IBlockState newState;
                    long blockIndex = blockIndexList.get(i);
                    int xyzValue = (int)(blockIndex >> 32);
                    byte blockX = (byte)xyzValue;
                    byte blockZ = (byte)(xyzValue >> 8);
                    short blockY = (short)(xyzValue >> 16);
                    int index = (int)blockIndex;
                    blockPos.func_181079_c(this.chunkX * 16 + blockX, (int)blockY, this.chunkZ * 16 + blockZ);
                    IBlockState currentState = world.func_180495_p((BlockPos)blockPos);
                    if (index == 0) {
                        if (!definition.getGenerationPredicate().test(currentState, (IBlockAccess)world, (BlockPos)blockPos)) continue;
                        newState = definition.getBlockFiller().apply(currentState, (IBlockAccess)world, (BlockPos)blockPos, blockX, blockY, blockZ);
                    } else {
                        VeinBufferPopulator populator = (VeinBufferPopulator)definition.getVeinPopulator();
                        newState = populator.getBlockByIndex(world, (BlockPos)blockPos, index - 1);
                    }
                    world.func_180501_a((BlockPos)blockPos, newState, 16);
                    generatedOreVein = true;
                    generatedAnything = true;
                }
                if (!generatedOreVein) continue;
                this.generatedOres.add(definition);
            }
            return generatedAnything;
        }
    }
}

