/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.asm;

import java.util.function.Function;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TargetClassVisitor
extends ClassVisitor {
    private String className;
    private final String methodKey;
    private final Function<MethodVisitor, MethodVisitor> visitorCreator;
    private boolean foundMethod = false;

    public TargetClassVisitor(ClassVisitor cv, String methodKey, Function<MethodVisitor, MethodVisitor> visitorCreator) {
        super(327680, cv);
        this.methodKey = methodKey;
        this.visitorCreator = visitorCreator;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        String methodKey = name + desc;
        if (this.methodKey.equals(methodKey)) {
            FMLLog.log((String)"ArmorRenderTransformer", (Level)Level.INFO, (String)"Patched method {} successfully", (Object[])new Object[]{methodKey});
            this.foundMethod = true;
            return this.visitorCreator.apply(visitor);
        }
        return visitor;
    }

    public void visitEnd() {
        super.visitEnd();
        if (!this.foundMethod) {
            FMLLog.log((String)"ArmorRenderTransformer", (Level)Level.FATAL, (String)"Failed to find method {} in {}.", (Object[])new Object[]{this.methodKey, this.className});
        }
    }
}

