/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.MetaTileEntityRenderer;
import gregtech.api.render.MetaTileEntityTESR;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.common.ClientProxy;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockConcrete;
import gregtech.common.blocks.BlockCrusherBlade;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockGranite;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMineral;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.foam.BlockFoam;
import gregtech.common.blocks.foam.BlockPetrifiedFoam;
import gregtech.common.blocks.modelfactories.BakedModelHandler;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.blocks.surfacerock.BlockSurfaceRockFlooded;
import gregtech.common.blocks.tileentity.TileEntityCrusherBlade;
import gregtech.common.blocks.wood.BlockGregLeaves;
import gregtech.common.blocks.wood.BlockGregLog;
import gregtech.common.blocks.wood.BlockGregSapling;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import gregtech.common.pipelike.cable.tile.TileEntityCableTickable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import gregtech.common.render.CableRenderer;
import gregtech.common.render.FluidPipeRenderer;
import gregtech.common.render.tesr.TileEntityCrusherBladeRenderer;
import gregtech.common.render.tesr.TileEntityRendererBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class MetaBlocks {
    public static BlockMachine MACHINE;
    public static BlockCable CABLE;
    public static BlockFluidPipe FLUID_PIPE;
    public static BlockBoilerCasing BOILER_CASING;
    public static BlockFireboxCasing BOILER_FIREBOX_CASING;
    public static BlockMetalCasing METAL_CASING;
    public static BlockTurbineCasing TURBINE_CASING;
    public static BlockMachineCasing MACHINE_CASING;
    public static BlockMultiblockCasing MUTLIBLOCK_CASING;
    public static BlockWireCoil WIRE_COIL;
    public static BlockWarningSign WARNING_SIGN;
    public static BlockGranite GRANITE;
    public static BlockMineral MINERAL;
    public static BlockConcrete CONCRETE;
    public static BlockFoam FOAM;
    public static BlockFoam REINFORCED_FOAM;
    public static BlockPetrifiedFoam PETRIFIED_FOAM;
    public static BlockPetrifiedFoam REINFORCED_PETRIFIED_FOAM;
    public static BlockGregLog LOG;
    public static BlockGregLeaves LEAVES;
    public static BlockGregSapling SAPLING;
    public static BlockCrusherBlade CRUSHER_BLADE;
    public static Map<DustMaterial, BlockCompressed> COMPRESSED;
    public static Map<IngotMaterial, BlockSurfaceRock> SURFACE_ROCKS;
    public static Map<IngotMaterial, BlockSurfaceRockFlooded> FLOODED_SURFACE_ROCKS;
    public static Map<SolidMaterial, BlockFrame> FRAMES;
    public static Collection<BlockOre> ORES;
    public static Collection<BlockFluidBase> FLUID_BLOCKS;

    private MetaBlocks() {
    }

    public static void init() {
        GregTechAPI.MACHINE = MACHINE = new BlockMachine();
        MACHINE.setRegistryName("machine");
        CABLE = new BlockCable();
        CABLE.setRegistryName("cable");
        FLUID_PIPE = new BlockFluidPipe();
        FLUID_PIPE.setRegistryName("fluid_pipe");
        BOILER_CASING = new BlockBoilerCasing();
        BOILER_CASING.setRegistryName("boiler_casing");
        BOILER_FIREBOX_CASING = new BlockFireboxCasing();
        BOILER_FIREBOX_CASING.setRegistryName("boiler_firebox_casing");
        METAL_CASING = new BlockMetalCasing();
        METAL_CASING.setRegistryName("metal_casing");
        TURBINE_CASING = new BlockTurbineCasing();
        TURBINE_CASING.setRegistryName("turbine_casing");
        MACHINE_CASING = new BlockMachineCasing();
        MACHINE_CASING.setRegistryName("machine_casing");
        MUTLIBLOCK_CASING = new BlockMultiblockCasing();
        MUTLIBLOCK_CASING.setRegistryName("multiblock_casing");
        WIRE_COIL = new BlockWireCoil();
        WIRE_COIL.setRegistryName("wire_coil");
        WARNING_SIGN = new BlockWarningSign();
        WARNING_SIGN.setRegistryName("warning_sign");
        GRANITE = new BlockGranite();
        GRANITE.setRegistryName("granite");
        MINERAL = new BlockMineral();
        MINERAL.setRegistryName("mineral");
        CONCRETE = new BlockConcrete();
        CONCRETE.setRegistryName("concrete");
        FOAM = new BlockFoam(false);
        FOAM.setRegistryName("foam");
        REINFORCED_FOAM = new BlockFoam(true);
        REINFORCED_FOAM.setRegistryName("reinforced_foam");
        PETRIFIED_FOAM = new BlockPetrifiedFoam(false);
        PETRIFIED_FOAM.setRegistryName("petrified_foam");
        REINFORCED_PETRIFIED_FOAM = new BlockPetrifiedFoam(true);
        REINFORCED_PETRIFIED_FOAM.setRegistryName("reinforced_petrified_foam");
        LOG = new BlockGregLog();
        LOG.setRegistryName("log");
        LEAVES = new BlockGregLeaves();
        LEAVES.setRegistryName("leaves");
        SAPLING = new BlockGregSapling();
        SAPLING.setRegistryName("sapling");
        CRUSHER_BLADE = new BlockCrusherBlade();
        CRUSHER_BLADE.setRegistryName("crusher_blade");
        StoneType.init();
        MetaBlocks.createGeneratedBlock(material -> material instanceof DustMaterial && !OrePrefix.block.isIgnored((Material)material), MetaBlocks::createCompressedBlock);
        MetaBlocks.createGeneratedBlock(material -> material instanceof IngotMaterial && material.hasFlag(DustMaterial.MatFlags.GENERATE_ORE), MetaBlocks::createSurfaceRockBlock);
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material2 = iterator.next();
            if (material2 instanceof DustMaterial && material2.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)) {
                MetaBlocks.createOreBlock((DustMaterial)material2);
            }
            if (material2 instanceof SolidMaterial && material2.hasFlag(SolidMaterial.MatFlags.GENERATE_FRAME)) {
                BlockFrame blockFrame = new BlockFrame((SolidMaterial)material2);
                blockFrame.setRegistryName("frame_" + material2.toString());
                FRAMES.put((SolidMaterial)material2, blockFrame);
            }
            if (!(material2 instanceof IngotMaterial)) continue;
            IngotMaterial metalMaterial = (IngotMaterial)material2;
            if (metalMaterial.cableProperties != null) {
                CABLE.addCableMaterial(metalMaterial, metalMaterial.cableProperties);
            }
            if (metalMaterial.fluidPipeProperties == null) continue;
            FLUID_PIPE.addPipeMaterial(metalMaterial, metalMaterial.fluidPipeProperties);
        }
        FLUID_PIPE.addPipeMaterial(Materials.Wood, new FluidPipeProperties(310, 20, false));
        CABLE.addCableMaterial(MarkerMaterials.Tier.Superconductor, new WireProperties(Integer.MAX_VALUE, 4, 0));
        MetaBlocks.registerTileEntity();
        Blocks.field_150480_ab.func_180686_a((Block)LOG, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)LEAVES, 30, 60);
    }

    private static int createGeneratedBlock(Predicate<Material> materialPredicate, BiConsumer<Material[], Integer> blockGenerator) {
        Object[] materialBuffer = new Material[16];
        Arrays.fill(materialBuffer, Materials._NULL);
        int currentGenerationIndex = 0;
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!materialPredicate.test(material)) continue;
            if (currentGenerationIndex > 0 && currentGenerationIndex % 16 == 0) {
                blockGenerator.accept((Material[])materialBuffer, currentGenerationIndex / 16 - 1);
                Arrays.fill(materialBuffer, Materials._NULL);
            }
            materialBuffer[currentGenerationIndex % 16] = material;
            ++currentGenerationIndex;
        }
        if (materialBuffer[0] != Materials._NULL) {
            blockGenerator.accept((Material[])materialBuffer, currentGenerationIndex / 16);
        }
        return currentGenerationIndex / 16 + 1;
    }

    private static void createSurfaceRockBlock(Material[] materials, int index) {
        BlockSurfaceRock block = new BlockSurfaceRock(materials);
        BlockSurfaceRockFlooded floodedBlock = new BlockSurfaceRockFlooded(materials);
        block.setRegistryName("surface_rock_" + index);
        floodedBlock.setRegistryName("surface_rock_flooded_" + index);
        for (Material material : materials) {
            if (!(material instanceof IngotMaterial)) continue;
            SURFACE_ROCKS.put((IngotMaterial)material, block);
            FLOODED_SURFACE_ROCKS.put((IngotMaterial)material, floodedBlock);
        }
    }

    private static void createCompressedBlock(Material[] materials, int index) {
        BlockCompressed block = new BlockCompressed(materials);
        block.setRegistryName("compressed_" + index);
        for (Material material : materials) {
            if (!(material instanceof DustMaterial)) continue;
            COMPRESSED.put((DustMaterial)material, block);
        }
    }

    private static void createOreBlock(DustMaterial material) {
        Object[] stoneTypeBuffer = new StoneType[16];
        int generationIndex = 0;
        Iterator<StoneType> iterator = StoneType.STONE_TYPE_REGISTRY.iterator();
        while (iterator.hasNext()) {
            StoneType stoneType = iterator.next();
            int id = StoneType.STONE_TYPE_REGISTRY.getIDForObject(stoneType);
            int index = id / 16;
            if (index > generationIndex) {
                MetaBlocks.createOreBlock(material, MetaBlocks.copyNotNull(stoneTypeBuffer), generationIndex);
                Arrays.fill(stoneTypeBuffer, null);
            }
            stoneTypeBuffer[id % 16] = stoneType;
            generationIndex = index;
        }
        MetaBlocks.createOreBlock(material, MetaBlocks.copyNotNull(stoneTypeBuffer), generationIndex);
    }

    private static <T> T[] copyNotNull(T[] src) {
        int nullIndex = ArrayUtils.indexOf((Object[])src, null);
        return Arrays.copyOfRange(src, 0, nullIndex == -1 ? src.length : nullIndex);
    }

    private static void createOreBlock(DustMaterial material, StoneType[] stoneTypes, int index) {
        BlockOre block = new BlockOre(material, stoneTypes);
        block.setRegistryName("ore_" + material + "_" + index);
        for (StoneType stoneType : stoneTypes) {
            GregTechAPI.oreBlockTable.computeIfAbsent(material, m -> new HashMap()).put(stoneType, block);
        }
        ORES.add(block);
    }

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(MetaTileEntityHolder.class, (ResourceLocation)new ResourceLocation("gregtech", "machine"));
        GameRegistry.registerTileEntity(TileEntityCrusherBlade.class, (ResourceLocation)new ResourceLocation("gregtech", "crusher_blade"));
        GameRegistry.registerTileEntity(TileEntityCable.class, (ResourceLocation)new ResourceLocation("gregtech", "cable"));
        GameRegistry.registerTileEntity(TileEntityCableTickable.class, (ResourceLocation)new ResourceLocation("gregtech", "cable_tickable"));
        GameRegistry.registerTileEntity(TileEntityFluidPipe.class, (ResourceLocation)new ResourceLocation("gregtech", "fluid_pipe"));
        GameRegistry.registerTileEntity(TileEntityFluidPipeTickable.class, (ResourceLocation)new ResourceLocation("gregtech", "fluid_pipe_active"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MACHINE), stack -> MetaTileEntityRenderer.MODEL_LOCATION);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)CABLE), stack -> CableRenderer.MODEL_LOCATION);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)FLUID_PIPE), stack -> FluidPipeRenderer.MODEL_LOCATION);
        MetaBlocks.registerItemModel(BOILER_CASING);
        MetaBlocks.registerItemModel(BOILER_FIREBOX_CASING);
        MetaBlocks.registerItemModel(METAL_CASING);
        MetaBlocks.registerItemModel(TURBINE_CASING);
        MetaBlocks.registerItemModel(MACHINE_CASING);
        MetaBlocks.registerItemModel(MUTLIBLOCK_CASING);
        MetaBlocks.registerItemModel(WIRE_COIL);
        MetaBlocks.registerItemModel(WARNING_SIGN);
        MetaBlocks.registerItemModel(GRANITE);
        MetaBlocks.registerItemModel(MINERAL);
        MetaBlocks.registerItemModel(CONCRETE);
        MetaBlocks.registerItemModelWithOverride((Block)LOG, ImmutableMap.of((Object)BlockGregLog.field_176299_a, (Object)BlockLog.EnumAxis.Y));
        MetaBlocks.registerItemModel((Block)LEAVES);
        MetaBlocks.registerItemModel((Block)SAPLING);
        COMPRESSED.values().stream().distinct().forEach(MetaBlocks::registerItemModel);
        FRAMES.values().forEach(it -> MetaBlocks.registerItemModelWithFilteredProperties((Block)it, new IProperty[0]));
        ORES.stream().distinct().forEach(MetaBlocks::registerItemModel);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithFilteredProperties(Block block, IProperty<?> ... filteredProperties) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            HashMap stringProperties = new HashMap();
            for (IProperty<?> property : filteredProperties) {
                stringProperties.put(property, state.func_177229_b(property));
            }
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithOverride(Block block, Map<IProperty<?>, Comparable<?>> stateOverrides) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            HashMap stringProperties = new HashMap((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
            stringProperties.putAll(stateOverrides);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerStateMappers() {
        ModelLoader.setCustomStateMapper((Block)MACHINE, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return MetaTileEntityRenderer.MODEL_LOCATION;
            }
        });
        ModelLoader.setCustomStateMapper((Block)CABLE, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return CableRenderer.MODEL_LOCATION;
            }
        });
        ModelLoader.setCustomStateMapper((Block)FLUID_PIPE, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return FluidPipeRenderer.MODEL_LOCATION;
            }
        });
        StateMapperBase normalStateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), "normal");
            }
        };
        ModelLoader.setCustomStateMapper((Block)FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        FRAMES.values().forEach(arg_0 -> MetaBlocks.lambda$registerStateMappers$7((IStateMapper)normalStateMapper, arg_0));
        BakedModelHandler modelHandler = new BakedModelHandler();
        MinecraftForge.EVENT_BUS.register((Object)modelHandler);
        FLUID_BLOCKS.forEach(modelHandler::addFluidBlock);
        SURFACE_ROCKS.values().stream().distinct().forEach(block -> modelHandler.addBuiltInBlock((Block)block, "stone"));
        FLOODED_SURFACE_ROCKS.values().stream().distinct().forEach(block -> modelHandler.addBuiltInBlock((Block)block, "stone"));
        modelHandler.addBuiltInBlock(CRUSHER_BLADE, "iron_block");
        Item.func_150898_a((Block)CRUSHER_BLADE).setTileEntityItemStackRenderer(new TileEntityRendererBase.TileEntityRenderBaseItem<TileEntityCrusherBlade>(TileEntityCrusherBlade.class));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCrusherBlade.class, (TileEntitySpecialRenderer)new TileEntityCrusherBladeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(MetaTileEntityHolder.class, (TileEntitySpecialRenderer)new MetaTileEntityTESR());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.FOAM_BLOCK_COLOR, new Block[]{FOAM, REINFORCED_FOAM, PETRIFIED_FOAM, REINFORCED_PETRIFIED_FOAM});
        COMPRESSED.values().stream().distinct().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.COMPRESSED_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.COMPRESSED_ITEM_COLOR, new Block[]{block});
        });
        FRAMES.values().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.FRAME_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.FRAME_ITEM_COLOR, new Block[]{block});
        });
        ORES.stream().distinct().forEach(block -> {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.ORE_BLOCK_COLOR, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186731_a(ClientProxy.ORE_ITEM_COLOR, new Block[]{block});
        });
        SURFACE_ROCKS.values().stream().distinct().forEach(block -> Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.SURFACE_ROCK_COLOR, new Block[]{block}));
        FLOODED_SURFACE_ROCKS.values().stream().distinct().forEach(block -> Minecraft.func_71410_x().func_184125_al().func_186722_a(ClientProxy.SURFACE_ROCK_COLOR, new Block[]{block}));
    }

    public static void registerOreDict() {
        ItemStack itemStack;
        Object block;
        DustMaterial material;
        OreDictUnifier.registerOre(new ItemStack((Block)LOG, 1, Short.MAX_VALUE), OrePrefix.log, Materials.Wood);
        OreDictUnifier.registerOre(new ItemStack((Block)LEAVES, 1, Short.MAX_VALUE), "treeLeaves");
        OreDictUnifier.registerOre(new ItemStack((Block)SAPLING, 1, Short.MAX_VALUE), "treeSapling");
        GameRegistry.addSmelting((Block)LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        for (Map.Entry<DustMaterial, BlockCompressed> entry : COMPRESSED.entrySet()) {
            material = entry.getKey();
            block = entry.getValue();
            ItemStack itemStack2 = block.getItem(material);
            OreDictUnifier.registerOre(itemStack2, OrePrefix.block, material);
        }
        for (Map.Entry<DustMaterial, Object> entry : FRAMES.entrySet()) {
            material = (SolidMaterial)entry.getKey();
            block = (BlockFrame)((Object)entry.getValue());
            for (int i = 0; i < 16; ++i) {
                ItemStack itemStack3 = new ItemStack((Block)block, 1, i);
                OreDictUnifier.registerOre(itemStack3, OrePrefix.frameGt, material);
            }
        }
        for (BlockOre blockOre : ORES) {
            material = blockOre.material;
            for (StoneType stoneType : blockOre.STONE_TYPE.getAllowedValues()) {
                if (stoneType == null) continue;
                ItemStack normalStack = blockOre.getItem(blockOre.func_176223_P().func_177226_a((IProperty)blockOre.STONE_TYPE, (Comparable)stoneType));
                OreDictUnifier.registerOre(normalStack, stoneType.processingPrefix, material);
            }
        }
        for (Material material2 : CABLE.getEnabledMaterials()) {
            for (Enum insulation : Insulation.values()) {
                itemStack = CABLE.getItem(insulation, material2);
                OreDictUnifier.registerOre(itemStack, ((Insulation)insulation).getOrePrefix(), material2);
            }
        }
        for (Material material3 : FLUID_PIPE.getEnabledMaterials()) {
            for (Enum fluidPipeType : FluidPipeType.values()) {
                itemStack = FLUID_PIPE.getItem(fluidPipeType, material3);
                OreDictUnifier.registerOre(itemStack, ((FluidPipeType)fluidPipeType).getOrePrefix(), material3);
            }
        }
    }

    private static String statePropertiesToString(Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(MetaBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    private static /* synthetic */ void lambda$registerStateMappers$7(IStateMapper normalStateMapper, BlockFrame it) {
        ModelLoader.setCustomStateMapper((Block)it, (IStateMapper)normalStateMapper);
    }

    static {
        COMPRESSED = new HashMap<DustMaterial, BlockCompressed>();
        SURFACE_ROCKS = new HashMap<IngotMaterial, BlockSurfaceRock>();
        FLOODED_SURFACE_ROCKS = new HashMap<IngotMaterial, BlockSurfaceRockFlooded>();
        FRAMES = new HashMap<SolidMaterial, BlockFrame>();
        ORES = new HashSet<BlockOre>();
        FLUID_BLOCKS = new HashSet<BlockFluidBase>();
    }
}

