/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.ItemStackKey;
import gregtech.common.covers.filter.ItemFilterContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class CoverConveyor
extends CoverBehavior
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxItemTransferRate;
    protected int transferRate;
    protected ConveyorMode conveyorMode;
    protected boolean allowManualImportExport = false;
    protected final ItemFilterContainer itemFilterContainer;
    protected int itemsLeftToTransferLastSecond;
    private CoverableItemHandlerWrapper itemHandlerWrapper;
    protected boolean isWorkingAllowed = true;

    public CoverConveyor(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = itemsPerSecond);
        this.conveyorMode = ConveyorMode.EXPORT;
        this.itemFilterContainer = new ItemFilterContainer(this);
    }

    protected void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        this.coverHolder.markDirty();
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + amount), (int)1, (int)this.maxItemTransferRate));
    }

    protected void setConveyorMode(ConveyorMode conveyorMode) {
        this.conveyorMode = conveyorMode;
        this.coverHolder.markDirty();
    }

    public ConveyorMode getConveyorMode() {
        return this.conveyorMode;
    }

    public void func_73660_a() {
        long timer = this.coverHolder.getTimer();
        if (timer % 5L == 0L && this.isWorkingAllowed && this.itemsLeftToTransferLastSecond > 0) {
            TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s(this.coverHolder.getPos().func_177972_a(this.attachedSide));
            IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide);
            if (itemHandler != null && myItemHandler != null) {
                int totalTransferred = this.doTransferItems(itemHandler, myItemHandler, this.itemsLeftToTransferLastSecond);
                this.itemsLeftToTransferLastSecond -= totalTransferred;
            }
        }
        if (timer % 20L == 0L) {
            this.itemsLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        return this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
    }

    protected int doTransferItemsAny(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, maxTransferAmount);
        }
        return 0;
    }

    protected int doTransferItemsByGroup(IItemHandler itemHandler, IItemHandler myItemHandler, Map<Object, GroupItemInfo> itemInfos, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, itemInfos, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, itemInfos, maxTransferAmount);
        }
        return 0;
    }

    protected Map<Object, GroupItemInfo> doCountDestinationInventoryItemsByMatchIndex(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByMatchSlot(myItemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByMatchSlot(itemHandler);
        }
        return Collections.emptyMap();
    }

    protected Map<ItemStackKey, TypeItemInfo> doCountSourceInventoryItemsByType(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByType(itemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByType(myItemHandler);
        }
        return Collections.emptyMap();
    }

    protected boolean doTransferItemsExact(IItemHandler itemHandler, IItemHandler myItemHandler, TypeItemInfo itemInfo) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItemsExact(itemHandler, myItemHandler, itemInfo);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItemsExact(myItemHandler, itemHandler, itemInfo);
        }
        return false;
    }

    protected boolean moveInventoryItemsExact(IItemHandler sourceInventory, IItemHandler targetInventory, TypeItemInfo itemInfo) {
        ItemStack resultStack = itemInfo.itemStack.func_77946_l();
        int totalExtractedCount = 0;
        int itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, true);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                totalExtractedCount += extractedStack.func_190916_E();
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        if (totalExtractedCount != itemInfo.totalCount) {
            return false;
        }
        resultStack.func_190920_e(totalExtractedCount);
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)resultStack, (boolean)true);
        if (!remainder.func_190926_b()) {
            return false;
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)resultStack, (boolean)false);
        itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, false);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        return true;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, Map<Object, GroupItemInfo> itemInfos, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            Object matchSlotIndex;
            ItemStack itemStack = sourceInventory.getStackInSlot(i);
            if (itemStack.func_190926_b() || (matchSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null || !itemInfos.containsKey(matchSlotIndex)) continue;
            GroupItemInfo itemInfo = itemInfos.get(matchSlotIndex);
            ItemStack extractedStack = sourceInventory.extractItem(i, Math.min(itemInfo.totalCount, itemsLeftToTransfer), true);
            ItemStack remainderStack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedStack, (boolean)true);
            int amountToInsert = extractedStack.func_190916_E() - remainderStack.func_190916_E();
            if (amountToInsert <= 0 || (extractedStack = sourceInventory.extractItem(i, amountToInsert, false)).func_190926_b()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedStack, (boolean)false);
            itemsLeftToTransfer -= extractedStack.func_190916_E();
            itemInfo.totalCount -= extractedStack.func_190916_E();
            if (itemInfo.totalCount == 0) {
                itemInfos.remove(matchSlotIndex);
                if (itemInfos.isEmpty()) break;
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.func_190926_b() || !this.itemFilterContainer.testItemStack(sourceStack)) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false)).func_190926_b()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)false);
            if ((itemsLeftToTransfer -= sourceStack.func_190916_E()) == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected Map<ItemStackKey, TypeItemInfo> countInventoryItemsByType(IItemHandler inventory) {
        HashMap<ItemStackKey, TypeItemInfo> result = new HashMap<ItemStackKey, TypeItemInfo>();
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            TypeItemInfo itemInfo;
            Object transferSlotIndex;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || (transferSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null) continue;
            ItemStackKey itemStackKey = new ItemStackKey(itemStack);
            if (!result.containsKey(itemStackKey)) {
                itemInfo = new TypeItemInfo(itemStack.func_77946_l(), transferSlotIndex, (TIntList)new TIntArrayList(), 0);
                itemInfo.totalCount += itemStack.func_190916_E();
                itemInfo.slots.add(srcIndex);
                result.put(itemStackKey, itemInfo);
                continue;
            }
            itemInfo = (TypeItemInfo)result.get(itemStackKey);
            itemInfo.totalCount += itemStack.func_190916_E();
            itemInfo.slots.add(srcIndex);
        }
        return result;
    }

    protected Map<Object, GroupItemInfo> countInventoryItemsByMatchSlot(IItemHandler inventory) {
        HashMap<Object, GroupItemInfo> result = new HashMap<Object, GroupItemInfo>();
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            GroupItemInfo itemInfo;
            Object transferSlotIndex;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || (transferSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null) continue;
            ItemStackKey itemStackKey = new ItemStackKey(itemStack);
            if (!result.containsKey(transferSlotIndex)) {
                itemInfo = new GroupItemInfo(transferSlotIndex, new HashSet<ItemStackKey>(), 0);
                itemInfo.itemStackTypes.add(itemStackKey);
                itemInfo.totalCount += itemStack.func_190916_E();
                result.put(transferSlotIndex, itemInfo);
                continue;
            }
            itemInfo = result.get(transferSlotIndex);
            itemInfo.itemStackTypes.add(itemStackKey);
            itemInfo.totalCount += itemStack.func_190916_E();
        }
        return result;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.itemFilterContainer.getFilterInventory());
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.CONVEYOR_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandlerWrapper == null || this.itemHandlerWrapper.delegate != delegate) {
                this.itemHandlerWrapper = new CoverableItemHandlerWrapper(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    protected String getUITitle() {
        return "cover.conveyor.title";
    }

    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        return builder.build(this, player);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), GTValues.VN[this.tier]));
        primaryGroup.addWidget(new ClickButtonWidget(10, 20, 20, 20, "-10", data -> this.adjustTransferRate(data.isShiftClick ? -100 : -10)));
        primaryGroup.addWidget(new ClickButtonWidget(146, 20, 20, 20, "+10", data -> this.adjustTransferRate(data.isShiftClick ? 100 : 10)));
        primaryGroup.addWidget(new ClickButtonWidget(30, 20, 20, 20, "-1", data -> this.adjustTransferRate(data.isShiftClick ? -5 : -1)));
        primaryGroup.addWidget(new ClickButtonWidget(126, 20, 20, 20, "+1", data -> this.adjustTransferRate(data.isShiftClick ? 5 : 1)));
        primaryGroup.addWidget(new ImageWidget(50, 20, 76, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(88, 30, "cover.conveyor.transfer_rate", 0xFFFFFF, () -> Integer.toString(this.transferRate)));
        primaryGroup.addWidget(new CycleButtonWidget(10, 45, 75, 20, ConveyorMode.class, this::getConveyorMode, this::setConveyorMode));
        primaryGroup.addWidget(new ToggleButtonWidget(146, 133, 20, 20, this::isAllowManualImportExport, this::setAllowManualImportExport).setTooltipText("cover.conveyor.manual_io").setButtonTexture(GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT));
        this.itemFilterContainer.initUI(70, primaryGroup::addWidget);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND_EXTENDED, 176, 252).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 8, 170);
        return this.buildUI(builder, player);
    }

    public boolean isAllowManualImportExport() {
        return this.allowManualImportExport;
    }

    public void setAllowManualImportExport(boolean allowManualImportExport) {
        this.allowManualImportExport = allowManualImportExport;
        this.markAsDirty();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("ConveyorMode", this.conveyorMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74757_a("AllowManualIO", this.allowManualImportExport);
        tagCompound.func_74782_a("Filter", (NBTBase)this.itemFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.conveyorMode = ConveyorMode.values()[tagCompound.func_74762_e("ConveyorMode")];
        if (tagCompound.func_74764_b("FilterInventory")) {
            this.itemFilterContainer.deserializeNBT(tagCompound);
        } else {
            NBTTagCompound filterComponent = tagCompound.func_74775_l("Filter");
            this.itemFilterContainer.deserializeNBT(filterComponent);
        }
        if (tagCompound.func_74764_b("WorkingAllowed")) {
            this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        }
        if (tagCompound.func_74764_b("AllowManualIO")) {
            this.allowManualImportExport = tagCompound.func_74767_n("AllowManualIO");
        }
    }

    private class CoverableItemHandlerWrapper
    extends ItemHandlerDelegate {
        public CoverableItemHandlerWrapper(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.EXPORT && !CoverConveyor.this.allowManualImportExport) {
                return stack;
            }
            if (!CoverConveyor.this.itemFilterContainer.testItemStack(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.IMPORT && !CoverConveyor.this.allowManualImportExport) {
                return ItemStack.field_190927_a;
            }
            ItemStack resultStack = super.extractItem(slot, amount, true);
            if (!CoverConveyor.this.itemFilterContainer.testItemStack(resultStack)) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                super.extractItem(slot, amount, false);
            }
            return resultStack;
        }
    }

    public static enum ConveyorMode implements IStringSerializable
    {
        IMPORT("cover.conveyor.mode.import"),
        EXPORT("cover.conveyor.mode.export");

        public final String localeName;

        private ConveyorMode(String localeName) {
            this.localeName = localeName;
        }

        public String func_176610_l() {
            return this.localeName;
        }
    }

    protected static class GroupItemInfo {
        public final Object filterSlot;
        public final Set<ItemStackKey> itemStackTypes;
        public int totalCount;

        public GroupItemInfo(Object filterSlot, Set<ItemStackKey> itemStackTypes, int totalCount) {
            this.filterSlot = filterSlot;
            this.itemStackTypes = itemStackTypes;
            this.totalCount = totalCount;
        }
    }

    protected static class TypeItemInfo {
        public final ItemStack itemStack;
        public final Object filterSlot;
        public final TIntList slots;
        public int totalCount;

        public TypeItemInfo(ItemStack itemStack, Object filterSlot, TIntList slots, int totalCount) {
            this.itemStack = itemStack;
            this.filterSlot = filterSlot;
            this.slots = slots;
            this.totalCount = totalCount;
        }
    }
}

