/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.SimpleOverlayRenderer;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.FluidFilterMode;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.FluidFilterWrapper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CoverFluidFilter
extends CoverBehavior
implements CoverWithUI {
    protected final String titleLocale;
    protected final SimpleOverlayRenderer texture;
    protected final FluidFilterWrapper fluidFilter;
    protected FluidFilterMode filterMode = FluidFilterMode.FILTER_FILL;
    protected FluidHandlerFiltered fluidHandler;

    public CoverFluidFilter(ICoverable coverHolder, EnumFacing attachedSide, String titleLocale, SimpleOverlayRenderer texture, FluidFilter fluidFilter) {
        super(coverHolder, attachedSide);
        this.titleLocale = titleLocale;
        this.texture = texture;
        this.fluidFilter = new FluidFilterWrapper(this);
        this.fluidFilter.setFluidFilter(fluidFilter);
    }

    protected void setFilterMode(FluidFilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    public FluidFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup fluidFilterGroup = new WidgetGroup();
        fluidFilterGroup.addWidget(new LabelWidget(10, 5, "cover.fluid_filter.title", new Object[0]));
        fluidFilterGroup.addWidget(new CycleButtonWidget(10, 20, 110, 20, GTUtility.mapToString(FluidFilterMode.values(), it -> it.localeName), () -> this.filterMode.ordinal(), newMode -> this.setFilterMode(FluidFilterMode.values()[newMode])));
        this.fluidFilter.initUI(45, fluidFilterGroup::addWidget);
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 187).widget(fluidFilterGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 8, 105).build(this, player);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        this.texture.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandler == null || this.fluidHandler.delegate != delegate) {
                this.fluidHandler = new FluidHandlerFiltered(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return defaultValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
        tagCompound.func_74757_a("IsBlacklist", this.fluidFilter.isBlacklistFilter());
        NBTTagCompound filterComponent = new NBTTagCompound();
        this.fluidFilter.getFluidFilter().writeToNBT(filterComponent);
        tagCompound.func_74782_a("Filter", (NBTBase)filterComponent);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.filterMode = FluidFilterMode.values()[tagCompound.func_74762_e("FilterMode")];
        this.fluidFilter.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        if (tagCompound.func_74764_b("FluidFilter")) {
            this.fluidFilter.getFluidFilter().readFromNBT(tagCompound);
        } else {
            NBTTagCompound filterComponent = tagCompound.func_74775_l("Filter");
            this.fluidFilter.getFluidFilter().readFromNBT(filterComponent);
        }
    }

    private class FluidHandlerFiltered
    extends FluidHandlerDelegate {
        public FluidHandlerFiltered(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            FluidFilterMode filterMode = CoverFluidFilter.this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_DRAIN) {
                return 0;
            }
            if (!CoverFluidFilter.this.fluidFilter.testFluidStack(resource)) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidFilterMode filterMode = CoverFluidFilter.this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_FILL) {
                return null;
            }
            if (!CoverFluidFilter.this.fluidFilter.testFluidStack(resource)) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidFilterMode filterMode = CoverFluidFilter.this.getFilterMode();
            if (filterMode == FluidFilterMode.FILTER_FILL) {
                return null;
            }
            for (IFluidTankProperties prop : this.delegate.getTankProperties()) {
                FluidStack fluidTank = prop.getContents();
                if (fluidTank == null || !CoverFluidFilter.this.fluidFilter.testFluidStack(fluidTank)) continue;
                int drainAmount = Math.min(fluidTank.amount, maxDrain);
                FluidStack fluidDrain = new FluidStack(fluidTank.getFluid(), drainAmount, fluidTank.tag);
                FluidStack result = super.drain(fluidDrain, doDrain);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

