/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.SimpleOverlayRenderer;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.ItemFilterMode;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.ItemFilterWrapper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoverItemFilter
extends CoverBehavior
implements CoverWithUI {
    protected final String titleLocale;
    protected final SimpleOverlayRenderer texture;
    protected final ItemFilterWrapper itemFilter;
    protected ItemFilterMode filterMode = ItemFilterMode.FILTER_INSERT;
    protected ItemHandlerFiltered itemHandler;

    public CoverItemFilter(ICoverable coverHolder, EnumFacing attachedSide, String titleLocale, SimpleOverlayRenderer texture, ItemFilter itemFilter) {
        super(coverHolder, attachedSide);
        this.titleLocale = titleLocale;
        this.texture = texture;
        this.itemFilter = new ItemFilterWrapper(this);
        this.itemFilter.setItemFilter(itemFilter);
        this.itemFilter.setMaxStackSize(1);
    }

    protected void setFilterMode(ItemFilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    public ItemFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup filterGroup = new WidgetGroup();
        filterGroup.addWidget(new LabelWidget(10, 5, this.titleLocale, new Object[0]));
        filterGroup.addWidget(new CycleButtonWidget(10, 20, 110, 20, GTUtility.mapToString(ItemFilterMode.values(), it -> it.localeName), () -> this.filterMode.ordinal(), newMode -> this.setFilterMode(ItemFilterMode.values()[newMode])));
        this.itemFilter.initUI(45, filterGroup::addWidget);
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 187).widget(filterGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 8, 105).build(this, player);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        this.texture.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
        tagCompound.func_74757_a("IsBlacklist", this.itemFilter.isBlacklistFilter());
        NBTTagCompound filterComponent = new NBTTagCompound();
        this.itemFilter.getItemFilter().writeToNBT(filterComponent);
        tagCompound.func_74782_a("Filter", (NBTBase)filterComponent);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.filterMode = ItemFilterMode.values()[tagCompound.func_74762_e("FilterMode")];
        this.itemFilter.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        if (tagCompound.func_74764_b("FilterInventory") || tagCompound.func_74764_b("OreDictionaryFilter")) {
            if (tagCompound.func_74764_b("FilterInventory")) {
                tagCompound.func_74782_a("ItemFilter", (NBTBase)tagCompound.func_74775_l("FilterInventory"));
                tagCompound.func_82580_o("FilterInventory");
            }
            this.itemFilter.getItemFilter().readFromNBT(tagCompound);
        } else {
            NBTTagCompound filterComponent = tagCompound.func_74775_l("Filter");
            this.itemFilter.getItemFilter().readFromNBT(filterComponent);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandler == null || this.itemHandler.delegate != delegate) {
                this.itemHandler = new ItemHandlerFiltered(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return defaultValue;
    }

    private class ItemHandlerFiltered
    extends ItemHandlerDelegate {
        public ItemHandlerFiltered(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemFilterMode filterMode = CoverItemFilter.this.getFilterMode();
            if (filterMode == ItemFilterMode.FILTER_EXTRACT) {
                return stack;
            }
            if (!CoverItemFilter.this.itemFilter.testItemStack(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemFilterMode filterMode = CoverItemFilter.this.getFilterMode();
            if (filterMode == ItemFilterMode.FILTER_INSERT) {
                return ItemStack.field_190927_a;
            }
            ItemStack result = super.extractItem(slot, amount, true);
            if (!CoverItemFilter.this.itemFilter.testItemStack(result)) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                super.extractItem(slot, amount, false);
            }
            return result;
        }
    }
}

