/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.Textures;
import gregtech.api.util.ItemStackKey;
import gregtech.common.covers.CoverConveyor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.items.IItemHandler;

public class CoverRoboticArm
extends CoverConveyor {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int itemsTransferBuffered;

    public CoverRoboticArm(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide, tier, itemsPerSecond);
        this.itemFilterContainer.setMaxStackSize(1);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.ARM_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        switch (this.transferMode) {
            case TRANSFER_ANY: {
                return this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
            }
            case TRANSFER_EXACT: {
                return this.doTransferExact(itemHandler, myItemHandler, maxTransferAmount);
            }
            case KEEP_EXACT: {
                return this.doKeepExact(itemHandler, myItemHandler, maxTransferAmount);
            }
        }
        return 0;
    }

    protected int doTransferExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<ItemStackKey, CoverConveyor.TypeItemInfo> sourceItemAmount = this.doCountSourceInventoryItemsByType(itemHandler, myItemHandler);
        Iterator<ItemStackKey> iterator = sourceItemAmount.keySet().iterator();
        while (iterator.hasNext()) {
            ItemStackKey key = iterator.next();
            CoverConveyor.TypeItemInfo sourceInfo = sourceItemAmount.get(key);
            int itemAmount = sourceInfo.totalCount;
            Set<ItemStackKey> matchedItems = Collections.singleton(key);
            int itemToMoveAmount = this.itemFilterContainer.getSlotTransferLimit(sourceInfo.filterSlot, matchedItems);
            if (itemAmount >= itemToMoveAmount) {
                sourceInfo.totalCount = itemToMoveAmount;
                continue;
            }
            iterator.remove();
        }
        int itemsTransferred = 0;
        int maxTotalTransferAmount = maxTransferAmount + this.itemsTransferBuffered;
        boolean notEnoughTransferRate = false;
        for (CoverConveyor.TypeItemInfo itemInfo : sourceItemAmount.values()) {
            if (maxTotalTransferAmount >= itemInfo.totalCount) {
                boolean result = this.doTransferItemsExact(itemHandler, myItemHandler, itemInfo);
                itemsTransferred += result ? itemInfo.totalCount : 0;
                maxTotalTransferAmount -= result ? itemInfo.totalCount : 0;
                continue;
            }
            notEnoughTransferRate = true;
        }
        this.itemsTransferBuffered = itemsTransferred == 0 && notEnoughTransferRate ? (this.itemsTransferBuffered += maxTransferAmount) : 0;
        return Math.min(itemsTransferred, maxTransferAmount);
    }

    protected int doKeepExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<Object, CoverConveyor.GroupItemInfo> currentItemAmount = this.doCountDestinationInventoryItemsByMatchIndex(itemHandler, myItemHandler);
        Map<Object, CoverConveyor.GroupItemInfo> sourceItemAmounts = this.doCountDestinationInventoryItemsByMatchIndex(myItemHandler, itemHandler);
        Iterator<Object> iterator = sourceItemAmounts.keySet().iterator();
        while (iterator.hasNext()) {
            Object filterSlotIndex = iterator.next();
            CoverConveyor.GroupItemInfo sourceInfo = sourceItemAmounts.get(filterSlotIndex);
            int itemToKeepAmount = this.itemFilterContainer.getSlotTransferLimit(sourceInfo.filterSlot, sourceInfo.itemStackTypes);
            int itemAmount = 0;
            if (currentItemAmount.containsKey(filterSlotIndex)) {
                CoverConveyor.GroupItemInfo destItemInfo = currentItemAmount.get(filterSlotIndex);
                itemAmount = destItemInfo.totalCount;
            }
            if (itemAmount < itemToKeepAmount) {
                sourceInfo.totalCount = itemToKeepAmount - itemAmount;
                continue;
            }
            iterator.remove();
        }
        return this.doTransferItemsByGroup(itemHandler, myItemHandler, sourceItemAmounts, maxTransferAmount);
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
        this.itemFilterContainer.setMaxStackSize(transferMode.maxStackSize);
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    @Override
    protected String getUITitle() {
        return "cover.robotic_arm.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        WidgetGroup filterGroup = new WidgetGroup();
        filterGroup.addWidget(new CycleButtonWidget(91, 45, 75, 20, TransferMode.class, this::getTransferMode, this::setTransferMode).setTooltipHoverString("cover.robotic_arm.transfer_mode.description"));
        return super.buildUI(builder.widget(filterGroup), player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
    }

    public static enum TransferMode implements IStringSerializable
    {
        TRANSFER_ANY("cover.robotic_arm.transfer_mode.transfer_any", Integer.MAX_VALUE),
        TRANSFER_EXACT("cover.robotic_arm.transfer_mode.transfer_exact", 64),
        KEEP_EXACT("cover.robotic_arm.transfer_mode.keep_exact", 1024);

        public final String localeName;
        public final int maxStackSize;

        private TransferMode(String localeName, int maxStackSize) {
            this.localeName = localeName;
            this.maxStackSize = maxStackSize;
        }

        public String func_176610_l() {
            return this.localeName;
        }
    }
}

