/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.render.Textures;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class CoverSolarPanel
extends CoverBehavior
implements ITickable {
    private final int EUt;

    public CoverSolarPanel(ICoverable coverHolder, EnumFacing attachedSide, int EUt) {
        super(coverHolder, attachedSide);
        this.EUt = EUt;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null) != null && this.attachedSide == EnumFacing.UP;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.SOLAR_PANEL.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    public void func_73660_a() {
        IEnergyContainer energyContainer;
        BlockPos blockPos;
        World world = this.coverHolder.getWorld();
        if (this.canSeeSunClearly(world, blockPos = this.coverHolder.getPos().func_177984_a()) && (energyContainer = this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null)) != null) {
            energyContainer.addEnergy(this.EUt);
        }
    }

    private boolean canSeeSunClearly(World world, BlockPos blockPos) {
        Biome biome;
        if (!world.func_175678_i(blockPos)) {
            return false;
        }
        if (world.func_72896_J() && ((biome = world.func_180494_b(blockPos)).func_76738_d() || biome.func_76746_c())) {
            return false;
        }
        return world.func_72935_r();
    }
}

