/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.common.covers.filter.FluidFilter;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class SimpleFluidFilter
extends FluidFilter {
    private static final int MAX_FLUID_SLOTS = 9;
    protected FluidStack[] fluidFilterSlots = new FluidStack[9];

    @Nullable
    public FluidStack getFluidInSlot(int slotIndex) {
        return this.fluidFilterSlots[slotIndex];
    }

    public void setFluidInSlot(int slotIndex, FluidStack fluidStack) {
        this.fluidFilterSlots[slotIndex] = fluidStack == null ? null : fluidStack.copy();
    }

    @Override
    public boolean testFluid(FluidStack fluidStack) {
        return SimpleFluidFilter.checkInputFluid(this.fluidFilterSlots, fluidStack);
    }

    @Override
    public int getMaxOccupiedHeight() {
        return 36;
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        for (int i = 0; i < 9; ++i) {
            int index = i;
            widgetGroup.accept(new PhantomFluidWidget(10 + 18 * (i % 3), 18 * (i / 3), 18, 18, () -> this.getFluidInSlot(index), newFluid -> this.setFluidInSlot(index, (FluidStack)newFluid)).setBackgroundTexture(GuiTextures.SLOT));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList filterSlots = new NBTTagList();
        for (int i = 0; i < this.fluidFilterSlots.length; ++i) {
            FluidStack fluidStack = this.fluidFilterSlots[i];
            if (fluidStack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            fluidStack.writeToNBT(stackTag);
            stackTag.func_74768_a("Slot", i);
            filterSlots.func_74742_a((NBTBase)stackTag);
        }
        tagCompound.func_74782_a("FluidFilter", (NBTBase)filterSlots);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList filterSlots = tagCompound.func_150295_c("FluidFilter", 10);
        for (NBTBase nbtBase : filterSlots) {
            FluidStack fluidStack;
            NBTTagCompound stackTag = (NBTTagCompound)nbtBase;
            this.fluidFilterSlots[stackTag.func_74762_e((String)"Slot")] = fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
        }
    }

    public static boolean checkInputFluid(FluidStack[] fluidFilterSlots, FluidStack fluidStack) {
        for (FluidStack filterStack : fluidFilterSlots) {
            if (filterStack == null || !filterStack.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }
}

