/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.util.ItemStackKey;
import gregtech.common.covers.filter.ItemFilter;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleItemFilter
extends ItemFilter {
    private static final int MAX_MATCH_SLOTS = 9;
    protected ItemStackHandler itemFilterSlots = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return SimpleItemFilter.this.getMaxStackSize();
        }
    };
    protected boolean ignoreDamage = true;
    protected boolean ignoreNBT = true;

    @Override
    protected void onMaxStackSizeChange() {
        for (int i = 0; i < this.itemFilterSlots.getSlots(); ++i) {
            ItemStack itemStack = this.itemFilterSlots.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            itemStack.func_190920_e(Math.min(itemStack.func_190916_E(), this.getMaxStackSize()));
        }
    }

    public ItemStackHandler getItemFilterSlots() {
        return this.itemFilterSlots;
    }

    public boolean isIgnoreDamage() {
        return this.ignoreDamage;
    }

    public boolean isIgnoreNBT() {
        return this.ignoreNBT;
    }

    protected void setIgnoreDamage(boolean ignoreDamage) {
        this.ignoreDamage = ignoreDamage;
        this.markDirty();
    }

    protected void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.markDirty();
    }

    @Override
    public Integer matchItemStack(ItemStack itemStack) {
        int itemFilterMatchIndex = SimpleItemFilter.itemFilterMatch((IItemHandler)this.getItemFilterSlots(), this.isIgnoreDamage(), this.isIgnoreNBT(), itemStack);
        return itemFilterMatchIndex == -1 ? null : Integer.valueOf(itemFilterMatchIndex);
    }

    @Override
    public int getSlotTransferLimit(Object matchSlot, Set<ItemStackKey> matchedStacks, int globalTransferLimit) {
        Integer matchSlotIndex = (Integer)matchSlot;
        ItemStack stackInFilterSlot = this.itemFilterSlots.getStackInSlot(matchSlotIndex.intValue());
        return Math.min(stackInFilterSlot.func_190916_E(), globalTransferLimit);
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return false;
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 36;
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        for (int i = 0; i < 9; ++i) {
            widgetGroup.accept(new PhantomSlotWidget((IItemHandlerModifiable)this.itemFilterSlots, i, 10 + 18 * (i % 3), 0 + 18 * (i / 3)).setBackgroundTexture(GuiTextures.SLOT));
        }
        widgetGroup.accept(new ToggleButtonWidget(74, 0, 20, 20, GuiTextures.BUTTON_FILTER_DAMAGE, () -> this.ignoreDamage, this::setIgnoreDamage).setTooltipText("cover.item_filter.ignore_damage"));
        widgetGroup.accept(new ToggleButtonWidget(99, 0, 20, 20, GuiTextures.BUTTON_FILTER_NBT, () -> this.ignoreNBT, this::setIgnoreNBT).setTooltipText("cover.item_filter.ignore_nbt"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("ItemFilter", (NBTBase)this.itemFilterSlots.serializeNBT());
        tagCompound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        tagCompound.func_74757_a("IgnoreNBT", this.ignoreNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.itemFilterSlots.deserializeNBT(tagCompound.func_74775_l("ItemFilter"));
        this.ignoreDamage = tagCompound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = tagCompound.func_74767_n("IgnoreNBT");
    }

    public static int itemFilterMatch(IItemHandler filterSlots, boolean ignoreDamage, boolean ignoreNBTData, ItemStack itemStack) {
        for (int i = 0; i < filterSlots.getSlots(); ++i) {
            ItemStack filterStack = filterSlots.getStackInSlot(i);
            if (filterStack.func_190926_b() || !SimpleItemFilter.areItemsEqual(ignoreDamage, ignoreNBTData, filterStack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean areItemsEqual(boolean ignoreDamage, boolean ignoreNBTData, ItemStack filterStack, ItemStack itemStack) {
        if (ignoreDamage ? !filterStack.func_185136_b(itemStack) : !filterStack.func_77969_a(itemStack)) {
            return false;
        }
        return ignoreNBTData || ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)itemStack);
    }
}

