/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import gregtech.common.covers.facade.FacadeHelper;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.FacadeItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FacadeRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack resultStack;
    private final NonNullList<Ingredient> ingredients;
    private final ResourceLocation group;

    public FacadeRecipe(ResourceLocation group, Ingredient plateIngredient, int facadeAmount) {
        this.resultStack = MetaItems.COVER_FACADE.getStackForm(facadeAmount);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{plateIngredient, FacadeIngredient.INSTANCE});
        this.group = group;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        boolean[] matched = new boolean[this.ingredients.size()];
        block0: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < matched.length; ++j) {
                if (!((Ingredient)this.ingredients.get(j)).apply(itemStack)) continue;
                if (matched[j]) {
                    return false;
                }
                matched[j] = true;
                continue block0;
            }
            return false;
        }
        for (boolean b : matched) {
            if (b) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack resultStack = this.func_77571_b();
        ItemStack facadeStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (!FacadeIngredient.INSTANCE.apply(itemStack)) continue;
            facadeStack = itemStack;
        }
        if (!facadeStack.func_190926_b()) {
            FacadeItem.setFacadeStack(resultStack, facadeStack);
        }
        return resultStack;
    }

    public ItemStack func_77571_b() {
        return this.resultStack.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    private static class FacadeIngredient
    extends Ingredient {
        public static final FacadeIngredient INSTANCE = new FacadeIngredient();

        private FacadeIngredient() {
            super((ItemStack[])FacadeHelper.getValidFacadeItems().toArray((Object[])new ItemStack[0]));
        }

        public boolean apply(@Nullable ItemStack itemStack) {
            return itemStack != null && !itemStack.func_190926_b() && FacadeHelper.isValidFacade(itemStack);
        }
    }
}

