/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.api.util.SlotDelegate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="gregtech")
public class EnchantmentTableTweaks {
    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        EnchantmentTableTweaks.onContainerOpen(event.getEntityPlayer(), event.getContainer());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)event.getGui();
            EntityPlayerSP playerSP = Minecraft.func_71410_x().field_71439_g;
            EnchantmentTableTweaks.onContainerOpen((EntityPlayer)playerSP, guiContainer.field_147002_h);
        }
    }

    private static void onContainerOpen(EntityPlayer player, Container container) {
        if (container instanceof ContainerEnchantment) {
            try {
                int index = EnchantmentTableTweaks.getEnchantmentSlotIndex((ContainerEnchantment)container);
                if (index != -1) {
                    Slot previousLapisSlot = (Slot)container.field_75151_b.get(index);
                    EnchantmentLapisSlot resultSlot = new EnchantmentLapisSlot(previousLapisSlot);
                    resultSlot.field_75222_d = previousLapisSlot.field_75222_d;
                    container.field_75151_b.set(index, resultSlot);
                }
            }
            catch (Throwable exception) {
                GTLog.logger.warn("Failed to replace enchantment container slot", exception);
            }
        }
    }

    private static int getEnchantmentSlotIndex(ContainerEnchantment container) {
        IInventory inventory = container.field_75168_e;
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            Slot slot = (Slot)container.field_75151_b.get(i);
            if (!slot.func_75217_a(inventory, 1)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isValidForEnchantment(ItemStack itemStack) {
        UnificationEntry entry = OreDictUnifier.getUnificationEntry(itemStack);
        if (entry == null || entry.orePrefix != OrePrefix.gem) {
            return false;
        }
        Material material = entry.material;
        return material == Materials.Lapis || material == Materials.Lazurite || material == Materials.Sodalite;
    }

    private static class EnchantmentLapisSlot
    extends SlotDelegate {
        private static final int ENCHANTMENT_LAPIS_SLOT_INDEX = 1;

        public EnchantmentLapisSlot(Slot delegate) {
            super(delegate);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            return super.func_75214_a(stack) || EnchantmentTableTweaks.isValidForEnchantment(stack);
        }
    }
}

