/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.items.OreDictNames;
import gregtech.api.items.materialitem.MaterialMetaItem;
import gregtech.api.items.metaitem.ElectricStats;
import gregtech.api.items.metaitem.FluidStats;
import gregtech.api.items.metaitem.FoodStats;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.RandomPotionEffect;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.ColorSprayBehaviour;
import gregtech.common.items.behaviors.DynamiteBehaviour;
import gregtech.common.items.behaviors.FoamSprayerBehavior;
import gregtech.common.items.behaviors.IntCircuitBehaviour;
import gregtech.common.items.behaviors.LighterBehaviour;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class MetaItem1
extends MaterialMetaItem {
    public final Map<OrePrefix, OrePrefix> purifyMap = new HashMap<OrePrefix, OrePrefix>();

    public MetaItem1() {
        super(OrePrefix.dustTiny, OrePrefix.dustSmall, OrePrefix.dust, OrePrefix.dustImpure, OrePrefix.dustPure, OrePrefix.crushed, OrePrefix.crushedPurified, OrePrefix.crushedCentrifuged, OrePrefix.gem, OrePrefix.nugget, OrePrefix.ingot, OrePrefix.ingotHot, OrePrefix.plate, OrePrefix.plateDense, OrePrefix.stick, OrePrefix.lens, OrePrefix.bolt, OrePrefix.screw, OrePrefix.ring, OrePrefix.foil, null, null, null, null, null, null, null, null, null, null, null, null);
        this.registerPurifyRecipes();
    }

    private void registerPurifyRecipes() {
        this.purifyMap.put(OrePrefix.crushed, OrePrefix.crushedPurified);
        this.purifyMap.put(OrePrefix.dustImpure, OrePrefix.dust);
        this.purifyMap.put(OrePrefix.dustPure, OrePrefix.dust);
    }

    @Override
    public void registerSubItems() {
        MetaItems.CREDIT_COPPER = this.addItem(0, "credit.copper");
        MetaItems.CREDIT_CUPRONICKEL = ((MetaItem.MetaValueItem)this.addItem(1, "credit.cupronickel")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Cupronickel, 907200L), new MaterialStack[0]));
        MetaItems.CREDIT_SILVER = this.addItem(2, "credit.silver");
        MetaItems.CREDIT_GOLD = this.addItem(3, "credit.gold");
        MetaItems.CREDIT_PLATINUM = this.addItem(4, "credit.platinum");
        MetaItems.CREDIT_OSMIUM = this.addItem(5, "credit.osmium");
        MetaItems.CREDIT_NAQUADAH = this.addItem(6, "credit.naquadah");
        MetaItems.CREDIT_DARMSTADTIUM = this.addItem(7, "credit.darmstadtium");
        MetaItems.COIN_GOLD_ANCIENT = ((MetaItem.MetaValueItem)this.addItem(8, "coin.gold.ancient")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Gold, 907200L), new MaterialStack[0]));
        MetaItems.COIN_DOGE = ((MetaItem.MetaValueItem)this.addItem(9, "coin.doge")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Brass, 907200L), new MaterialStack[0]));
        MetaItems.COIN_CHOCOLATE = ((MetaItem.MetaValueItem)this.addItem(10, "coin.chocolate")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Gold, OrePrefix.foil.materialAmount), new MaterialStack[0])).addComponents(new FoodStats(1, 0.1f, false, true, OreDictUnifier.get(OrePrefix.foil, Materials.Gold), new RandomPotionEffect(MobEffects.field_76424_c, 200, 1, 10)));
        MetaItems.SHAPE_EMPTY = this.addItem(300, "shape.empty");
        MetaItems.SHAPE_MOLD_PLATE = this.addItem(301, "shape.mold.plate");
        MetaItems.SHAPE_MOLD_GEAR = this.addItem(303, "shape.mold.gear");
        MetaItems.SHAPE_MOLD_CREDIT = this.addItem(304, "shape.mold.credit");
        MetaItems.SHAPE_MOLD_BOTTLE = this.addItem(305, "shape.mold.bottle");
        MetaItems.SHAPE_MOLD_INGOT = this.addItem(306, "shape.mold.ingot");
        MetaItems.SHAPE_MOLD_BALL = this.addItem(307, "shape.mold.ball");
        MetaItems.SHAPE_MOLD_BLOCK = this.addItem(308, "shape.mold.block");
        MetaItems.SHAPE_MOLD_NUGGET = this.addItem(309, "shape.mold.nugget");
        MetaItems.SHAPE_MOLD_CYLINDER = this.addItem(313, "shape.mold.cylinder");
        MetaItems.SHAPE_MOLD_ANVIL = this.addItem(314, "shape.mold.anvil");
        MetaItems.SHAPE_MOLD_NAME = this.addItem(315, "shape.mold.name");
        MetaItems.SHAPE_MOLD_GEAR_SMALL = this.addItem(317, "shape.mold.gear.small");
        MetaItems.SHAPE_EXTRUDER_PLATE = this.addItem(350, "shape.extruder.plate");
        MetaItems.SHAPE_EXTRUDER_ROD = this.addItem(351, "shape.extruder.rod");
        MetaItems.SHAPE_EXTRUDER_BOLT = this.addItem(352, "shape.extruder.bolt");
        MetaItems.SHAPE_EXTRUDER_RING = this.addItem(353, "shape.extruder.ring");
        MetaItems.SHAPE_EXTRUDER_CELL = this.addItem(354, "shape.extruder.cell");
        MetaItems.SHAPE_EXTRUDER_INGOT = this.addItem(355, "shape.extruder.ingot");
        MetaItems.SHAPE_EXTRUDER_WIRE = this.addItem(356, "shape.extruder.wire");
        MetaItems.SHAPE_EXTRUDER_PIPE_TINY = this.addItem(358, "shape.extruder.pipe.tiny");
        MetaItems.SHAPE_EXTRUDER_PIPE_SMALL = this.addItem(359, "shape.extruder.pipe.small");
        MetaItems.SHAPE_EXTRUDER_PIPE_MEDIUM = this.addItem(360, "shape.extruder.pipe.medium");
        MetaItems.SHAPE_EXTRUDER_PIPE_LARGE = this.addItem(361, "shape.extruder.pipe.large");
        MetaItems.SHAPE_EXTRUDER_BLOCK = this.addItem(363, "shape.extruder.block");
        MetaItems.SHAPE_EXTRUDER_SWORD = this.addItem(364, "shape.extruder.sword");
        MetaItems.SHAPE_EXTRUDER_PICKAXE = this.addItem(365, "shape.extruder.pickaxe");
        MetaItems.SHAPE_EXTRUDER_SHOVEL = this.addItem(366, "shape.extruder.shovel");
        MetaItems.SHAPE_EXTRUDER_AXE = this.addItem(367, "shape.extruder.axe");
        MetaItems.SHAPE_EXTRUDER_HOE = this.addItem(368, "shape.extruder.hoe");
        MetaItems.SHAPE_EXTRUDER_HAMMER = this.addItem(369, "shape.extruder.hammer");
        MetaItems.SHAPE_EXTRUDER_FILE = this.addItem(370, "shape.extruder.file");
        MetaItems.SHAPE_EXTRUDER_SAW = this.addItem(371, "shape.extruder.saw");
        MetaItems.SHAPE_EXTRUDER_GEAR = this.addItem(372, "shape.extruder.gear");
        MetaItems.SHAPE_EXTRUDER_BOTTLE = this.addItem(373, "shape.extruder.bottle");
        MetaItems.SPRAY_EMPTY = ((MetaItem.MetaValueItem)this.addItem(402, "spray.empty")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Tin, OrePrefix.plate.materialAmount * 2L), new MaterialStack(Materials.Redstone, OrePrefix.dust.materialAmount)));
        MetaItems.LARGE_FLUID_CELL_STEEL = ((MetaItem.MetaValueItem)this.addItem(405, "large_fluid_cell.steel")).addComponents(new FluidStats(64000, Integer.MIN_VALUE, Integer.MAX_VALUE, true)).setMaxStackSize(16).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Steel, OrePrefix.plate.materialAmount * 2L + 2L * OrePrefix.ring.materialAmount), new MaterialStack[0]));
        MetaItems.LARGE_FLUID_CELL_TUNGSTEN_STEEL = ((MetaItem.MetaValueItem)this.addItem(406, "large_fluid_cell.tungstensteel")).addComponents(new FluidStats(256000, Integer.MIN_VALUE, Integer.MAX_VALUE, true)).setMaxStackSize(16).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.TungstenSteel, OrePrefix.plate.materialAmount * 2L + 2L * OrePrefix.ring.materialAmount), new MaterialStack[0]));
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            EnumDyeColor dyeColor = EnumDyeColor.values()[i];
            MetaItems.SPRAY_CAN_DYES[i] = ((MetaItem.MetaValueItem)this.addItem(430 + 2 * i, "spray.can.dyes." + dyeColor.func_176610_l())).setMaxStackSize(1);
            ColorSprayBehaviour behaviour = new ColorSprayBehaviour(MetaItems.SPRAY_EMPTY.getStackForm(), 512, i);
            MetaItems.SPRAY_CAN_DYES[i].addComponents(behaviour);
        }
        MetaItems.TOOL_MATCHES = ((MetaItem.MetaValueItem)this.addItem(471, "tool.matches")).addComponents(new LighterBehaviour(1));
        MetaItems.TOOL_MATCHBOX = ((MetaItem.MetaValueItem)this.addItem(473, "tool.matchbox")).addComponents(new LighterBehaviour(16)).setMaxStackSize(1);
        MetaItems.TOOL_LIGHTER_INVAR = ((MetaItem.MetaValueItem)this.addItem(476, "tool.lighter.invar")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Invar, 288L), new MaterialStack[0])).addComponents(new LighterBehaviour(100)).setMaxStackSize(1);
        MetaItems.TOOL_LIGHTER_PLATINUM = ((MetaItem.MetaValueItem)this.addItem(477, "tool.lighter.platinum")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.Platinum, 288L), new MaterialStack[0])).addComponents(new LighterBehaviour(1000)).setMaxStackSize(1);
        MetaItems.BATTERY_HULL_LV = ((MetaItem.MetaValueItem)this.addItem(500, "battery.hull.lv")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.BatteryAlloy, OrePrefix.plate.materialAmount), new MaterialStack[0]));
        MetaItems.BATTERY_HULL_MV = ((MetaItem.MetaValueItem)this.addItem(501, "battery.hull.hv")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.BatteryAlloy, OrePrefix.plate.materialAmount * 3L), new MaterialStack[0]));
        MetaItems.BATTERY_HULL_HV = ((MetaItem.MetaValueItem)this.addItem(502, "battery.hull.mv")).setMaterialInfo(new ItemMaterialInfo(new MaterialStack(Materials.BatteryAlloy, OrePrefix.plate.materialAmount * 9L), new MaterialStack[0]));
        MetaItems.BATTERY_RE_ULV_TANTALUM = ((MetaItem.MetaValueItem)this.addItem(499, "battery.re.ulv.tantalum")).addComponents(ElectricStats.createRechargeableBattery(1000L, 0));
        MetaItems.BATTERY_SU_LV_SULFURIC_ACID = ((MetaItem.MetaValueItem)this.addItem(510, "battery.su.lv.sulfuricacid")).addComponents(ElectricStats.createBattery(18000L, 1, false)).setModelAmount(8);
        MetaItems.BATTERY_SU_LV_MERCURY = ((MetaItem.MetaValueItem)this.addItem(511, "battery.su.lv.mercury")).addComponents(ElectricStats.createBattery(32000L, 1, false)).setModelAmount(8);
        MetaItems.BATTERY_RE_LV_CADMIUM = ((MetaItem.MetaValueItem)this.addItem(517, "battery.re.lv.cadmium")).addComponents(ElectricStats.createRechargeableBattery(120000L, 1)).setModelAmount(8);
        MetaItems.BATTERY_RE_LV_LITHIUM = ((MetaItem.MetaValueItem)this.addItem(518, "battery.re.lv.lithium")).addComponents(ElectricStats.createRechargeableBattery(100000L, 1)).setModelAmount(8);
        MetaItems.BATTERY_RE_LV_SODIUM = ((MetaItem.MetaValueItem)this.addItem(519, "battery.re.lv.sodium")).addComponents(ElectricStats.createRechargeableBattery(80000L, 1)).setModelAmount(8);
        MetaItems.BATTERY_SU_MV_SULFURIC_ACID = ((MetaItem.MetaValueItem)this.addItem(520, "battery.su.mv.sulfuricacid")).addComponents(ElectricStats.createBattery(72000L, 2, false)).setModelAmount(8);
        MetaItems.BATTERY_SU_MV_MERCURY = ((MetaItem.MetaValueItem)this.addItem(521, "battery.su.mv.mercury")).addComponents(ElectricStats.createBattery(128000L, 2, false)).setModelAmount(8);
        MetaItems.BATTERY_RE_MV_CADMIUM = ((MetaItem.MetaValueItem)this.addItem(527, "battery.re.mv.cadmium")).addComponents(ElectricStats.createRechargeableBattery(420000L, 2)).setModelAmount(8);
        MetaItems.BATTERY_RE_MV_LITHIUM = ((MetaItem.MetaValueItem)this.addItem(528, "battery.re.mv.lithium")).addComponents(ElectricStats.createRechargeableBattery(400000L, 2)).setModelAmount(8);
        MetaItems.BATTERY_RE_MV_SODIUM = ((MetaItem.MetaValueItem)this.addItem(529, "battery.re.mv.sodium")).addComponents(ElectricStats.createRechargeableBattery(360000L, 2)).setModelAmount(8);
        MetaItems.BATTERY_SU_HV_SULFURIC_ACID = ((MetaItem.MetaValueItem)this.addItem(530, "battery.su.hv.sulfuricacid")).addComponents(ElectricStats.createBattery(288000L, 3, false)).setModelAmount(8);
        MetaItems.BATTERY_SU_HV_MERCURY = ((MetaItem.MetaValueItem)this.addItem(531, "battery.su.hv.mercury")).addComponents(ElectricStats.createBattery(512000L, 3, false)).setModelAmount(8);
        MetaItems.BATTERY_RE_HV_CADMIUM = ((MetaItem.MetaValueItem)this.addItem(537, "battery.re.hv.cadmium")).addComponents(ElectricStats.createRechargeableBattery(1800000L, 3)).setModelAmount(8);
        MetaItems.BATTERY_RE_HV_LITHIUM = ((MetaItem.MetaValueItem)this.addItem(538, "battery.re.hv.lithium")).addComponents(ElectricStats.createRechargeableBattery(1600000L, 3)).setModelAmount(8);
        MetaItems.BATTERY_RE_HV_SODIUM = ((MetaItem.MetaValueItem)this.addItem(539, "battery.re.hv.sodium")).addComponents(ElectricStats.createRechargeableBattery(1200000L, 3)).setModelAmount(8);
        MetaItems.ENERGY_LAPOTRONIC_ORB = ((MetaItem.MetaValueItem)this.addItem(597, "energy.lapotronicorb")).addComponents(ElectricStats.createRechargeableBattery(100000000L, 5)).setUnificationData(OrePrefix.battery, MarkerMaterials.Tier.Ultimate).setModelAmount(8);
        MetaItems.ENERGY_LAPOTRONIC_ORB2 = ((MetaItem.MetaValueItem)this.addItem(598, "energy.lapotronicorb2")).addComponents(ElectricStats.createRechargeableBattery(1000000000L, 6)).setUnificationData(OrePrefix.battery, MarkerMaterials.Tier.Ultimate).setModelAmount(8);
        MetaItems.ZPM = ((MetaItem.MetaValueItem)this.addItem(599, "zpm")).addComponents(ElectricStats.createBattery(2000000000000L, 7, false)).setModelAmount(8);
        MetaItems.ZPM2 = ((MetaItem.MetaValueItem)this.addItem(605, "zpm2")).addComponents(ElectricStats.createRechargeableBattery(Long.MAX_VALUE, 8)).setModelAmount(8);
        MetaItems.ELECTRIC_MOTOR_LV = this.addItem(600, "electric.motor.lv");
        MetaItems.ELECTRIC_MOTOR_MV = this.addItem(601, "electric.motor.mv");
        MetaItems.ELECTRIC_MOTOR_HV = this.addItem(602, "electric.motor.hv");
        MetaItems.ELECTRIC_MOTOR_EV = this.addItem(603, "electric.motor.ev");
        MetaItems.ELECTRIC_MOTOR_IV = this.addItem(604, "electric.motor.iv");
        MetaItems.ELECTRIC_MOTOR_LUV = this.addItem(606, "electric.motor.luv");
        MetaItems.ELECTRIC_MOTOR_ZPM = this.addItem(607, "electric.motor.zpm");
        MetaItems.ELECTRIC_MOTOR_UV = this.addItem(608, "electric.motor.uv");
        MetaItems.ELECTRIC_PUMP_LV = this.addItem(610, "electric.pump.lv");
        MetaItems.ELECTRIC_PUMP_MV = this.addItem(611, "electric.pump.mv");
        MetaItems.ELECTRIC_PUMP_HV = this.addItem(612, "electric.pump.hv");
        MetaItems.ELECTRIC_PUMP_EV = this.addItem(613, "electric.pump.ev");
        MetaItems.ELECTRIC_PUMP_IV = this.addItem(614, "electric.pump.iv");
        MetaItems.ELECTRIC_PUMP_LUV = this.addItem(615, "electric.pump.luv");
        MetaItems.ELECTRIC_PUMP_ZPM = this.addItem(616, "electric.pump.zpm");
        MetaItems.ELECTRIC_PUMP_UV = this.addItem(617, "electric.pump.uv");
        MetaItems.RUBBER_DROP = ((MetaItem.MetaValueItem)this.addItem(627, "rubber_drop")).setBurnValue(200);
        MetaItems.FLUID_FILTER = this.addItem(628, "fluid_filter");
        MetaItems.DYNAMITE = ((MetaItem.MetaValueItem)this.addItem(629, "dynamite")).addComponents(new DynamiteBehaviour()).setMaxStackSize(16);
        MetaItems.CONVEYOR_MODULE_LV = this.addItem(630, "conveyor.module.lv");
        MetaItems.CONVEYOR_MODULE_MV = this.addItem(631, "conveyor.module.mv");
        MetaItems.CONVEYOR_MODULE_HV = this.addItem(632, "conveyor.module.hv");
        MetaItems.CONVEYOR_MODULE_EV = this.addItem(633, "conveyor.module.ev");
        MetaItems.CONVEYOR_MODULE_IV = this.addItem(634, "conveyor.module.iv");
        MetaItems.CONVEYOR_MODULE_LUV = this.addItem(635, "conveyor.module.luv");
        MetaItems.CONVEYOR_MODULE_ZPM = this.addItem(636, "conveyor.module.zpm");
        MetaItems.CONVEYOR_MODULE_UV = this.addItem(637, "conveyor.module.uv");
        MetaItems.ELECTRIC_PISTON_LV = this.addItem(640, "electric.piston.lv");
        MetaItems.ELECTRIC_PISTON_MV = this.addItem(641, "electric.piston.mv");
        MetaItems.ELECTRIC_PISTON_HV = this.addItem(642, "electric.piston.hv");
        MetaItems.ELECTRIC_PISTON_EV = this.addItem(643, "electric.piston.ev");
        MetaItems.ELECTRIC_PISTON_IV = this.addItem(644, "electric.piston.iv");
        MetaItems.ELECTRIC_PISTON_LUV = this.addItem(645, "electric.piston.luv");
        MetaItems.ELECTRIC_PISTON_ZPM = this.addItem(646, "electric.piston.zpm");
        MetaItems.ELECTRIC_PISTON_UV = this.addItem(647, "electric.piston.uv");
        MetaItems.ROBOT_ARM_LV = this.addItem(650, "robot.arm.lv");
        MetaItems.ROBOT_ARM_MV = this.addItem(651, "robot.arm.mv");
        MetaItems.ROBOT_ARM_HV = this.addItem(652, "robot.arm.hv");
        MetaItems.ROBOT_ARM_EV = this.addItem(653, "robot.arm.ev");
        MetaItems.ROBOT_ARM_IV = this.addItem(654, "robot.arm.iv");
        MetaItems.ROBOT_ARM_LUV = this.addItem(655, "robot.arm.luv");
        MetaItems.ROBOT_ARM_ZPM = this.addItem(656, "robot.arm.zpm");
        MetaItems.ROBOT_ARM_UV = this.addItem(657, "robot.arm.uv");
        MetaItems.FIELD_GENERATOR_LV = this.addItem(670, "field.generator.lv");
        MetaItems.FIELD_GENERATOR_MV = this.addItem(671, "field.generator.mv");
        MetaItems.FIELD_GENERATOR_HV = this.addItem(672, "field.generator.hv");
        MetaItems.FIELD_GENERATOR_EV = this.addItem(673, "field.generator.ev");
        MetaItems.FIELD_GENERATOR_IV = this.addItem(674, "field.generator.iv");
        MetaItems.FIELD_GENERATOR_LUV = this.addItem(675, "field.generator.luv");
        MetaItems.FIELD_GENERATOR_ZPM = this.addItem(676, "field.generator.zpm");
        MetaItems.FIELD_GENERATOR_UV = this.addItem(677, "field.generator.uv");
        MetaItems.EMITTER_LV = this.addItem(680, "emitter.lv");
        MetaItems.EMITTER_MV = this.addItem(681, "emitter.mv");
        MetaItems.EMITTER_HV = this.addItem(682, "emitter.hv");
        MetaItems.EMITTER_EV = this.addItem(683, "emitter.ev");
        MetaItems.EMITTER_IV = this.addItem(684, "emitter.iv");
        MetaItems.EMITTER_LUV = this.addItem(685, "emitter.luv");
        MetaItems.EMITTER_ZPM = this.addItem(686, "emitter.zpm");
        MetaItems.EMITTER_UV = this.addItem(687, "emitter.uv");
        MetaItems.SENSOR_LV = this.addItem(690, "sensor.lv");
        MetaItems.SENSOR_MV = this.addItem(691, "sensor.mv");
        MetaItems.SENSOR_HV = this.addItem(692, "sensor.hv");
        MetaItems.SENSOR_EV = this.addItem(693, "sensor.ev");
        MetaItems.SENSOR_IV = this.addItem(694, "sensor.iv");
        MetaItems.SENSOR_LUV = this.addItem(695, "sensor.luv");
        MetaItems.SENSOR_ZPM = this.addItem(696, "sensor.zpm");
        MetaItems.SENSOR_UV = this.addItem(697, "sensor.uv");
        MetaItems.TOOL_DATA_STICK = this.addItem(708, "tool.datastick");
        MetaItems.TOOL_DATA_ORB = this.addItem(707, "tool.dataorb");
        MetaItems.COMPONENT_SAW_BLADE_DIAMOND = ((MetaItem.MetaValueItem)this.addItem(721, "component.sawblade.diamond")).addOreDict(OreDictNames.craftingDiamondBlade);
        MetaItems.COMPONENT_GRINDER_DIAMOND = ((MetaItem.MetaValueItem)this.addItem(722, "component.grinder.diamond")).addOreDict(OreDictNames.craftingGrinder);
        MetaItems.COMPONENT_GRINDER_TUNGSTEN = ((MetaItem.MetaValueItem)this.addItem(723, "component.grinder.tungsten")).addOreDict(OreDictNames.craftingGrinder);
        MetaItems.QUANTUM_EYE = this.addItem(724, "quantumeye");
        MetaItems.QUANTUM_STAR = this.addItem(725, "quantumstar");
        MetaItems.GRAVI_STAR = this.addItem(726, "gravistar");
        MetaItems.ITEM_FILTER = this.addItem(729, "item_filter");
        MetaItems.ORE_DICTIONARY_FILTER = this.addItem(102, "ore_dictionary_filter");
        MetaItems.SMART_FILTER = this.addItem(103, "smart_item_filter");
        MetaItems.COVER_MACHINE_CONTROLLER = this.addItem(730, "cover.controller");
        MetaItems.COVER_ACTIVITY_DETECTOR = ((MetaItem.MetaValueItem)this.addItem(731, "cover.activity.detector")).setInvisible();
        MetaItems.COVER_FLUID_DETECTOR = ((MetaItem.MetaValueItem)this.addItem(732, "cover.fluid.detector")).setInvisible();
        MetaItems.COVER_ITEM_DETECTOR = ((MetaItem.MetaValueItem)this.addItem(733, "cover.item.detector")).setInvisible();
        MetaItems.COVER_ENERGY_DETECTOR = ((MetaItem.MetaValueItem)this.addItem(734, "cover.energy.detector")).setInvisible();
        MetaItems.COVER_SCREEN = ((MetaItem.MetaValueItem)this.addItem(740, "cover.screen")).setInvisible();
        MetaItems.COVER_CRAFTING = ((MetaItem.MetaValueItem)this.addItem(744, "cover.crafting")).setInvisible();
        MetaItems.COVER_DRAIN = ((MetaItem.MetaValueItem)this.addItem(745, "cover.drain")).setInvisible();
        MetaItems.COVER_SHUTTER = this.addItem(749, "cover.shutter");
        MetaItems.COVER_SOLAR_PANEL = this.addItem(750, "cover.solar.panel");
        MetaItems.COVER_SOLAR_PANEL_ULV = this.addItem(751, "cover.solar.panel.ulv");
        MetaItems.COVER_SOLAR_PANEL_LV = this.addItem(752, "cover.solar.panel.lv");
        MetaItems.FLUID_CELL = ((MetaItem.MetaValueItem)this.addItem(762, "fluid_cell")).addComponents(new FluidStats(1000, Integer.MIN_VALUE, Integer.MAX_VALUE, false));
        MetaItems.INTEGRATED_CIRCUIT = ((MetaItem.MetaValueItem)this.addItem(766, "circuit.integrated")).addComponents(new IntCircuitBehaviour());
        MetaItems.FOAM_SPRAYER = ((MetaItem.MetaValueItem)this.addItem(746, "foam_sprayer")).addComponents(new FoamSprayerBehavior());
    }

    public void registerRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.plate, Materials.Tin, 2)).outputs(MetaItems.SPRAY_EMPTY.getStackForm())).duration(200)).EUt(8)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDense, Materials.Steel, 2)).input(OrePrefix.ring, Materials.Steel, 8)).outputs(MetaItems.LARGE_FLUID_CELL_STEEL.getStackForm())).circuitMeta(1).duration(100)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plateDense, Materials.TungstenSteel, 2)).input(OrePrefix.ring, Materials.TungstenSteel, 8)).outputs(MetaItems.LARGE_FLUID_CELL_TUNGSTEN_STEEL.getStackForm())).circuitMeta(1).duration(200)).EUt(256)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Tin, 6)).inputs(MetaItems.SPRAY_EMPTY.getStackForm())).input(OrePrefix.paneGlass.name(), 1)).outputs(MetaItems.FOAM_SPRAYER.getStackForm())).duration(200)).EUt(8)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dustSmall, Materials.Phosphorus)).outputs(MetaItems.TOOL_MATCHES.getStackForm())).duration(16)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dustSmall, Materials.Phosphor)).outputs(MetaItems.TOOL_MATCHES.getStackForm())).duration(16)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood, 4)).input(OrePrefix.dust, Materials.Phosphorus)).outputs(MetaItems.TOOL_MATCHES.getStackForm(4))).duration(64)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood, 4)).input(OrePrefix.dust, Materials.Phosphor)).outputs(MetaItems.TOOL_MATCHES.getStackForm(4))).duration(64)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(MetaItems.TOOL_MATCHES.getStackForm(16))).input(OrePrefix.plate, Materials.Paper)).outputs(MetaItems.TOOL_MATCHBOX.getStackForm())).duration(64)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Invar, 2)).inputs(new ItemStack(Items.field_151145_ak, 1))).outputs(MetaItems.TOOL_LIGHTER_INVAR.getStackForm())).duration(256)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Platinum, 2)).inputs(new ItemStack(Items.field_151145_ak, 1))).outputs(MetaItems.TOOL_LIGHTER_PLATINUM.getStackForm())).duration(256)).EUt(256)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_LV_SULFURIC_ACID.getStackForm())).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_LV_MERCURY.getStackForm())).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_MV_SULFURIC_ACID.getStackForm())).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_MV_MERCURY.getStackForm())).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_HV_SULFURIC_ACID.getStackForm())).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_SU_HV_MERCURY.getStackForm())).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_LV_CADMIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_LV_LITHIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_LV_SODIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_MV_CADMIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_MV_LITHIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_MV_SODIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_HV_CADMIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_HV_LITHIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_RE_HV_SODIUM.getStackForm())).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_LV.getStackForm())).input(OrePrefix.dust, Materials.Cadmium, 2)).outputs(MetaItems.BATTERY_RE_LV_CADMIUM.getStackForm())).duration(100)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_LV.getStackForm())).input(OrePrefix.dust, Materials.Lithium, 2)).outputs(MetaItems.BATTERY_RE_LV_LITHIUM.getStackForm())).duration(100)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_LV.getStackForm())).input(OrePrefix.dust, Materials.Sodium, 2)).outputs(MetaItems.BATTERY_RE_LV_SODIUM.getStackForm())).duration(100)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_MV.getStackForm())).input(OrePrefix.dust, Materials.Cadmium, 8)).outputs(MetaItems.BATTERY_RE_MV_CADMIUM.getStackForm())).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_MV.getStackForm())).input(OrePrefix.dust, Materials.Lithium, 8)).outputs(MetaItems.BATTERY_RE_MV_LITHIUM.getStackForm())).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_MV.getStackForm())).input(OrePrefix.dust, Materials.Sodium, 8)).outputs(MetaItems.BATTERY_RE_MV_SODIUM.getStackForm())).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_HV.getStackForm())).input(OrePrefix.dust, Materials.Cadmium, 16)).outputs(MetaItems.BATTERY_RE_HV_CADMIUM.getStackForm())).duration(1600)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_HV.getStackForm())).input(OrePrefix.dust, Materials.Lithium, 16)).outputs(MetaItems.BATTERY_RE_HV_LITHIUM.getStackForm())).duration(1600)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().inputs(MetaItems.BATTERY_HULL_HV.getStackForm())).input(OrePrefix.dust, Materials.Sodium, 16)).outputs(MetaItems.BATTERY_RE_HV_SODIUM.getStackForm())).duration(1600)).EUt(2)).buildAndRegister();
    }

    public boolean isBeaconPayment(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage >= this.metaItemOffset) {
            return false;
        }
        Material material = Material.MATERIAL_REGISTRY.getObjectById(damage % 1000);
        OrePrefix prefix = this.orePrefixes[damage / 1000];
        if (prefix != null && material != null) {
            boolean isSolidState = prefix == OrePrefix.ingot || prefix == OrePrefix.gem;
            boolean isMaterialTiered = material instanceof SolidMaterial && ((SolidMaterial)material).harvestLevel >= 2;
            return isSolidState && isMaterialTiered;
        }
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem itemEntity) {
        int waterLevel;
        int damage = itemEntity.func_92059_d().func_77960_j();
        if (damage >= this.metaItemOffset || itemEntity.func_130014_f_().field_72995_K) {
            return false;
        }
        Material material = Material.MATERIAL_REGISTRY.getObjectById(damage % 1000);
        OrePrefix prefix = this.orePrefixes[damage / 1000];
        if (!this.purifyMap.containsKey((Object)prefix)) {
            return false;
        }
        BlockPos blockPos = new BlockPos((Entity)itemEntity);
        IBlockState blockState = itemEntity.func_130014_f_().func_180495_p(blockPos);
        int n = waterLevel = blockState.func_177230_c() instanceof BlockCauldron ? (Integer)blockState.func_177229_b((IProperty)BlockCauldron.field_176591_a) : 0;
        if (waterLevel == 0) {
            return false;
        }
        itemEntity.func_130014_f_().func_175656_a(blockPos, blockState.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(waterLevel - 1)));
        ItemStack replacementStack = OreDictUnifier.get(this.purifyMap.get((Object)prefix), material, itemEntity.func_92059_d().func_190916_E());
        itemEntity.func_92058_a(replacementStack);
        return false;
    }

    @Override
    protected void addMaterialTooltip(ItemStack itemStack, OrePrefix prefix, Material material, List<String> lines, ITooltipFlag tooltipFlag) {
        if (prefix == OrePrefix.dustImpure || prefix == OrePrefix.dustPure) {
            lines.add(I18n.func_135052_a((String)"metaitem.dust.tooltip.purify", (Object[])new Object[0]));
        }
    }
}

