/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipes.CokeOvenRecipe;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOvenHatch;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityCokeOven
extends MultiblockControllerBase {
    private int maxProgressDuration;
    private int currentProgress;
    private ItemStack outputStack;
    private FluidStack outputFluid;
    private boolean isActive;
    private boolean wasActiveAndNeedUpdate;
    private ItemStack lastInputStack = ItemStack.field_190927_a;
    private CokeOvenRecipe previousRecipe;

    public MetaTileEntityCokeOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    protected void updateFormedValid() {
        if (this.maxProgressDuration == 0) {
            if (this.tryPickNewRecipe()) {
                if (this.wasActiveAndNeedUpdate) {
                    this.wasActiveAndNeedUpdate = false;
                } else {
                    this.setActive(true);
                }
            }
        } else if (++this.currentProgress >= this.maxProgressDuration) {
            this.finishCurrentRecipe();
            this.wasActiveAndNeedUpdate = true;
            return;
        }
        if (this.wasActiveAndNeedUpdate) {
            this.wasActiveAndNeedUpdate = false;
            this.setActive(false);
        }
    }

    private void finishCurrentRecipe() {
        this.maxProgressDuration = 0;
        this.currentProgress = 0;
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.exportItems, (ItemStack)this.outputStack, (boolean)false);
        this.exportFluids.fill(this.outputFluid, true);
        this.markDirty();
    }

    private CokeOvenRecipe getOrRefreshRecipe(ItemStack inputStack) {
        CokeOvenRecipe currentRecipe = null;
        if (this.previousRecipe != null && this.previousRecipe.getInput().getIngredient().apply(inputStack)) {
            currentRecipe = this.previousRecipe;
        } else if (!MetaTileEntityCokeOven.areItemStacksEqual(inputStack, this.lastInputStack)) {
            this.lastInputStack = inputStack.func_190926_b() ? ItemStack.field_190927_a : inputStack.func_77946_l();
            currentRecipe = RecipeMaps.COKE_OVEN_RECIPES.stream().filter(it -> it.getInput().getIngredient().test((Object)inputStack)).findFirst().orElse(null);
            if (currentRecipe != null) {
                this.previousRecipe = currentRecipe;
            }
        }
        return currentRecipe;
    }

    private static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_190926_b() && stackB.func_190926_b() || ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    private boolean setupRecipe(ItemStack inputStack, CokeOvenRecipe recipe) {
        return inputStack.func_190916_E() >= recipe.getInput().getCount() && ItemHandlerHelper.insertItemStacked((IItemHandler)this.exportItems, (ItemStack)recipe.getOutput(), (boolean)true).func_190926_b() && this.exportFluids.fill(recipe.getFluidOutput(), false) == recipe.getFluidOutput().amount;
    }

    private boolean tryPickNewRecipe() {
        ItemStack inputStack = this.importItems.getStackInSlot(0);
        if (inputStack.func_190926_b()) {
            return false;
        }
        CokeOvenRecipe currentRecipe = this.getOrRefreshRecipe(inputStack);
        if (currentRecipe != null && this.setupRecipe(inputStack, currentRecipe)) {
            inputStack.func_190918_g(currentRecipe.getInput().getCount());
            this.maxProgressDuration = currentRecipe.getDuration();
            this.currentProgress = 0;
            this.outputStack = currentRecipe.getOutput().func_77946_l();
            this.outputFluid = currentRecipe.getFluidOutput().copy();
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Active", this.isActive);
        data.func_74757_a("WasActive", this.wasActiveAndNeedUpdate);
        data.func_74768_a("MaxProgress", this.maxProgressDuration);
        if (this.maxProgressDuration > 0) {
            data.func_74768_a("Progress", this.currentProgress);
            data.func_74782_a("OutputItem", (NBTBase)this.outputStack.func_77955_b(new NBTTagCompound()));
            data.func_74782_a("OutputFluid", (NBTBase)this.outputFluid.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("Active");
        this.wasActiveAndNeedUpdate = data.func_74767_n("WasActive");
        this.maxProgressDuration = data.func_74762_e("MaxProgress");
        if (this.maxProgressDuration > 0) {
            this.currentProgress = data.func_74762_e("Progress");
            this.outputStack = new ItemStack(data.func_74775_l("OutputItem"));
            this.outputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("OutputFluid"));
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isActive = buf.readBoolean();
            this.getWorld().func_175664_x(this.getPos());
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(100, b -> b.writeBoolean(this.isActive));
            this.getWorld().func_175664_x(this.getPos());
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int getLightValueForPart(IMultiblockPart sourcePart) {
        return sourcePart == null && this.isActive ? 15 : 0;
    }

    public double getProgressScaled() {
        return this.maxProgressDuration == 0 ? 0.0 : (double)this.currentProgress / ((double)this.maxProgressDuration * 1.0);
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.COKE_BRICKS);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.COKE_BRICKS;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.COKE_OVEN_OVERLAY.render(renderState, translation, pipeline, this.getFrontFacing(), this.isActive());
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(32000)});
    }

    @Override
    protected BlockPattern createStructurePattern() {
        Predicate<BlockWorldState> hatchPredicate = MetaTileEntityCokeOven.tilePredicate((state, tile) -> tile instanceof MetaTileEntityCokeOvenHatch);
        return FactoryBlockPattern.start().aisle("XXX", "XZX", "XXX").aisle("XZX", "Z#Z", "XZX").aisle("XXX", "XYX", "XXX").where('Z', MetaTileEntityCokeOven.statePredicate(this.getCasingState()).or(hatchPredicate)).where('X', MetaTileEntityCokeOven.statePredicate(this.getCasingState())).where('#', MetaTileEntityCokeOven.isAirPredicate()).where('Y', this.selfPredicate()).build();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityCokeOven(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 166).widget(new SlotWidget(this.importItems, 0, 33, 30, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FURNACE_OVERLAY)).progressBar(this::getProgressScaled, 58, 30, 20, 15, GuiTextures.BRONZE_BLAST_FURNACE_PROGRESS_BAR, ProgressWidget.MoveType.HORIZONTAL).widget(new SlotWidget(this.exportItems, 0, 85, 30, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FURNACE_OVERLAY)).widget(new TankWidget(this.exportFluids.getTankAt(0), 133, 13, 20, 58).setBackgroundTexture(GuiTextures.FLUID_TANK_BACKGROUND).setOverlayTexture(GuiTextures.FLUID_TANK_OVERLAY).setContainerClicking(true, false)).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT).build(this.getHolder(), entityPlayer);
    }
}

