/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.SortingButtonWidget;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityChest
extends MetaTileEntity
implements IFastRenderMetaTileEntity {
    private static final IndexedCuboid6 CHEST_COLLISION = new IndexedCuboid6(null, new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375));
    private final SolidMaterial material;
    private final int rowSize;
    private final int amountOfRows;
    private ItemStackHandler inventory;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;

    public MetaTileEntityChest(ResourceLocation metaTileEntityId, SolidMaterial material, int rowSize, int amountOfRows) {
        super(metaTileEntityId);
        this.material = material;
        this.rowSize = rowSize;
        this.amountOfRows = amountOfRows;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityChest(this.metaTileEntityId, this.material, this.rowSize, this.amountOfRows);
    }

    @Override
    public void update() {
        super.update();
        BlockPos blockPos = this.getPos();
        this.prevLidAngle = this.lidAngle;
        if (!this.getWorld().field_72995_K && this.numPlayersUsing != 0 && this.getTimer() % 200L == 0L) {
            int lastPlayersUsing = this.numPlayersUsing;
            this.numPlayersUsing = GTUtility.findPlayersUsing(this, 10.0).size();
            if (lastPlayersUsing != this.numPlayersUsing) {
                this.updateNumPlayersUsing();
            }
        }
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double soundX = (double)blockPos.func_177958_n() + 0.5;
            double soundZ = (double)blockPos.func_177952_p() + 0.5;
            double soundY = (double)blockPos.func_177956_o() + 0.5;
            this.getWorld().func_184148_a(null, soundX, soundY, soundZ, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.getWorld().field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float currentValue = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            } else if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
            if (this.lidAngle < 0.5f && currentValue >= 0.5f) {
                double soundX = (double)blockPos.func_177958_n() + 0.5;
                double soundZ = (double)blockPos.func_177952_p() + 0.5;
                double soundY = (double)blockPos.func_177956_o() + 0.5;
                this.getWorld().func_184148_a(null, soundX, soundY, soundZ, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.getWorld().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    private void onContainerOpen(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.updateNumPlayersUsing();
        }
    }

    private void onContainerClose(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.updateNumPlayersUsing();
        }
    }

    private void updateNumPlayersUsing() {
        this.writeCustomData(100, buffer -> buffer.func_150787_b(this.numPlayersUsing));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.numPlayersUsing);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.numPlayersUsing = buf.func_150792_a();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.numPlayersUsing = buf.func_150792_a();
        }
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public String getHarvestTool() {
        return ModHandler.isMaterialWood(this.material) ? "axe" : "pickaxe";
    }

    @Override
    public void addCollisionBoundingBox(List<IndexedCuboid6> collisionList) {
        collisionList.add(CHEST_COLLISION);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.inventory = new ItemStackHandler(this.rowSize * this.amountOfRows);
        this.itemInventory = this.inventory;
    }

    @Override
    public int getActualComparatorValue() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntityChest.clearInventory(itemBuffer, (IItemHandlerModifiable)this.inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        if (ModHandler.isMaterialWood(this.material)) {
            return Pair.of((Object)Textures.WOODEN_CHEST.getParticleTexture(), (Object)this.getPaintingColor());
        }
        return Pair.of((Object)Textures.METAL_CHEST.getParticleTexture(), (Object)this.getPaintingColor());
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0625;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
    }

    @Override
    public void renderMetaTileEntityFast(CCRenderState renderState, Matrix4 translation, float partialTicks) {
        float angle = this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
        angle = 1.0f - (1.0f - angle) * (1.0f - angle) * (1.0f - angle);
        float resultLidAngle = angle * 90.0f;
        if (ModHandler.isMaterialWood(this.material)) {
            ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
            Textures.WOODEN_CHEST.render(renderState, translation, new IVertexOperation[]{multiplier}, this.getFrontFacing(), resultLidAngle);
        } else {
            ColourMultiplier multiplier = new ColourMultiplier(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.materialRGB), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
            Textures.METAL_CHEST.render(renderState, translation, new IVertexOperation[]{multiplier}, this.getFrontFacing(), resultLidAngle);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos().func_177982_a(-1, -1, -1), this.getPos().func_177982_a(2, 2, 2));
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, Math.max(176, 14 + this.rowSize * 18), 18 + 18 * this.amountOfRows + 94).label(5, 5, this.getMetaFullName());
        builder.widget(new SortingButtonWidget(111, 4, 60, 10, "gregtech.gui.sort", info -> MetaTileEntityChest.sortInventorySlotContents((IItemHandlerModifiable)this.inventory)));
        for (int y = 0; y < this.amountOfRows; ++y) {
            for (int x = 0; x < this.rowSize; ++x) {
                int index = y * this.rowSize + x;
                builder.slot((IItemHandlerModifiable)this.inventory, index, 8 + x * 18, 18 + y * 18, GuiTextures.SLOT);
            }
        }
        int startX = (Math.max(176, 14 + this.rowSize * 18) - 162) / 2;
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, startX, 18 + 18 * this.amountOfRows + 12);
        if (!this.getWorld().field_72995_K) {
            builder.bindOpenListener(() -> this.onContainerOpen(entityPlayer));
            builder.bindCloseListener(() -> this.onContainerClose(entityPlayer));
        }
        return builder.build(this.getHolder(), entityPlayer);
    }

    private static void sortInventorySlotContents(IItemHandlerModifiable inventory) {
        int i;
        for (int i2 = 0; i2 < inventory.getSlots(); ++i2) {
            for (int j = i2 + 1; j < inventory.getSlots(); ++j) {
                ItemStack stack1 = inventory.getStackInSlot(i2);
                ItemStack stack2 = inventory.getStackInSlot(j);
                if (stack1.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) || !ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)) continue;
                int maxStackSize = Math.min(stack1.func_77976_d(), inventory.getSlotLimit(i2));
                int itemsCanAccept = Math.min(stack2.func_190916_E(), maxStackSize - Math.min(stack1.func_190916_E(), maxStackSize));
                if (itemsCanAccept <= 0) continue;
                stack1.func_190917_f(itemsCanAccept);
                stack2.func_190918_g(itemsCanAccept);
            }
        }
        ArrayList<ItemStack> inventoryContents = new ArrayList<ItemStack>();
        for (i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
            inventoryContents.add(itemStack);
        }
        inventoryContents.sort(MetaTileEntityChest::compareItemStacks);
        for (i = 0; i < inventoryContents.size(); ++i) {
            inventory.setStackInSlot(i, (ItemStack)inventoryContents.get(i));
        }
    }

    private static int compareItemStacks(ItemStack stack1, ItemStack stack2) {
        int secondItemId;
        int firstItemId = Item.field_150901_e.func_148757_b((Object)stack1.func_77973_b());
        int result = Integer.compare(firstItemId, secondItemId = Item.field_150901_e.func_148757_b((Object)stack2.func_77973_b()));
        if (result != 0) {
            return result;
        }
        result = Integer.compare(stack1.func_77952_i(), stack2.func_77952_i());
        if (result != 0) {
            return result;
        }
        if (stack1.func_77942_o() != stack2.func_77942_o()) {
            return stack1.func_77942_o() ? 1 : -1;
        }
        if (stack1.func_77942_o() && !stack1.func_77978_p().equals((Object)stack2.func_77978_p()) && (result = -Integer.compare(stack1.func_77978_p().hashCode(), stack2.func_77978_p().hashCode())) != 0) {
            return result;
        }
        result = -Integer.compare(stack1.func_190916_E(), stack2.func_190916_E());
        return result;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.deserializeNBT(data.func_74775_l("Inventory"));
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.rowSize * this.amountOfRows}));
    }
}

