/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.ImmutableList;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.metaitem.DefaultSubItemHandler;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.TankRenderer;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.ByteBufUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WatchedFluidTank;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityTank
extends MetaTileEntity
implements IFastRenderMetaTileEntity {
    private static final int FLUID_SYNC_THROTTLE = 0;
    private final int tankSize;
    private final int maxMultiblockSize;
    private final SolidMaterial material;
    private boolean addedToMultiblock = false;
    private boolean needsCoversUpdate = false;
    private boolean isRemoved = false;
    private int blockedSides = 0;
    private int connectionMask = 0;
    private final FluidTank multiblockFluidTank;
    private List<BlockPos> connectedTanks = new ArrayList<BlockPos>();
    private BlockPos lowestPos = BlockPos.field_177992_a;
    private BlockPos highestPos = BlockPos.field_177992_a;
    private TIntList tankCountByLevel = new TIntArrayList();
    private TIntList sumCapacityByLevel = new TIntArrayList();
    private BlockPos controllerPos = null;
    private WeakReference<MetaTileEntityTank> controllerCache = new WeakReference<Object>(null);
    private NetworkStatus networkStatus;
    private int timeSinceLastFluidSync = Integer.MAX_VALUE;
    private FluidStack lastSentFluidStack;
    private boolean needsShapeResync;
    private boolean needsFluidResync;

    public MetaTileEntityTank(ResourceLocation metaTileEntityId, SolidMaterial material, int tankSize, int maxMultiblockSize) {
        super(metaTileEntityId);
        this.tankSize = tankSize;
        this.material = material;
        this.maxMultiblockSize = maxMultiblockSize == -1 ? Integer.MAX_VALUE : maxMultiblockSize;
        this.multiblockFluidTank = new WatchedFluidTank(tankSize){

            @Override
            protected void onFluidChanged(FluidStack newFluidStack, FluidStack oldFluidStack) {
                MetaTileEntityTank.this.onFluidChangedInternal();
            }
        };
        this.initializeInventory();
    }

    @Override
    public void update() {
        int newConnectionMask;
        this.fluidInventory = this.getActualFluidTank();
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (!this.addedToMultiblock) {
                this.addedToMultiblock = true;
                this.rescanTankMultiblocks(Collections.emptySet());
            }
            if (this.networkStatus == NetworkStatus.ATTACHED_TO_MULTIBLOCK) {
                this.writeCustomData(1, buf -> buf.func_179255_a(this.controllerPos));
                this.needsFluidResync = false;
                this.networkStatus = null;
                this.needsShapeResync = false;
            }
            if (this.networkStatus == NetworkStatus.DETACHED_FROM_MULTIBLOCK) {
                this.writeCustomData(2, buf -> {});
                this.networkStatus = null;
            }
            if (this.isTankController() && this.needsShapeResync) {
                this.writeCustomData(4, buf -> ByteBufUtils.writeRelativeBlockList(buf, this.getPos(), this.connectedTanks));
                this.needsShapeResync = false;
            }
            if (this.isTankController() && this.needsFluidResync && this.timeSinceLastFluidSync++ >= 0) {
                FluidStack fluidStack = this.multiblockFluidTank.getFluid();
                this.writeCustomData(3, buf -> ByteBufUtils.writeFluidStackDelta(buf, this.lastSentFluidStack, fluidStack));
                this.lastSentFluidStack = fluidStack == null ? null : fluidStack.copy();
                this.timeSinceLastFluidSync = 0;
                this.needsFluidResync = false;
            }
        }
        if (this.needsCoversUpdate) {
            this.needsCoversUpdate = false;
            this.recheckBlockedSides();
            if (!this.getWorld().field_72995_K) {
                this.rescanTankMultiblocks(this.recomputeNearbyMultiblocks());
            }
        }
        if (this.getWorld().field_72995_K && this.connectionMask != (newConnectionMask = this.getConnectionMaskForTank(this.getPos(), this.blockedSides))) {
            this.connectionMask = newConnectionMask;
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    private void recheckBlockedSides() {
        this.blockedSides = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.getCoverAtSide(side);
            if (coverBehavior == null || coverBehavior.canPipePassThrough()) continue;
            this.blockedSides |= 1 << side.func_176745_a();
        }
    }

    @Override
    protected void onCoverPlacementUpdate() {
        super.onCoverPlacementUpdate();
        this.needsCoversUpdate = true;
    }

    @Override
    public void onAttached() {
        super.onAttached();
        this.recomputeTankSize();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.isRemoved = true;
        this.setTankController(null);
        this.recomputeNearbyMultiblocks();
    }

    private Set<BlockPos> recomputeNearbyMultiblocks() {
        HashSet<BlockPos> handledSet = new HashSet<BlockPos>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            MetaTileEntityTank tank = this.getTankTile(this.getPos().func_177972_a(side));
            if (tank == null) continue;
            handledSet.addAll(tank.rescanTankMultiblocks(handledSet));
        }
        return handledSet;
    }

    private double getFluidLevelForTank(BlockPos tankPos) {
        if (!this.isTankController()) {
            MetaTileEntityTank controller = this.getControllerEntity();
            return controller == null ? 0.0 : controller.getFluidLevelForTank(tankPos);
        }
        int tankLayer = tankPos.func_177956_o() - this.lowestPos.func_177956_o();
        if (tankLayer >= 0 && tankLayer < this.sumCapacityByLevel.size()) {
            int prevLayerTotalCapacity = tankLayer > 0 ? this.sumCapacityByLevel.get(tankLayer - 1) : 0;
            int thisLevelCapacity = this.sumCapacityByLevel.get(tankLayer) - prevLayerTotalCapacity;
            double levelFill = (double)(this.multiblockFluidTank.getFluidAmount() - prevLayerTotalCapacity) / ((double)thisLevelCapacity * 1.0);
            return MathHelper.func_151237_a((double)levelFill, (double)0.0, (double)1.0);
        }
        return 0.0;
    }

    private int getConnectionMaskForTank(BlockPos blockPos, int excludeMask) {
        if (!this.isTankController()) {
            MetaTileEntityTank controller = this.getControllerEntity();
            return controller == null ? 0 : controller.getConnectionMaskForTank(blockPos, excludeMask);
        }
        int resultConnectionMask = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos;
            if ((excludeMask & 1 << side.func_176745_a()) > 0 || !this.connectedTanks.contains(offsetPos = blockPos.func_177972_a(side)) && !this.getPos().equals((Object)offsetPos)) continue;
            resultConnectionMask |= 1 << side.func_176745_a();
        }
        return resultConnectionMask;
    }

    private int getFluidStoredInTank(BlockPos blockPos) {
        double fluidLevel = this.getFluidLevelForTank(blockPos);
        return MathHelper.func_76128_c((double)(fluidLevel * (double)this.tankSize));
    }

    private MetaTileEntityTank getTankTile(BlockPos blockPos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)this.getWorld(), blockPos);
        if (!(metaTileEntity instanceof MetaTileEntityTank)) {
            return null;
        }
        MetaTileEntityTank metaTileEntityTank = (MetaTileEntityTank)metaTileEntity;
        if (metaTileEntityTank.isRemoved || metaTileEntityTank.material != this.material || metaTileEntityTank.tankSize != this.tankSize || !MetaTileEntityTank.isTankFluidEqual(metaTileEntityTank, this)) {
            return null;
        }
        return metaTileEntityTank;
    }

    private boolean isTankController() {
        return this.controllerPos == null;
    }

    private FluidTank getActualFluidTank() {
        if (this.controllerPos != null) {
            MetaTileEntityTank metaTileEntityTank = this.getControllerEntity();
            return metaTileEntityTank == null ? new FluidTank(0) : metaTileEntityTank.getActualFluidTank();
        }
        return this.multiblockFluidTank;
    }

    private FluidStack getActualTankFluid() {
        FluidTank fluidTank = this.getActualFluidTank();
        return fluidTank == null ? null : fluidTank.getFluid();
    }

    private void removeTankFromMultiblock(MetaTileEntityTank removedTank) {
        int fluidInTank = this.getFluidStoredInTank(removedTank.getPos());
        this.connectedTanks.remove(removedTank.getPos());
        this.needsShapeResync = true;
        removedTank.setTankControllerInternal(null);
        FluidStack fluidStack = this.multiblockFluidTank.getFluid();
        if (fluidStack != null && fluidInTank >= 1000) {
            FluidStack fillStack = GTUtility.copyAmount(fluidInTank, fluidStack);
            removedTank.multiblockFluidTank.fill(fillStack, true);
            this.multiblockFluidTank.drain(fillStack, true);
        }
        this.recomputeTankSize();
    }

    private void addTankToMultiblock(MetaTileEntityTank addedTank) {
        this.connectedTanks.add(addedTank.getPos());
        this.needsShapeResync = true;
        FluidStack tankFluid = addedTank.setTankControllerInternal(this);
        this.recomputeTankSize();
        if (tankFluid != null) {
            this.multiblockFluidTank.fill(tankFluid, true);
        }
    }

    private int computeTanksInLayer(List<BlockPos> connectedTanks, int layerPos) {
        return (int)connectedTanks.stream().filter(tank -> tank.func_177956_o() == layerPos).count();
    }

    private void recomputeTankSize() {
        ArrayList<BlockPos> connectedTanks = new ArrayList<BlockPos>(this.connectedTanks);
        connectedTanks.add(this.getPos());
        this.lowestPos = connectedTanks.stream().min(Comparator.comparing(Vec3i::func_177956_o)).get();
        this.highestPos = connectedTanks.stream().max(Comparator.comparing(Vec3i::func_177956_o)).get();
        this.tankCountByLevel.clear();
        for (int i = this.lowestPos.func_177956_o(); i <= this.highestPos.func_177956_o(); ++i) {
            this.tankCountByLevel.add(this.computeTanksInLayer(connectedTanks, i));
        }
        this.recomputeByLevelSumCapacity();
        this.multiblockFluidTank.setCapacity(connectedTanks.size() * this.tankSize);
        if (this.multiblockFluidTank.getFluid() != null && this.multiblockFluidTank.getFluidAmount() > this.multiblockFluidTank.getCapacity()) {
            this.multiblockFluidTank.getFluid().amount = this.multiblockFluidTank.getCapacity();
        }
    }

    private void recomputeByLevelSumCapacity() {
        int capacity = 0;
        this.sumCapacityByLevel.clear();
        for (int i = 0; i < this.tankCountByLevel.size(); ++i) {
            int layerCapacity = this.tankCountByLevel.get(i) * this.tankSize;
            this.sumCapacityByLevel.add(capacity + layerCapacity);
            capacity += layerCapacity;
        }
    }

    private MetaTileEntityTank getControllerEntity() {
        MetaTileEntity metaTileEntity;
        if (this.controllerPos == null) {
            return null;
        }
        MetaTileEntityTank cachedController = (MetaTileEntityTank)this.controllerCache.get();
        if (cachedController != null) {
            if (cachedController.isValid()) {
                return cachedController;
            }
            this.controllerCache.clear();
        }
        if ((metaTileEntity = BlockMachine.getMetaTileEntity((IBlockAccess)this.getWorld(), this.controllerPos)) instanceof MetaTileEntityTank) {
            this.controllerCache = new WeakReference<MetaTileEntityTank>((MetaTileEntityTank)metaTileEntity);
            return (MetaTileEntityTank)metaTileEntity;
        }
        return null;
    }

    private FluidStack setTankControllerInternal(MetaTileEntityTank controller) {
        this.controllerPos = controller == null ? null : controller.getPos();
        this.controllerCache = new WeakReference<MetaTileEntityTank>(controller);
        this.getHolder().markAsDirty();
        if (controller == null) {
            this.networkStatus = NetworkStatus.DETACHED_FROM_MULTIBLOCK;
            return null;
        }
        this.networkStatus = NetworkStatus.ATTACHED_TO_MULTIBLOCK;
        FluidStack fluidStack = this.multiblockFluidTank.drain(Integer.MAX_VALUE, true);
        this.multiblockFluidTank.setFluid(null);
        this.lastSentFluidStack = null;
        this.needsFluidResync = false;
        return fluidStack;
    }

    private void onFluidChangedInternal() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K && this.isTankController()) {
            this.needsFluidResync = true;
        }
    }

    @Override
    public void addDebugInfo(List<String> debugInfo) {
        debugInfo.add("IsController: " + this.isTankController());
        debugInfo.add("ControllerPos: " + this.controllerPos);
        List<Object> connectedTanks = new ArrayList<BlockPos>(this.connectedTanks);
        while (!connectedTanks.isEmpty()) {
            int startIndex = Math.min(4, connectedTanks.size());
            debugInfo.add("ConnectedBlocks: " + connectedTanks.subList(0, startIndex));
            if (connectedTanks.size() <= startIndex) break;
            connectedTanks = connectedTanks.subList(startIndex, connectedTanks.size());
        }
        debugInfo.add("HighestPos: " + this.highestPos);
        debugInfo.add("LowestPos: " + this.lowestPos);
        debugInfo.add("Tank fluid: " + this.multiblockFluidTank.getFluidAmount() + "/" + this.multiblockFluidTank.getCapacity() + " #" + this.multiblockFluidTank.hashCode());
        FluidTank actualTankFluid = this.getActualFluidTank();
        debugInfo.add("Actual Tank fluid: " + actualTankFluid.getFluidAmount() + "/" + actualTankFluid.getCapacity() + " #" + actualTankFluid.hashCode());
        debugInfo.add("FluidLevel: " + this.getFluidLevelForTank(this.getPos()));
        debugInfo.add("FluidInTank: " + this.getFluidStoredInTank(this.getPos()));
        debugInfo.add("TankCountByLevel: " + this.tankCountByLevel);
        debugInfo.add("CapacityByLevel: " + this.sumCapacityByLevel);
    }

    private void setTankController(MetaTileEntityTank controller) {
        MetaTileEntityTank oldController = this.getControllerEntity();
        if (oldController == controller) {
            return;
        }
        if (oldController != null) {
            oldController.removeTankFromMultiblock(this);
        }
        if (controller != null) {
            controller.addTankToMultiblock(this);
        } else {
            this.setTankControllerInternal(null);
        }
        for (BlockPos tankPos : ImmutableList.copyOf(this.connectedTanks)) {
            MetaTileEntityTank metaTileEntityTank = this.getTankTile(tankPos);
            if (metaTileEntityTank == null) continue;
            this.removeTankFromMultiblock(metaTileEntityTank);
        }
        this.connectedTanks.clear();
    }

    private void buildTankStructure(Set<BlockPos> structureBlocks, Map<BlockPos, MetaTileEntityTank> allTanks) {
        List<MetaTileEntityTank> connectedTanks = structureBlocks.stream().sorted(MetaTileEntityTank.buildRootComparator()).map(allTanks::get).collect(Collectors.toList());
        MetaTileEntityTank firstController = connectedTanks.stream().filter(MetaTileEntityTank::isTankController).findFirst().orElse(null);
        if (firstController == null) {
            firstController = (MetaTileEntityTank)connectedTanks.get(connectedTanks.size() - 1);
            firstController.setTankController(null);
        }
        connectedTanks.remove(firstController);
        MetaTileEntityTank finalFirstController = firstController;
        connectedTanks.forEach(it -> it.setTankController(finalFirstController));
    }

    private static boolean isTankFluidEqual(MetaTileEntityTank tank1, MetaTileEntityTank tank2) {
        FluidStack fluidStack1 = tank1.getActualTankFluid();
        FluidStack fluidStack2 = tank2.getActualTankFluid();
        return fluidStack1 == null || fluidStack2 == null || fluidStack1.isFluidEqual(fluidStack2);
    }

    private static boolean canTanksConnect(MetaTileEntityTank tank1, MetaTileEntityTank tank2, EnumFacing side) {
        return side == null || (tank1.blockedSides & 1 << side.func_176745_a()) <= 0 && (tank2.blockedSides & 1 << side.func_176734_d().func_176745_a()) <= 0;
    }

    private static Comparator<BlockPos> buildRootComparator() {
        return Comparator.comparing(Vec3i::func_177956_o).thenComparing(Vec3i::func_177958_n).thenComparing(Vec3i::func_177952_p).reversed();
    }

    private Set<BlockPos> rescanTankMultiblocks(Set<BlockPos> excludedBlocks) {
        Map<BlockPos, MetaTileEntityTank> allTanks = this.findConnectedTankBlocks(this.getPos());
        allTanks.keySet().removeAll(excludedBlocks);
        TreeSet<BlockPos> sortedTanks = new TreeSet<BlockPos>(MetaTileEntityTank.buildRootComparator());
        sortedTanks.addAll(allTanks.keySet());
        while (!sortedTanks.isEmpty()) {
            BlockPos rootTankPos = sortedTanks.pollLast();
            sortedTanks.remove(rootTankPos);
            Set<BlockPos> structureBlocks = this.findStructureBlocksFromBottom(rootTankPos, allTanks);
            sortedTanks.removeAll(structureBlocks);
            this.buildTankStructure(structureBlocks, allTanks);
        }
        return allTanks.keySet();
    }

    private Set<BlockPos> findStructureBlocksFromBottom(BlockPos bottomStartPos, Map<BlockPos, MetaTileEntityTank> allTanks) {
        return MetaTileEntityTank.findAllConnectedBlocks(bottomStartPos, (EnumFacing[])ArrayUtils.add((Object[])EnumFacing.field_176754_o, (Object)EnumFacing.UP), allTanks::get, this.maxMultiblockSize).keySet();
    }

    private Map<BlockPos, MetaTileEntityTank> findConnectedTankBlocks(BlockPos startPos) {
        return MetaTileEntityTank.findAllConnectedBlocks(startPos, EnumFacing.field_82609_l, this::getTankTile, Integer.MAX_VALUE);
    }

    private static Map<BlockPos, MetaTileEntityTank> findAllConnectedBlocks(BlockPos startPos, EnumFacing[] directions, Function<BlockPos, MetaTileEntityTank> blockProvider, int maxAmount) {
        HashMap<BlockPos, MetaTileEntityTank> observedSet = new HashMap<BlockPos, MetaTileEntityTank>();
        observedSet.put(startPos, blockProvider.apply(startPos));
        MetaTileEntityTank firstNode = (MetaTileEntityTank)observedSet.get(startPos);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(startPos);
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        int currentAmount = 0;
        block0: while (currentAmount < maxAmount) {
            for (EnumFacing facing : directions) {
                MetaTileEntityTank metaTileEntity;
                currentPos.func_189536_c(facing);
                if (!observedSet.containsKey(currentPos) && (metaTileEntity = blockProvider.apply((BlockPos)currentPos)) != null && MetaTileEntityTank.canTanksConnect(firstNode, metaTileEntity, facing)) {
                    observedSet.put(metaTileEntity.getPos(), metaTileEntity);
                    firstNode = metaTileEntity;
                    moveStack.push(facing.func_176734_d());
                    ++currentAmount;
                    continue block0;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
            firstNode = observedSet.get(currentPos);
        }
        return observedSet;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityTank(this.metaTileEntityId, this.material, this.tankSize, this.maxMultiblockSize);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public String getHarvestTool() {
        return ModHandler.isMaterialWood(this.material) ? "axe" : "pickaxe";
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid"));
            this.multiblockFluidTank.fill(fluidStack, true);
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        FluidStack fluidStack = this.multiblockFluidTank.drain(Integer.MAX_VALUE, false);
        if (fluidStack != null && fluidStack.amount > 0) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            itemStack.func_74782_a("Fluid", (NBTBase)tagCompound);
        }
    }

    @Override
    public String getItemSubTypeId(ItemStack itemStack) {
        return DefaultSubItemHandler.getFluidContainerSubType(itemStack);
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        super.getSubItems(creativeTab, subItems);
        if (creativeTab == CreativeTabs.field_78027_g) {
            DefaultSubItemHandler.addFluidContainerVariants(this.getStackForm(), subItems);
        }
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return new FluidHandlerItemStack(itemStack, this.tankSize){

            public boolean canFillFluidType(FluidStack fluid) {
                return MetaTileEntityTank.this.canFillFluidType(fluid);
            }
        };
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.isTankController()) {
            buf.writeBoolean(true);
            ByteBufUtils.writeRelativeBlockList(buf, this.getPos(), this.connectedTanks);
            this.recomputeTankSize();
            FluidStack fluidStack = this.multiblockFluidTank.getFluid();
            ByteBufUtils.writeFluidStack(buf, fluidStack);
        } else {
            buf.writeBoolean(false);
            buf.func_179255_a(this.controllerPos);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            this.connectedTanks = ByteBufUtils.readRelativeBlockList(buf, this.getPos());
            this.recomputeTankSize();
            FluidStack fluidStack = ByteBufUtils.readFluidStack(buf);
            this.multiblockFluidTank.setFluid(fluidStack);
            this.recomputeByLevelSumCapacity();
        } else {
            this.controllerPos = buf.func_179259_c();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 1) {
            this.controllerPos = buf.func_179259_c();
            this.controllerCache = new WeakReference<Object>(null);
            this.multiblockFluidTank.setFluid(null);
        } else if (dataId == 2) {
            this.controllerPos = null;
            this.controllerCache = new WeakReference<Object>(null);
            this.multiblockFluidTank.setFluid(null);
            this.highestPos = this.getPos();
            this.lowestPos = this.getPos();
            this.tankCountByLevel.clear();
            this.sumCapacityByLevel.clear();
            this.connectedTanks.clear();
        } else if (dataId == 3) {
            if (this.controllerPos == null) {
                FluidStack fluidStack = ByteBufUtils.readFluidStackDelta(buf, this.multiblockFluidTank.getFluid());
                this.multiblockFluidTank.setFluid(fluidStack);
            }
        } else if (dataId == 4) {
            this.connectedTanks = ByteBufUtils.readRelativeBlockList(buf, this.getPos());
            this.recomputeTankSize();
        }
    }

    private IFluidTankProperties getTankProperties() {
        IFluidTankProperties[] properties = this.fluidInventory.getTankProperties();
        return properties.length == 0 ? null : properties[0];
    }

    @Override
    public int getActualComparatorValue() {
        IFluidTankProperties properties = this.getTankProperties();
        if (properties == null) {
            return 0;
        }
        FluidStack fluidStack = properties.getContents();
        int fluidAmount = fluidStack == null ? 0 : fluidStack.amount;
        int maxCapacity = properties.getCapacity();
        float f = (float)fluidAmount / ((float)maxCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (fluidAmount > 0 ? 1 : 0);
    }

    @Override
    public int getActualLightValue() {
        IFluidTankProperties properties = this.getTankProperties();
        if (properties == null) {
            return 0;
        }
        FluidStack fluidStack = properties.getContents();
        if (fluidStack == null) {
            return 0;
        }
        return fluidStack.getFluid().getLuminosity(fluidStack);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.getWorld().field_72995_K || FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)this.fluidInventory);
    }

    @SideOnly(value=Side.CLIENT)
    private TankRenderer getTankRenderer() {
        if (ModHandler.isMaterialWood(this.material)) {
            return Textures.WOODEN_TANK;
        }
        return Textures.METAL_TANK;
    }

    @SideOnly(value=Side.CLIENT)
    private int getActualPaintingColor() {
        int paintingColor = this.getPaintingColorForRendering();
        if (paintingColor == 0xFFFFFF) {
            return this.material.materialRGB;
        }
        return paintingColor;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getTankRenderer().getParticleTexture(), (Object)this.getActualPaintingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        int baseColor = GTUtility.convertRGBtoOpaqueRGBA_CL(this.getActualPaintingColor());
        this.getTankRenderer().render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(baseColor)), this.connectionMask);
    }

    @Override
    public void renderMetaTileEntityFast(CCRenderState renderState, Matrix4 translation, float partialTicks) {
        FluidStack fluidStack = this.getFluidForRendering();
        double fillPercent = this.getWorld() == null ? (fluidStack == null ? 0.0 : (double)fluidStack.amount / ((double)this.tankSize * 1.0)) : this.getFluidLevelForTank(this.getPos());
        if (fillPercent > 0.0) {
            this.getTankRenderer().renderFluid(renderState, translation, this.connectionMask, fillPercent, fluidStack);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos());
    }

    @SideOnly(value=Side.CLIENT)
    private FluidStack getFluidForRendering() {
        if (this.getWorld() == null && this.renderContextStack != null) {
            NBTTagCompound tagCompound = this.renderContextStack.func_77978_p();
            if (tagCompound != null && tagCompound.func_150297_b("Fluid", 10)) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            }
            return null;
        }
        return this.getActualTankFluid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.tankSize}));
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            if (fluidStack == null) {
                return;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_tank.fluid", (Object[])new Object[]{fluidStack.amount, I18n.func_135052_a((String)fluidStack.getUnlocalizedName(), (Object[])new Object[0])}));
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.controllerPos != null) {
            data.func_74782_a("ControllerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.controllerPos));
        } else {
            data.func_74782_a("FluidInventory", (NBTBase)this.multiblockFluidTank.writeToNBT(new NBTTagCompound()));
            NBTTagList connectedTanks = new NBTTagList();
            this.connectedTanks.forEach(pos -> connectedTanks.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos)));
            data.func_74782_a("ConnectedTanks", (NBTBase)connectedTanks);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("ControllerPos")) {
            this.controllerPos = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l("ControllerPos"));
        } else {
            NBTTagList connectedTanks = data.func_150295_c("ConnectedTanks", 10);
            connectedTanks.forEach(pos -> this.connectedTanks.add(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)pos))));
            this.recomputeTankSize();
            this.multiblockFluidTank.readFromNBT(data.func_74775_l("FluidInventory"));
            this.lastSentFluidStack = this.multiblockFluidTank.getFluid();
        }
    }

    protected boolean canFillFluidType(FluidStack fluid) {
        return !ModHandler.isMaterialWood(this.material) && !this.material.hasFlag(Material.MatFlags.FLAMMABLE) || fluid.getFluid().getTemperature(fluid) <= 325;
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    private static enum NetworkStatus {
        DETACHED_FROM_MULTIBLOCK,
        ATTACHED_TO_MULTIBLOCK;

    }
}

