/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ScrollableListWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TabGroup;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.gui.widgets.tab.ItemTabInfo;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class MetaTileEntityWorkbench
extends MetaTileEntity {
    public MetaTileEntityWorkbench(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityWorkbench(this.metaTileEntityId);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        TextureAtlasSprite craftingTable = TextureUtils.getBlockTexture((String)"crafting_table_top");
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColor())));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, pipeline, side, Cuboid6.full, craftingTable);
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int j;
        int i;
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BORDERED_BACKGROUND_EXTENDED, 176, 198).bindPlayerInventory(entityPlayer.field_71071_by, 117);
        ItemStackHandler craftingGridHandler = new ItemStackHandler(9);
        ItemStackHandler resultSlotInventory = new ItemStackHandler(1);
        ItemStackHandler internalInventory = new ItemStackHandler(18);
        builder.label(5, 5, this.getMetaFullName());
        WidgetGroup containerGroup = new WidgetGroup();
        ScrollableListWidget scrollableListWidget = new ScrollableListWidget(11, 15, 154, 90);
        containerGroup.addWidget(scrollableListWidget);
        for (int j2 = 0; j2 < 20; ++j2) {
            WidgetGroup slotGroup = new WidgetGroup(new Position(0, 0), new Size(144, 18));
            for (i = 0; i < 8; ++i) {
                slotGroup.addWidget(new SlotWidget((IItemHandlerModifiable)internalInventory, (j2 + i) % 18, i * 18, 0).setBackgroundTexture(GuiTextures.SLOT));
            }
            scrollableListWidget.addWidget(slotGroup);
        }
        TabGroup tabGroup = new TabGroup(TabGroup.TabLocation.HORIZONTAL_TOP_LEFT);
        WidgetGroup craftingGroup = new WidgetGroup();
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.crafting", new ItemStack(Blocks.field_150462_ai)), craftingGroup);
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.container", new ItemStack((Block)Blocks.field_150486_ae)), containerGroup);
        craftingGroup.addWidget(new ImageWidget(119, 30, 26, 26, GuiTextures.SLOT_BIG));
        craftingGroup.addWidget(new SlotWidget((IItemHandlerModifiable)resultSlotInventory, 0, 124, 35));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                craftingGroup.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)craftingGridHandler, j + i * 3, 30 + j * 18, 17 + i * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                craftingGroup.addWidget(new SlotWidget((IItemHandlerModifiable)internalInventory, j + i * 9, 8 + j * 18, 76 + i * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        return builder.widget(tabGroup).build(this.getHolder(), entityPlayer);
    }
}

