/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable;

import com.google.common.base.Preconditions;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTUtility;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.net.EnergyNet;
import gregtech.common.pipelike.cable.net.WorldENet;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import gregtech.common.pipelike.cable.tile.TileEntityCableTickable;
import gregtech.common.render.CableRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockCable
extends BlockMaterialPipe<Insulation, WireProperties, WorldENet>
implements ITileEntityProvider {
    private final Map<Material, WireProperties> enabledMaterials = new TreeMap<Material, WireProperties>();

    public BlockCable() {
        this.setHarvestLevel("cutter", 1);
    }

    public void addCableMaterial(Material material, WireProperties wireProperties) {
        Preconditions.checkNotNull((Object)material, (Object)"material");
        Preconditions.checkNotNull((Object)wireProperties, (Object)"wireProperties");
        Preconditions.checkArgument((Material.MATERIAL_REGISTRY.getNameForObject(material) != null ? 1 : 0) != 0, (Object)"material is not registered");
        this.enabledMaterials.put(material, wireProperties);
    }

    public Collection<Material> getEnabledMaterials() {
        return Collections.unmodifiableSet(this.enabledMaterials.keySet());
    }

    @Override
    public Class<Insulation> getPipeTypeClass() {
        return Insulation.class;
    }

    @Override
    protected WireProperties createProperties(Insulation insulation, Material material) {
        return insulation.modifyProperties(this.enabledMaterials.getOrDefault(material, this.getFallbackType()));
    }

    @Override
    protected WireProperties getFallbackType() {
        return this.enabledMaterials.values().iterator().next();
    }

    @Override
    public WorldENet getWorldPipeNet(World world) {
        return WorldENet.getWorldENet(world);
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Material material : this.enabledMaterials.keySet()) {
            for (Insulation insulation : Insulation.values()) {
                items.add((Object)this.getItem(insulation, material));
            }
        }
    }

    @Override
    public int getActiveNodeConnections(IBlockAccess world, BlockPos nodePos, IPipeTile<Insulation, WireProperties> selfTileEntity) {
        int activeNodeConnections = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            EnumFacing opposite;
            IEnergyContainer energyContainer;
            BlockPos offsetPos = nodePos.func_177972_a(side);
            TileEntity tileEntity = world.func_175625_s(offsetPos);
            if (tileEntity == null || this.getPipeTileEntity(tileEntity) != null || (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, opposite = side.func_176734_d())) == null) continue;
            activeNodeConnections |= 1 << side.func_176745_a();
        }
        return activeNodeConnections;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        Insulation insulation = (Insulation)this.getPipeTileEntity((IBlockAccess)worldIn, pos).getPipeType();
        if (!worldIn.field_72995_K && insulation.insulationLevel == -1 && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            EnergyNet energyNet = (EnergyNet)this.getWorldPipeNet(worldIn).getNetFromPos(pos);
            if (energyNet != null) {
                long voltage = energyNet.getLastMaxVoltage();
                long amperage = energyNet.getLastAmperage();
                if (voltage > 0L && amperage > 0L) {
                    float damageAmount = (long)(GTUtility.getTierByVoltage(voltage) + 1) * amperage * 4L;
                    entityLiving.func_70097_a(DamageSources.getElectricDamage(), damageAmount);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return CableRenderer.BLOCK_RENDER_TYPE;
    }

    @Override
    public TileEntityPipeBase<Insulation, WireProperties> createNewTileEntity(boolean supportsTicking) {
        return supportsTicking ? new TileEntityCableTickable() : new TileEntityCable();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return CableRenderer.INSTANCE.getParticleTexture((TileEntityCable)world.func_175625_s(blockPos));
    }
}

