/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.net;

import com.google.common.base.Preconditions;
import gregtech.api.util.PerTickIntCounter;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.net.FluidPipeNet;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidNetTank
extends FluidTank {
    private final FluidPipeNet handle;
    private final PerTickIntCounter drainedThisTick = new PerTickIntCounter(0);

    public FluidNetTank(FluidPipeNet handle) {
        super(0);
        this.handle = handle;
    }

    private int getMaxThroughput() {
        return this.handle.getMaxThroughput();
    }

    public int fill(FluidStack resource, boolean doFill) {
        boolean isBurningPipe;
        Preconditions.checkNotNull((Object)resource, (Object)"resource");
        FluidStack copyStack = resource.copy();
        copyStack.amount = Math.min(copyStack.amount, this.getMaxThroughput());
        FluidPipeProperties properties = (FluidPipeProperties)this.handle.getNodeData();
        boolean isLeakingPipe = copyStack.getFluid().isGaseous(copyStack) && !properties.gasProof;
        boolean bl = isBurningPipe = copyStack.getFluid().getTemperature(copyStack) > properties.maxFluidTemperature;
        if (isLeakingPipe || isBurningPipe) {
            this.handle.destroyNetwork(isLeakingPipe, isBurningPipe);
            return copyStack.amount;
        }
        return super.fill(copyStack, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        int maxDrainLeftThisTick = this.getMaxThroughput() - this.drainedThisTick.get(this.handle.getWorldData());
        int originalAmount = resource.amount;
        resource.amount = Math.min(originalAmount, maxDrainLeftThisTick);
        FluidStack resultDrained = super.drain(resource, doDrain);
        resource.amount = originalAmount;
        if (resultDrained != null && doDrain) {
            this.drainedThisTick.increment(this.handle.getWorldData(), resultDrained.amount);
        }
        return resultDrained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int maxDrainLeftThisTick = this.getMaxThroughput() - this.drainedThisTick.get(this.handle.getWorldData());
        if ((maxDrain = Math.min(maxDrain, maxDrainLeftThisTick)) == 0) {
            return null;
        }
        FluidStack resultDrained = super.drain(maxDrain, doDrain);
        if (resultDrained != null && doDrain) {
            this.drainedThisTick.increment(this.handle.getWorldData(), resultDrained.amount);
        }
        return resultDrained;
    }

    public void updateTankCapacity(int newTankCapacity) {
        this.capacity = newTankCapacity;
        if (this.fluid != null) {
            this.fluid.amount = Math.min(this.fluid.amount, newTankCapacity);
        }
    }
}

