/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.net;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gregtech.api.GTValues;
import gregtech.api.pipenet.MonolithicPipeNet;
import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.net.FluidNetTank;
import gregtech.common.pipelike.fluidpipe.net.WorldFluidPipeNet;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;

public class FluidPipeNet
extends MonolithicPipeNet<FluidPipeProperties> {
    private final FluidNetTank fluidNetTank = new FluidNetTank(this);

    public FluidPipeNet(WorldPipeNet<FluidPipeProperties, FluidPipeNet> world) {
        super(world);
    }

    public FluidTank getFluidNetTank() {
        return this.fluidNetTank;
    }

    public int getMaxThroughput() {
        if (this.fluidNetTank.getCapacity() == 0) {
            return 0;
        }
        return ((FluidPipeProperties)this.nodeData).throughput;
    }

    public void destroyNetwork(boolean isLeaking, boolean isBurning) {
        World world = this.worldData.getWorld();
        ((WorldFluidPipeNet)this.worldData).removePipeNet(this);
        for (BlockPos nodePos : this.getAllNodes().keySet()) {
            TileEntity tileEntity = world.func_175625_s(nodePos);
            if (tileEntity instanceof TileEntityFluidPipe) {
                if (isBurning) {
                    world.func_175656_a(nodePos, Blocks.field_150480_ab.func_176223_P());
                } else {
                    world.func_175698_g(nodePos);
                }
            } else if (GTValues.isModLoaded("forgemultipartcbe")) {
                FluidPipeNet.removeMultipartPipePartFromTile(tileEntity);
            }
            Random random = world.field_73012_v;
            if (isBurning) {
                TileEntityFluidPipe.spawnParticles(world, nodePos, EnumFacing.UP, EnumParticleTypes.FLAME, 3 + random.nextInt(2), random);
                if (random.nextInt(4) == 0) {
                    TileEntityFluidPipe.setNeighboursToFire(world, nodePos);
                }
            }
            if (!isLeaking || world.field_73012_v.nextInt(isBurning ? 3 : 7) != 0) continue;
            world.func_72876_a(null, (double)nodePos.func_177958_n() + 0.5, (double)nodePos.func_177956_o() + 0.5, (double)nodePos.func_177952_p() + 0.5, 1.0f + world.field_73012_v.nextFloat(), false);
        }
    }

    @Optional.Method(modid="forgemultipartcbe")
    private static void removeMultipartPipePartFromTile(TileEntity tileEntity) {
        if (tileEntity instanceof TileMultipart) {
            TileMultipart tileMultipart = (TileMultipart)tileEntity;
            List partList = tileMultipart.jPartList();
            for (TMultiPart tMultiPart : partList) {
                if (!(tMultiPart instanceof IPipeTile)) continue;
                tileMultipart.remPart(tMultiPart);
            }
        }
    }

    @Override
    protected void onConnectionsUpdate() {
        super.onConnectionsUpdate();
        int newTankCapacity = ((FluidPipeProperties)this.nodeData).throughput * this.getAllNodes().size();
        this.fluidNetTank.updateTankCapacity(newTankCapacity);
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<FluidPipeProperties>> transferredNodes, PipeNet<FluidPipeProperties> parentNet1) {
        super.transferNodeData(transferredNodes, parentNet1);
        FluidPipeNet parentNet = (FluidPipeNet)parentNet1;
        FluidStack parentFluid = parentNet.getFluidNetTank().getFluid();
        if (parentFluid != null && parentFluid.amount > 0) {
            if (parentNet.getAllNodes().isEmpty()) {
                this.getFluidNetTank().fillInternal(parentFluid, true);
            } else {
                int firstNetCapacity = this.getAllNodes().size() * ((FluidPipeProperties)this.getNodeData()).throughput;
                int secondNetCapacity = parentNet.getAllNodes().size() * ((FluidPipeProperties)parentNet.getNodeData()).throughput;
                int totalFluidAmount = this.getFluidNetTank().getFluidAmount() + parentFluid.amount;
                int fluidAmount1 = totalFluidAmount * firstNetCapacity / (firstNetCapacity + secondNetCapacity);
                int fluidAmount2 = totalFluidAmount - fluidAmount1;
                if (fluidAmount1 > 0) {
                    FluidStack fluidStack1 = parentFluid.copy();
                    fluidStack1.amount = fluidAmount1;
                    this.fluidNetTank.setFluid(fluidStack1);
                } else {
                    this.fluidNetTank.setFluid(null);
                }
                if (fluidAmount2 > 0) {
                    FluidStack fluidStack2 = parentFluid.copy();
                    fluidStack2.amount = fluidAmount2;
                    parentNet.getFluidNetTank().setFluid(fluidStack2);
                } else {
                    parentNet.getFluidNetTank().setFluid(null);
                }
            }
        }
    }

    @Override
    protected boolean areNodesCustomContactable(FluidPipeProperties first, FluidPipeProperties second, PipeNet<FluidPipeProperties> secondNodeNet) {
        FluidPipeNet fluidPipeNet = (FluidPipeNet)secondNodeNet;
        return super.areNodesCustomContactable(first, second, secondNodeNet) && (secondNodeNet == null || this.getFluidNetTank().getFluid() == null || fluidPipeNet.getFluidNetTank().getFluid() == null || this.getFluidNetTank().getFluid().isFluidEqual(fluidPipeNet.getFluidNetTank().getFluid()));
    }

    @Override
    protected void writeNodeData(FluidPipeProperties nodeData, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("max_temperature", nodeData.maxFluidTemperature);
        tagCompound.func_74768_a("throughput", nodeData.throughput);
        tagCompound.func_74757_a("gas_proof", nodeData.gasProof);
    }

    @Override
    protected FluidPipeProperties readNodeData(NBTTagCompound tagCompound) {
        int maxTemperature = tagCompound.func_74762_e("max_temperature");
        int throughput = tagCompound.func_74762_e("throughput");
        boolean gasProof = tagCompound.func_74767_n("gas_proof");
        return new FluidPipeProperties(maxTemperature, throughput, gasProof);
    }
}

