/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.inventory;

import gregtech.api.pipenet.block.simple.BlockSimplePipe;
import gregtech.api.pipenet.block.simple.EmptyNodeData;
import gregtech.api.pipenet.tickable.TickableWorldPipeNetEventHandler;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.common.pipelike.inventory.InventoryPipeType;
import gregtech.common.pipelike.inventory.net.InventoryPipeNet;
import gregtech.common.pipelike.inventory.net.WorldInventoryPipeNet;
import gregtech.common.pipelike.inventory.tile.TileEntityInventoryPipe;
import gregtech.common.pipelike.inventory.tile.TileEntityInventoryPipeTickable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockInventoryPipe
extends BlockSimplePipe<InventoryPipeType, EmptyNodeData, WorldInventoryPipeNet> {
    @Override
    public TileEntityPipeBase<InventoryPipeType, EmptyNodeData> createNewTileEntity(boolean supportsTicking) {
        return supportsTicking ? new TileEntityInventoryPipeTickable() : new TileEntityInventoryPipe();
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        InventoryPipeNet inventoryPipeNet;
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K && (inventoryPipeNet = (InventoryPipeNet)this.getWorldPipeNet(worldIn).getNetFromPos(pos)) != null) {
            inventoryPipeNet.nodeNeighbourChanged(pos);
        }
    }

    @Override
    public int getActiveNodeConnections(IBlockAccess world, BlockPos nodePos, IPipeTile<InventoryPipeType, EmptyNodeData> selfTileEntity) {
        int activeNodeConnections = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos = nodePos.func_177972_a(side);
            TileEntity tileEntity = world.func_175625_s(offsetPos);
            if (tileEntity == null || !tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) continue;
            activeNodeConnections |= 1 << side.func_176745_a();
        }
        return activeNodeConnections;
    }

    @Override
    protected EmptyNodeData createProperties(InventoryPipeType inventoryPipeType) {
        return EmptyNodeData.INSTANCE;
    }

    @Override
    public Class<InventoryPipeType> getPipeTypeClass() {
        return InventoryPipeType.class;
    }

    @Override
    protected EmptyNodeData getFallbackType() {
        return EmptyNodeData.INSTANCE;
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (InventoryPipeType pipeType : InventoryPipeType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, pipeType.ordinal()));
        }
    }

    @Override
    public WorldInventoryPipeNet getWorldPipeNet(World world) {
        return WorldInventoryPipeNet.getWorldPipeNet(world);
    }

    @Override
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return null;
    }

    static {
        TickableWorldPipeNetEventHandler.registerTickablePipeNet(WorldInventoryPipeNet::getWorldPipeNet);
    }
}

