/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.inventory.network;

import gregtech.api.util.ItemStackKey;
import gregtech.common.pipelike.inventory.network.ItemStorageNetwork;
import gregtech.common.pipelike.inventory.network.UpdateResult;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemHandlerInfo {
    private final BlockPos blockPos;
    private final EnumFacing accessSide;
    private final BlockPos accessedBlockPos;
    private WeakReference<TileEntity> cachedTileEntity = new WeakReference<Object>(null);
    private IItemHandler itemHandler = EmptyHandler.INSTANCE;
    private Map<ItemStackKey, Integer> itemStackByAmountMap = new HashMap<ItemStackKey, Integer>();
    private ItemStorageNetwork storageNetwork;

    public ItemHandlerInfo(BlockPos blockPos, EnumFacing accessSide) {
        this.blockPos = blockPos;
        this.accessSide = accessSide;
        this.accessedBlockPos = blockPos.func_177972_a(accessSide);
    }

    public void setStorageNetwork(ItemStorageNetwork storageNetwork) {
        this.storageNetwork = storageNetwork;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public EnumFacing getAccessSide() {
        return this.accessSide;
    }

    public BlockPos getAccessedBlockPos() {
        return this.accessedBlockPos;
    }

    private IItemHandler getItemHandler() {
        if (this.storageNetwork.getWorld().func_175667_e(this.accessedBlockPos)) {
            return EmptyHandler.INSTANCE;
        }
        TileEntity tileEntity = (TileEntity)this.cachedTileEntity.get();
        if (tileEntity == null || tileEntity.func_145837_r() || !tileEntity.func_174877_v().equals((Object)this.accessedBlockPos)) {
            tileEntity = this.storageNetwork.getWorld().func_175625_s(this.accessedBlockPos);
            if (tileEntity == null) {
                return null;
            }
            this.cachedTileEntity = new WeakReference<TileEntity>(tileEntity);
        }
        return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.accessSide.func_176734_d());
    }

    public UpdateResult updateCachedInfo() {
        IItemHandler newItemHandler = this.getItemHandler();
        if (newItemHandler == null) {
            return UpdateResult.INVALID;
        }
        if (!newItemHandler.equals(this.itemHandler)) {
            this.itemHandler = newItemHandler;
            this.recomputeItemStackCount();
            return UpdateResult.CHANGED;
        }
        if (this.recomputeItemStackCount()) {
            return UpdateResult.CHANGED;
        }
        return UpdateResult.STANDBY;
    }

    public int insertItem(ItemStackKey itemStackKey, int amount, boolean simulate) {
        int itemsInserted = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack insertStack = itemStackKey.getItemStack();
            insertStack.func_190920_e(amount);
            ItemStack remainderStack = this.itemHandler.insertItem(i, itemStackKey.getItemStack(), simulate);
            itemsInserted += insertStack.func_190916_E() - remainderStack.func_190916_E();
        }
        if (itemsInserted > 0 && !simulate) {
            this.recomputeItemStackCount();
        }
        return itemsInserted;
    }

    public int extractItem(ItemStackKey itemStackKey, int amount, boolean simulate) {
        int itemsExtracted = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack extractedStack;
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !itemStackKey.isItemStackEqual(stackInSlot) || (extractedStack = this.itemHandler.extractItem(i, amount, simulate)).func_190926_b()) continue;
            itemsExtracted += extractedStack.func_190916_E();
        }
        if (itemsExtracted > 0 && !simulate) {
            this.recomputeItemStackCount();
        }
        return itemsExtracted;
    }

    private boolean recomputeItemStackCount() {
        HashMap<ItemStackKey, Integer> amountMap = new HashMap<ItemStackKey, Integer>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            ItemStackKey stackKey = new ItemStackKey(itemStack);
            amountMap.put(stackKey, amountMap.getOrDefault(stackKey, 0) + itemStack.func_190916_E());
        }
        if (amountMap.equals(this.itemStackByAmountMap)) {
            return false;
        }
        HashSet<ItemStackKey> removedItems = new HashSet<ItemStackKey>(this.itemStackByAmountMap.keySet());
        removedItems.removeAll(amountMap.keySet());
        this.itemStackByAmountMap = amountMap;
        this.storageNetwork.updateStoredItems(this, amountMap, removedItems);
        return true;
    }
}

