/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.inventory.network;

import gregtech.api.util.ItemStackKey;
import gregtech.common.pipelike.inventory.network.ItemHandlerInfo;
import gregtech.common.pipelike.inventory.network.NetworkItemInfo;
import gregtech.common.pipelike.inventory.network.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemStorageNetwork {
    private final World world;
    private final List<ItemHandlerInfo> handlerInfoList = new ArrayList<ItemHandlerInfo>();
    private final Map<SidedBlockPos, ItemHandlerInfo> handlerInfoMap = new HashMap<SidedBlockPos, ItemHandlerInfo>();
    private final Map<ItemStackKey, NetworkItemInfo> itemInfoMap = new HashMap<ItemStackKey, NetworkItemInfo>();

    public ItemStorageNetwork(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public Collection<NetworkItemInfo> getStoredItems() {
        return Collections.unmodifiableCollection(this.itemInfoMap.values());
    }

    public void update() {
        this.handlerInfoList.removeIf(itemHandler -> itemHandler.updateCachedInfo() == UpdateResult.INVALID);
    }

    public void transferItemHandlers(Collection<BlockPos> nodePositions, ItemStorageNetwork destNetwork) {
        List<ItemHandlerInfo> movedHandlerInfo = this.handlerInfoList.stream().filter(handlerInfo -> nodePositions.contains(handlerInfo.getBlockPos())).collect(Collectors.toList());
        movedHandlerInfo.forEach(this::removeItemHandler);
        movedHandlerInfo.forEach(destNetwork::addItemHandler);
    }

    public void handleBlockedConnectionChange(BlockPos nodePos, EnumFacing side, boolean isBlockedNow) {
        if (isBlockedNow) {
            SidedBlockPos blockPos = new SidedBlockPos(nodePos, side);
            ItemHandlerInfo handlerInfo = this.handlerInfoMap.get(blockPos);
            if (handlerInfo != null) {
                this.removeItemHandler(handlerInfo);
            }
        } else {
            ItemHandlerInfo handlerInfo = new ItemHandlerInfo(nodePos, side);
            this.addItemHandler(handlerInfo);
        }
    }

    public void checkForItemHandlers(BlockPos nodePos, int blockedConnections) {
        for (EnumFacing accessSide : EnumFacing.field_82609_l) {
            ItemHandlerInfo handlerInfo;
            if ((blockedConnections & 1 << accessSide.func_176745_a()) > 0) continue;
            SidedBlockPos blockPos = new SidedBlockPos(nodePos, accessSide);
            if (this.handlerInfoMap.containsKey(blockPos)) {
                handlerInfo = this.handlerInfoMap.get(blockPos);
                if (handlerInfo.updateCachedInfo() != UpdateResult.INVALID) continue;
                this.removeItemHandler(handlerInfo);
                continue;
            }
            handlerInfo = new ItemHandlerInfo(nodePos, accessSide);
            this.addItemHandler(handlerInfo);
        }
    }

    private void addItemHandler(ItemHandlerInfo handlerInfo) {
        if (!this.handlerInfoList.contains(handlerInfo)) {
            handlerInfo.setStorageNetwork(this);
            if (handlerInfo.updateCachedInfo() == UpdateResult.INVALID) {
                return;
            }
            this.handlerInfoList.add(handlerInfo);
            this.handlerInfoMap.put(ItemStorageNetwork.handlerPosition(handlerInfo), handlerInfo);
        }
    }

    private void removeItemHandler(ItemHandlerInfo handlerInfo) {
        this.handlerInfoList.remove(handlerInfo);
        this.handlerInfoMap.remove(ItemStorageNetwork.handlerPosition(handlerInfo));
        handlerInfo.setStorageNetwork(null);
        for (ItemStackKey itemStackKey : this.itemInfoMap.keySet()) {
            NetworkItemInfo itemInfo = this.itemInfoMap.get(itemStackKey);
            itemInfo.removeInventory(handlerInfo);
        }
    }

    private static SidedBlockPos handlerPosition(ItemHandlerInfo handlerInfo) {
        return new SidedBlockPos(handlerInfo.getBlockPos(), handlerInfo.getAccessSide());
    }

    void updateStoredItems(ItemHandlerInfo handlerInfo, Map<ItemStackKey, Integer> itemAmount, Set<ItemStackKey> removedItems) {
        NetworkItemInfo itemInfo;
        for (ItemStackKey itemStackKey : itemAmount.keySet()) {
            itemInfo = this.itemInfoMap.get(itemStackKey);
            if (itemInfo == null) continue;
            itemInfo.addInventory(handlerInfo, itemAmount.get(itemStackKey));
        }
        for (ItemStackKey removedItem : removedItems) {
            itemInfo = this.itemInfoMap.get(removedItem);
            if (itemInfo == null) continue;
            itemInfo.removeInventory(handlerInfo);
        }
    }

    private static class SidedBlockPos {
        private final BlockPos blockPos;
        private final EnumFacing accessSide;

        public SidedBlockPos(BlockPos blockPos, EnumFacing accessSide) {
            this.blockPos = blockPos;
            this.accessSide = accessSide;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public EnumFacing getAccessSide() {
            return this.accessSide;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SidedBlockPos)) {
                return false;
            }
            SidedBlockPos that = (SidedBlockPos)o;
            return Objects.equals(this.blockPos, that.blockPos) && this.accessSide == that.accessSide;
        }

        public int hashCode() {
            return Objects.hash(this.blockPos, this.accessSide);
        }
    }
}

