/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.inventory.network;

import gregtech.api.util.ItemStackKey;
import gregtech.common.pipelike.inventory.network.ItemHandlerInfo;
import java.util.HashMap;
import java.util.Map;

public class NetworkItemInfo {
    private final ItemStackKey itemStackKey;
    private int totalItemAmount = 0;
    private Map<ItemHandlerInfo, Integer> inventories = new HashMap<ItemHandlerInfo, Integer>();

    public NetworkItemInfo(ItemStackKey itemStackKey) {
        this.itemStackKey = itemStackKey;
    }

    public int getTotalItemAmount() {
        return this.totalItemAmount;
    }

    public ItemStackKey getItemStackKey() {
        return this.itemStackKey;
    }

    void addInventory(ItemHandlerInfo inventory, int amount) {
        if (this.inventories.getOrDefault(inventory, 0) != amount) {
            this.inventories.put(inventory, amount);
            this.recomputeItemAmount();
        }
    }

    void removeInventory(ItemHandlerInfo inventory) {
        if (this.inventories.containsKey(inventory)) {
            this.inventories.remove(inventory);
            this.recomputeItemAmount();
        }
    }

    private void recomputeItemAmount() {
        this.totalItemAmount = this.inventories.values().stream().mapToInt(Integer::intValue).sum();
    }
}

