/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.tesr;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Matrix4;
import gregtech.common.blocks.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.animation.FastTESR;

public abstract class TileEntityRendererBase<T extends TileEntityBase>
extends FastTESR<T> {
    public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        if (te.func_145831_w() != null) {
            renderState.setBrightness((IBlockAccess)te.func_145831_w(), te.func_174877_v());
        }
        Matrix4 translation = new Matrix4().translate(x, y, z);
        this.draw(te, renderState, translation, partialTicks);
    }

    protected abstract void draw(T var1, CCRenderState var2, Matrix4 var3, float var4);

    public static class TileEntityRenderBaseItem<T extends TileEntityBase>
    extends TileEntityItemStackRenderer {
        private final T tileEntityInstance;

        public TileEntityRenderBaseItem(Class<T> tileEntityClass) {
            try {
                this.tileEntityInstance = (TileEntityBase)((Object)tileEntityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw new RuntimeException(exception);
            }
        }

        public void func_192838_a(ItemStack stack, float partialTicks) {
            IBlockState renderState = Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
            ((TileEntityBase)((Object)this.tileEntityInstance)).setBlockState(renderState);
            TileEntityRendererDispatcher.field_147556_a.func_192855_a(this.tileEntityInstance, 0.0, 0.0, 0.0, 0.0f, partialTicks);
        }
    }
}

