/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;

public abstract class AbstractItemLootEntry
extends LootEntry {
    private LootFunction[] functions;

    protected AbstractItemLootEntry(int weightIn, int qualityIn, LootFunction[] functionsIn, LootCondition[] conditionsIn, String entryName) {
        super(weightIn, qualityIn, conditionsIn, entryName);
        this.functions = functionsIn;
    }

    protected abstract ItemStack createItemStack();

    public void func_186363_a(Collection<ItemStack> stacks, Random rand, LootContext context) {
        ItemStack itemStack = this.createItemStack();
        for (LootFunction lootfunction : this.functions) {
            if (!LootConditionManager.func_186638_a((LootCondition[])lootfunction.func_186554_a(), (Random)rand, (LootContext)context)) continue;
            itemStack = lootfunction.func_186553_a(itemStack, rand, context);
        }
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() < itemStack.func_77973_b().getItemStackLimit(itemStack)) {
                stacks.add(itemStack);
            } else {
                ItemStack itemstack1;
                for (int i = itemStack.func_190916_E(); i > 0; i -= itemstack1.func_190916_E()) {
                    itemstack1 = itemStack.func_77946_l();
                    itemstack1.func_190920_e(Math.min(itemStack.func_77976_d(), i));
                    stacks.add(itemstack1);
                }
            }
        }
    }

    protected final void func_186362_a(JsonObject json, JsonSerializationContext context) {
        throw new UnsupportedOperationException("Unsupported by custom loot entries");
    }

    public static interface LootEntryCreator {
        public AbstractItemLootEntry create(JsonObject var1, int var2, int var3, LootFunction[] var4, LootCondition[] var5, String var6);
    }
}

