/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.FuelRecipeLogic;
import gregtech.api.gui.impl.ModularUIGuiHandler;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.recipes.machines.RecipeMapFurnace;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.electric.MetaTileEntityMacerator;
import gregtech.integration.jei.multiblock.MultiblockInfoCategory;
import gregtech.integration.jei.recipe.FacadeRegistryPlugin;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtech.integration.jei.recipe.RecipeMapCategory;
import gregtech.integration.jei.recipe.fuel.FuelRecipeMapCategory;
import gregtech.integration.jei.recipe.fuel.GTFuelRecipeWrapper;
import gregtech.integration.jei.recipe.primitive.CokeOvenRecipeCategory;
import gregtech.integration.jei.recipe.primitive.CokeOvenRecipeWrapper;
import gregtech.integration.jei.recipe.primitive.OreByProduct;
import gregtech.integration.jei.recipe.primitive.OreByProductCategory;
import gregtech.integration.jei.recipe.primitive.PrimitiveBlastRecipeCategory;
import gregtech.integration.jei.recipe.primitive.PrimitiveBlastRecipeWrapper;
import gregtech.integration.jei.utils.CustomItemReturnRecipeWrapper;
import gregtech.integration.jei.utils.MachineSubtypeHandler;
import gregtech.integration.jei.utils.MetaItemSubtypeHandler;
import gregtech.loaders.recipe.CustomItemReturnShapedOreRecipeRecipe;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class GTJeiPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        MetaItemSubtypeHandler subtype = new MetaItemSubtypeHandler();
        for (MetaItem<?> metaItem : MetaItems.ITEMS) {
            subtypeRegistry.registerSubtypeInterpreter(metaItem, (ISubtypeRegistry.ISubtypeInterpreter)subtype);
        }
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)MetaBlocks.MACHINE), (ISubtypeRegistry.ISubtypeInterpreter)new MachineSubtypeHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(registry.getJeiHelpers())});
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(recipeMap, registry.getJeiHelpers().getGuiHelper())});
        }
        for (FuelRecipeMap fuelRecipeMap : FuelRecipeMap.getRecipeMaps()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new FuelRecipeMapCategory(fuelRecipeMap, registry.getJeiHelpers().getGuiHelper())});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new PrimitiveBlastRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CokeOvenRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new OreByProductCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        MultiblockInfoCategory.registerRecipes(registry);
        registry.handleRecipes(CustomItemReturnShapedOreRecipeRecipe.class, recipe -> new CustomItemReturnRecipeWrapper(jeiHelpers, (CustomItemReturnShapedOreRecipeRecipe)((Object)((Object)recipe))), "minecraft.crafting");
        registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new FacadeRegistryPlugin());
        ModularUIGuiHandler modularUIGuiHandler = new ModularUIGuiHandler();
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{modularUIGuiHandler});
        registry.addGhostIngredientHandler(modularUIGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)modularUIGuiHandler);
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            List recipesList = recipeMap.getRecipeList().stream().filter(recipe -> !recipe.isHidden() && recipe.hasValidInputsForDisplay()).map(r -> new GTRecipeWrapper(recipeMap, (Recipe)r)).collect(Collectors.toList());
            registry.addRecipes(recipesList, "gregtech:" + recipeMap.unlocalizedName);
        }
        for (FuelRecipeMap fuelRecipeMap : FuelRecipeMap.getRecipeMaps()) {
            List recipeList = fuelRecipeMap.getRecipeList().stream().map(GTFuelRecipeWrapper::new).collect(Collectors.toList());
            registry.addRecipes(recipeList, "gregtech:" + fuelRecipeMap.unlocalizedName);
        }
        for (ResourceLocation metaTileEntityId : GregTechAPI.META_TILE_ENTITY_REGISTRY.func_148742_b()) {
            Object recipeMap;
            MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.META_TILE_ENTITY_REGISTRY.func_82594_a(metaTileEntityId);
            if (metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null) == null) continue;
            IControllable iControllable = metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
            if (iControllable instanceof AbstractRecipeLogic) {
                recipeMap = ((AbstractRecipeLogic)iControllable).recipeMap;
                registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + ((RecipeMap)recipeMap).unlocalizedName});
                if (!(recipeMap instanceof RecipeMapFurnace)) continue;
                registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"minecraft.smelting"});
                continue;
            }
            if (!(iControllable instanceof FuelRecipeLogic)) continue;
            recipeMap = ((FuelRecipeLogic)iControllable).recipeMap;
            registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + ((FuelRecipeMap)recipeMap).unlocalizedName});
        }
        for (Iterator<Object> iterator : MetaTileEntities.BREWERY) {
            registry.addRecipeCatalyst((Object)((MetaTileEntity)((Object)iterator)).getStackForm(), new String[]{"minecraft.brewing"});
        }
        String semiFluidMapId = "gregtech:" + RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.getUnlocalizedName();
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_BRONZE_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_STEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TITANIUM_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
        FluidStack air = Materials.Air.getFluid(1000);
        registry.addIngredientInfo((Object)air, air.getClass(), new String[]{I18n.func_135052_a((String)"gregtech.machine.air_collector.jei_description", (Object[])new Object[0])});
        String primitiveBlastId = "gregtech:primitive_blast_furnace";
        registry.addRecipes((Collection)RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES.stream().map(PrimitiveBlastRecipeWrapper::new).collect(Collectors.toList()), primitiveBlastId);
        registry.addRecipeCatalyst((Object)MetaTileEntities.PRIMITIVE_BLAST_FURNACE.getStackForm(), new String[]{primitiveBlastId});
        String string = "gregtech:coke_oven";
        registry.addRecipes((Collection)RecipeMaps.COKE_OVEN_RECIPES.stream().map(CokeOvenRecipeWrapper::new).collect(Collectors.toList()), string);
        registry.addRecipeCatalyst((Object)MetaTileEntities.COKE_OVEN.getStackForm(), new String[]{string});
        CopyOnWriteArrayList<OreByProduct> oreByproductList = new CopyOnWriteArrayList<OreByProduct>();
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!(material instanceof DustMaterial) || OreDictUnifier.get(OrePrefix.ore, material) == ItemStack.field_190927_a) continue;
            oreByproductList.add(new OreByProduct((DustMaterial)material));
        }
        String oreByProductId = "gregtech:ore_by_product";
        registry.addRecipes(oreByproductList, oreByProductId);
        for (MetaTileEntityMacerator metaTileEntityMacerator : MetaTileEntities.MACERATOR) {
            registry.addRecipeCatalyst((Object)metaTileEntityMacerator.getStackForm(), new String[]{oreByProductId});
        }
        for (SimpleMachineMetaTileEntity simpleMachineMetaTileEntity : MetaTileEntities.ORE_WASHER) {
            registry.addRecipeCatalyst((Object)simpleMachineMetaTileEntity.getStackForm(), new String[]{oreByProductId});
        }
        for (SimpleMachineMetaTileEntity simpleMachineMetaTileEntity : MetaTileEntities.CENTRIFUGE) {
            registry.addRecipeCatalyst((Object)simpleMachineMetaTileEntity.getStackForm(), new String[]{oreByProductId});
        }
        for (SimpleMachineMetaTileEntity simpleMachineMetaTileEntity : MetaTileEntities.THERMAL_CENTRIFUGE) {
            registry.addRecipeCatalyst((Object)simpleMachineMetaTileEntity.getStackForm(), new String[]{oreByProductId});
        }
    }
}

