/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import com.google.common.collect.Lists;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.multiblock.MultiblockInfoRecipeWrapper;
import gregtech.integration.jei.multiblock.infos.CokeOvenInfo;
import gregtech.integration.jei.multiblock.infos.CrackerUnitInfo;
import gregtech.integration.jei.multiblock.infos.DieselEngineInfo;
import gregtech.integration.jei.multiblock.infos.DistillationTowerInfo;
import gregtech.integration.jei.multiblock.infos.ElectricBlastFurnaceInfo;
import gregtech.integration.jei.multiblock.infos.ImplosionCompressorInfo;
import gregtech.integration.jei.multiblock.infos.LargeBoilerInfo;
import gregtech.integration.jei.multiblock.infos.LargeTurbineInfo;
import gregtech.integration.jei.multiblock.infos.MultiSmelterInfo;
import gregtech.integration.jei.multiblock.infos.PrimitiveBlastFurnaceInfo;
import gregtech.integration.jei.multiblock.infos.PyrolyzeOvenInfo;
import gregtech.integration.jei.multiblock.infos.VacuumFreezerInfo;
import java.util.Collection;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class MultiblockInfoCategory
implements IRecipeCategory<MultiblockInfoRecipeWrapper> {
    private final IDrawable background;
    private final IDrawable icon;

    public MultiblockInfoCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createBlankDrawable(176, 166);
        ResourceLocation iconLocation = new ResourceLocation("gregtech", "textures/gui/icon/coke_oven.png");
        this.icon = helpers.getGuiHelper().createDrawable(iconLocation, 0, 0, 16, 16, 16, 16);
    }

    public static void registerRecipes(IModRegistry registry) {
        registry.addRecipes((Collection)Lists.newArrayList((Object[])new MultiblockInfoRecipeWrapper[]{new MultiblockInfoRecipeWrapper(new PrimitiveBlastFurnaceInfo()), new MultiblockInfoRecipeWrapper(new CokeOvenInfo()), new MultiblockInfoRecipeWrapper(new VacuumFreezerInfo()), new MultiblockInfoRecipeWrapper(new ImplosionCompressorInfo()), new MultiblockInfoRecipeWrapper(new PyrolyzeOvenInfo()), new MultiblockInfoRecipeWrapper(new CrackerUnitInfo()), new MultiblockInfoRecipeWrapper(new DieselEngineInfo()), new MultiblockInfoRecipeWrapper(new DistillationTowerInfo()), new MultiblockInfoRecipeWrapper(new ElectricBlastFurnaceInfo()), new MultiblockInfoRecipeWrapper(new MultiSmelterInfo()), new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_BRONZE_BOILER)), new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_STEEL_BOILER)), new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_TITANIUM_BOILER)), new MultiblockInfoRecipeWrapper(new LargeBoilerInfo(MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER)), new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_STEAM_TURBINE)), new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_GAS_TURBINE)), new MultiblockInfoRecipeWrapper(new LargeTurbineInfo(MetaTileEntities.LARGE_PLASMA_TURBINE))}), "gregtech:multiblock_info");
    }

    public String getUid() {
        return "gregtech:multiblock_info";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"gregtech.multiblock.title", (Object[])new Object[0]);
    }

    public String getModName() {
        return "gregtech";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, MultiblockInfoRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeWrapper.setRecipeLayout((RecipeLayout)recipeLayout);
    }
}

