/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import gregtech.api.render.scene.SceneRenderCallback;
import gregtech.api.render.scene.WorldSceneRenderer;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.integration.jei.multiblock.MultiblockInfoPage;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Vector3f;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MultiblockInfoRecipeWrapper
implements IRecipeWrapper,
SceneRenderCallback {
    private final MultiblockInfoPage infoPage;
    private WorldSceneRenderer[] sceneRenders;
    private Map<GuiButton, Runnable> buttons = new HashMap<GuiButton, Runnable>();
    private RecipeLayout recipeLayout;
    private int layerIndex = -1;
    private int currentRendererPage = 0;
    private int lastMouseX;
    private int lastMouseY;
    private float rotationYaw;
    private float rotationPitch;
    private GuiButton buttonPreviousPattern;
    private GuiButton buttonNextPattern;
    private GuiButton nextLayerButton;
    private ItemStack tooltipBlockStack;

    public MultiblockInfoRecipeWrapper(MultiblockInfoPage infoPage) {
        this.infoPage = infoPage;
        this.sceneRenders = (WorldSceneRenderer[])infoPage.getMatchingShapes().stream().map(this::initializeSceneRenderer).toArray(WorldSceneRenderer[]::new);
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack itemStack = this.infoPage.getController().getStackForm();
        ingredients.setInput(ItemStack.class, (Object)itemStack);
        ingredients.setOutput(ItemStack.class, (Object)itemStack);
    }

    public void setRecipeLayout(RecipeLayout layout) {
        this.recipeLayout = layout;
        IDrawable border = layout.getRecipeCategory().getBackground();
        this.buttons.clear();
        this.nextLayerButton = new GuiButton(0, border.getWidth() - 30, 70, 20, 20, "");
        this.buttonPreviousPattern = new GuiButton(0, 10, border.getHeight() - 30, 20, 20, "<");
        this.buttonNextPattern = new GuiButton(0, border.getWidth() - 30, border.getHeight() - 30, 20, 20, ">");
        this.buttons.put(this.nextLayerButton, this::toggleNextLayer);
        this.buttons.put(this.buttonPreviousPattern, () -> this.switchRenderPage(-1));
        this.buttons.put(this.buttonNextPattern, () -> this.switchRenderPage(1));
        boolean isPagesDisabled = this.sceneRenders.length == 1;
        this.buttonPreviousPattern.field_146125_m = !isPagesDisabled;
        this.buttonNextPattern.field_146125_m = !isPagesDisabled;
        this.buttonPreviousPattern.field_146124_l = false;
        this.buttonNextPattern.field_146124_l = this.sceneRenders.length > 1;
        this.rotationYaw = -45.0f;
        this.rotationPitch = 0.0f;
        this.currentRendererPage = 0;
        this.setNextLayer(-1);
    }

    public WorldSceneRenderer getCurrentRenderer() {
        return this.sceneRenders[this.currentRendererPage];
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    private void toggleNextLayer() {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int height = (int)renderer.getSize().getY() - 1;
        if (++this.layerIndex > height) {
            this.layerIndex = -1;
        }
        this.setNextLayer(this.layerIndex);
    }

    private void setNextLayer(int newLayer) {
        this.layerIndex = newLayer;
        this.nextLayerButton.field_146126_j = "L:" + (this.layerIndex == -1 ? "A" : Integer.toString(this.layerIndex + 1));
    }

    private void switchRenderPage(int amount) {
        int maxIndex = this.sceneRenders.length - 1;
        int newIndex = Math.max(0, Math.min(this.currentRendererPage + amount, maxIndex));
        if (this.currentRendererPage != newIndex) {
            this.currentRendererPage = newIndex;
            this.buttonNextPattern.field_146124_l = newIndex < maxIndex;
            this.buttonPreviousPattern.field_146124_l = newIndex > 0;
        }
    }

    private boolean shouldDisplayBlock(BlockPos pos) {
        if (this.getLayerIndex() == -1) {
            return true;
        }
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int minHeight = (int)renderer.world.getMinPos().getY();
        int relativeHeight = pos.func_177956_o() - minHeight;
        return relativeHeight == this.getLayerIndex();
    }

    @Override
    public void preRenderScene(WorldSceneRenderer renderer) {
        Vector3f size = renderer.getSize();
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179109_b((float)-1.0f, (float)-2.5f, (float)0.0f);
        Vector3 centerPosition = new Vector3((double)(size.x / 2.0f), (double)(size.y / 2.0f), (double)(size.z / 2.0f));
        GlStateManager.func_179137_b((double)centerPosition.x, (double)centerPosition.y, (double)centerPosition.z);
        GlStateManager.func_179114_b((float)this.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-centerPosition.x), (double)(-centerPosition.y), (double)(-centerPosition.z));
        GlStateManager.func_179137_b((double)centerPosition.x, (double)centerPosition.y, (double)centerPosition.z);
        GlStateManager.func_179114_b((float)this.rotationPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-centerPosition.x), (double)(-centerPosition.y), (double)(-centerPosition.z));
        if (this.layerIndex >= 0) {
            GlStateManager.func_179137_b((double)0.0, (double)(-this.layerIndex + 1), (double)0.0);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int scenePosY = 0;
        int sceneHeight = recipeWidth;
        renderer.render(this.recipeLayout.getPosX(), this.recipeLayout.getPosY() + scenePosY, recipeWidth, sceneHeight, 0xC6C6C6);
        this.drawText(minecraft, recipeWidth);
        for (GuiButton button : this.buttons.keySet()) {
            button.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        }
        this.tooltipBlockStack = null;
        BlockPos pos = renderer.getLastHitBlock();
        boolean leftClickHeldAndInsideView = Mouse.isButtonDown((int)0) && mouseX >= 0 && mouseY >= scenePosY && mouseX < recipeWidth && mouseY < scenePosY + sceneHeight;
        boolean isHoldingShift = Keyboard.isKeyDown((int)42);
        if (!leftClickHeldAndInsideView && pos != null && !renderer.world.func_175623_d(pos)) {
            IBlockState blockState = renderer.world.func_180495_p(pos);
            CuboidRayTraceResult result = new CuboidRayTraceResult(new Vector3(0.5, 0.5, 0.5).add(pos), pos, EnumFacing.UP, new IndexedCuboid6(null, Cuboid6.full), 1.0);
            ItemStack itemStack = blockState.func_177230_c().getPickBlock(blockState, (RayTraceResult)result, (World)renderer.world, pos, (EntityPlayer)minecraft.field_71439_g);
            if (itemStack != null && !itemStack.func_190926_b()) {
                this.tooltipBlockStack = itemStack;
            }
        }
        if (leftClickHeldAndInsideView) {
            if (isHoldingShift) {
                int mouseDeltaY = mouseY - this.lastMouseY;
                this.rotationPitch += (float)mouseDeltaY * 2.0f;
            } else {
                int mouseDeltaX = mouseX - this.lastMouseX;
                this.rotationYaw += (float)mouseDeltaX * 2.0f;
            }
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void drawText(Minecraft minecraft, int recipeWidth) {
        String localizedName = I18n.func_135052_a((String)this.infoPage.getController().getMetaFullName(), (Object[])new Object[0]);
        GTUtility.drawCenteredSizedText(recipeWidth / 2, 0, localizedName, 0x333333, 1.3);
        FontRenderer fontRenderer = minecraft.field_71466_p;
        List lines = Arrays.stream(this.infoPage.getDescription()).flatMap(s -> fontRenderer.func_78271_c(s, recipeWidth).stream()).collect(Collectors.toList());
        for (int i = 0; i < lines.size(); ++i) {
            String lineText = (String)lines.get(i);
            int x = (recipeWidth - fontRenderer.func_78256_a(lineText)) / 2;
            int y = 8 + i * fontRenderer.field_78288_b;
            fontRenderer.func_78276_b(lineText, x, y, 0x333333);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        for (Map.Entry<GuiButton, Runnable> button : this.buttons.entrySet()) {
            if (!button.getKey().func_146116_c(minecraft, mouseX, mouseY)) continue;
            button.getValue().run();
            return true;
        }
        return false;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.tooltipBlockStack != null && !this.tooltipBlockStack.func_190926_b() && !Mouse.isButtonDown((int)0)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ITooltipFlag.TooltipFlags flag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List tooltip = this.tooltipBlockStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, (ITooltipFlag)flag);
            EnumRarity rarity = this.tooltipBlockStack.func_77953_t();
            for (int k = 0; k < tooltip.size(); ++k) {
                if (k == 0) {
                    tooltip.set(k, rarity.field_77937_e + (String)tooltip.get(k));
                    continue;
                }
                tooltip.set(k, TextFormatting.GRAY + (String)tooltip.get(k));
            }
            return tooltip;
        }
        return Collections.emptyList();
    }

    private WorldSceneRenderer initializeSceneRenderer(MultiblockShapeInfo shapeInfo) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int z = 0; z < blocks.length; ++z) {
            BlockInfo[][] aisle = blocks[z];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int x = 0; x < column.length; ++x) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockInfo blockInfo = column[x];
                    blockMap.put(blockPos, blockInfo);
                }
            }
        }
        WorldSceneRenderer worldSceneRenderer = new WorldSceneRenderer(blockMap);
        worldSceneRenderer.world.func_72939_s();
        worldSceneRenderer.setRenderCallback(this);
        worldSceneRenderer.setRenderFilter(this::shouldDisplayBlock);
        return worldSceneRenderer;
    }
}

