/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock.infos;

import com.google.common.collect.Lists;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.BlockInfo;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.TurbineRotorBehavior;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityRotorHolder;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import gregtech.integration.jei.multiblock.MultiblockInfoPage;
import gregtech.integration.jei.multiblock.MultiblockShapeInfo;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class LargeTurbineInfo
extends MultiblockInfoPage {
    public final MetaTileEntityLargeTurbine turbine;

    public LargeTurbineInfo(MetaTileEntityLargeTurbine turbine) {
        this.turbine = turbine;
    }

    @Override
    public MultiblockControllerBase getController() {
        return this.turbine;
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        MetaTileEntityHolder holder = new MetaTileEntityHolder();
        holder.setMetaTileEntity(MetaTileEntities.ROTOR_HOLDER[2]);
        holder.getMetaTileEntity().setFrontFacing(EnumFacing.WEST);
        ItemStack rotorStack = MetaItems.TURBINE_ROTOR.getStackForm();
        TurbineRotorBehavior.getInstanceFor(rotorStack).setPartMaterial(rotorStack, Materials.Darmstadtium);
        ((MetaTileEntityRotorHolder)holder.getMetaTileEntity()).getRotorInventory().setStackInSlot(0, rotorStack);
        MultiblockShapeInfo.Builder shapeInfo = MultiblockShapeInfo.builder().aisle("CCCC", "CIOC", "CCCC").aisle("CCCC", "R##D", "CCCC").aisle("CCCC", "CSCC", "CCCC").where('S', this.turbine, EnumFacing.SOUTH).where('C', this.turbine.turbineType.casingState).where('R', new BlockInfo(MetaBlocks.MACHINE.func_176223_P(), holder)).where('D', MetaTileEntities.ENERGY_OUTPUT_HATCH[4], EnumFacing.EAST).where('#', Blocks.field_150350_a.func_176223_P()).where('I', MetaTileEntities.FLUID_IMPORT_HATCH[3], EnumFacing.NORTH);
        if (this.turbine.turbineType.hasOutputHatch) {
            shapeInfo.where('O', MetaTileEntities.FLUID_EXPORT_HATCH[4], EnumFacing.NORTH);
        } else {
            shapeInfo.where('O', this.turbine.turbineType.casingState);
        }
        return Lists.newArrayList((Object[])new MultiblockShapeInfo[]{shapeInfo.build()});
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_turbine.description", (Object[])new Object[0])};
    }
}

