/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils;

import gregtech.loaders.recipe.CustomItemReturnShapedOreRecipeRecipe;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.gui.CraftingGridHelper;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CustomItemReturnRecipeWrapper
extends ShapedOreRecipeWrapper
implements ICustomCraftingRecipeWrapper {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    private CraftingGridHelper craftingGridHelper;
    private CustomItemReturnShapedOreRecipeRecipe customRecipe;

    public CustomItemReturnRecipeWrapper(IJeiHelpers jeiHelpers, CustomItemReturnShapedOreRecipeRecipe recipe) {
        super(jeiHelpers, (ShapedOreRecipe)recipe);
        this.customRecipe = recipe;
        this.craftingGridHelper = new CraftingGridHelper(1, 0);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.getWidth(), this.getHeight());
        guiItemStacks.set(0, (List)outputs.get(0));
        ResourceLocation registryName = this.getRegistryName();
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 0 && registryName != null) {
                boolean showAdvanced;
                String recipeModId = registryName.func_110624_b();
                boolean modIdDifferent = false;
                ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                if (itemRegistryName != null) {
                    String itemModId = itemRegistryName.func_110624_b();
                    boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                }
                if (modIdDifferent) {
                    String modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId);
                    tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                }
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                if (showAdvanced) {
                    tooltip.add(TextFormatting.GRAY + registryName.func_110623_a());
                }
            }
            if (slotIndex != 0 && this.customRecipe.shouldItemReturn((ItemStack)ingredient)) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
            }
        });
    }
}

