/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.api.IDynamicPartFactory;
import gregtech.integration.multipart.CableMultiPart;
import gregtech.integration.multipart.CableMultiPartTickable;
import gregtech.integration.multipart.FluidPipeActiveMultiPart;
import gregtech.integration.multipart.FluidPipeMultiPart;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class GTMultipartFactory
implements IDynamicPartFactory {
    public static final ResourceLocation CABLE_PART_KEY = new ResourceLocation("gregtech", "cable");
    public static final ResourceLocation CABLE_PART_TICKABLE_KEY = new ResourceLocation("gregtech", "cable_tickable");
    public static final ResourceLocation FLUID_PIPE_PART_KEY = new ResourceLocation("gregtech", "fluid_pipe");
    public static final ResourceLocation FLUID_PIPE_ACTIVE_PART_KEY = new ResourceLocation("gregtech", "fluid_pipe_active");
    public static final GTMultipartFactory INSTANCE = new GTMultipartFactory();
    private final Map<ResourceLocation, Supplier<TMultiPart>> partRegistry = new HashMap<ResourceLocation, Supplier<TMultiPart>>();

    public void registerFactory() {
        this.registerPart(CABLE_PART_KEY, CableMultiPart::new);
        this.registerPart(CABLE_PART_TICKABLE_KEY, CableMultiPartTickable::new);
        this.registerPart(FLUID_PIPE_PART_KEY, FluidPipeMultiPart::new);
        this.registerPart(FLUID_PIPE_ACTIVE_PART_KEY, FluidPipeActiveMultiPart::new);
        MultiPartRegistry.registerParts((IDynamicPartFactory)this, this.partRegistry.keySet());
    }

    private void registerPart(ResourceLocation identifier, Supplier<TMultiPart> supplier) {
        this.partRegistry.put(identifier, supplier);
    }

    public TMultiPart createPartServer(ResourceLocation identifier, NBTTagCompound compound) {
        return this.createPart(identifier);
    }

    public TMultiPart createPartClient(ResourceLocation identifier, MCDataInput packet) {
        return this.createPart(identifier);
    }

    public TMultiPart createPart(ResourceLocation identifier) {
        if (this.partRegistry.containsKey(identifier)) {
            Supplier<TMultiPart> supplier = this.partRegistry.get(identifier);
            return supplier.get();
        }
        return null;
    }
}

