/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.multipart;

import codechicken.multipart.TMultiPart;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.AttachmentType;
import gregtech.api.unification.material.type.Material;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;

public abstract class PipeMultiPart<PipeType extends Enum<PipeType>, NodeDataType>
extends TMultiPart
implements ITickable {
    protected BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private int pipeType;
    private Material material;
    protected int insulationColor = 0;
    private TIntIntMap blockedConnectionsMap = new TIntIntHashMap();

    protected PipeMultiPart() {
    }

    protected TileEntityMaterialPipeBase<PipeType, NodeDataType> createTileEntity() {
        return (TileEntityMaterialPipeBase)this.pipeBlock.createNewTileEntity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.world().field_72995_K) {
            return;
        }
        this.world().func_175656_a(this.pos(), this.pipeBlock.func_176223_P());
        TileEntityMaterialPipeBase<Enum, NodeDataType> tileEntity = this.createTileEntity();
        this.world().func_175690_a(this.pos(), tileEntity);
        Enum pipeType = ((Enum[])this.pipeBlock.getPipeTypeClass().getEnumConstants())[this.pipeType];
        tileEntity.setDetachedConversionMode(true);
        try {
            tileEntity.setPipeData(this.pipeBlock, pipeType, this.material);
            tileEntity.setInsulationColor(this.insulationColor);
            int totalBlockedConnections = this.blockedConnectionsMap.get(AttachmentType.PIPE.ordinal());
            totalBlockedConnections |= this.blockedConnectionsMap.get(AttachmentType.MULTIPART.ordinal());
            for (EnumFacing blockedSide : EnumFacing.field_82609_l) {
                if ((totalBlockedConnections & 1 << blockedSide.func_176745_a()) <= 0) continue;
                tileEntity.setConnectionBlocked(AttachmentType.PIPE, blockedSide, true);
            }
        }
        finally {
            tileEntity.setDetachedConversionMode(false);
        }
    }

    public void save(NBTTagCompound tag) {
        tag.func_74778_a("PipeBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c(this.pipeBlock)).toString());
        tag.func_74768_a("PipeType", this.pipeType);
        tag.func_74778_a("PipeMaterial", this.material.toString());
        tag.func_74768_a("InsulationColor", this.insulationColor);
        NBTTagCompound blockedConnectionsTag = new NBTTagCompound();
        for (int attachmentType : this.blockedConnectionsMap.keys()) {
            int blockedConnections = this.blockedConnectionsMap.get(attachmentType);
            blockedConnectionsTag.func_74768_a(Integer.toString(attachmentType), blockedConnections);
        }
        tag.func_74782_a("BlockedConnectionsMap", (NBTBase)blockedConnectionsTag);
    }

    public void load(NBTTagCompound tag) {
        ResourceLocation pipeBlockName = new ResourceLocation(tag.func_74779_i("PipeBlock"));
        this.pipeBlock = (BlockPipe)Block.field_149771_c.func_82594_a((Object)pipeBlockName);
        this.pipeType = tag.func_74762_e("PipeType");
        this.material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(tag.func_74779_i("PipeMaterial"));
        this.insulationColor = tag.func_74762_e("InsulationColor");
        this.blockedConnectionsMap.clear();
        NBTTagCompound blockedConnectionsTag = tag.func_74775_l("BlockedConnectionsMap");
        for (String attachmentTypeKey : blockedConnectionsTag.func_150296_c()) {
            int attachmentType = Integer.parseInt(attachmentTypeKey);
            int blockedConnections = blockedConnectionsTag.func_74762_e(attachmentTypeKey);
            this.blockedConnectionsMap.put(attachmentType, blockedConnections);
        }
        if (tag.func_74764_b("BlockedConnections")) {
            int blockedConnections = tag.func_74762_e("BlockedConnections");
            this.blockedConnectionsMap.put(AttachmentType.MULTIPART.ordinal(), blockedConnections);
        }
    }
}

