/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChestGenHooks {
    private static final HashMap<ResourceLocation, ArrayList<LootEntryItem>> lootEntryItems = new HashMap();
    private static final HashMap<ResourceLocation, RandomValueRange> rollVals = new HashMap();
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static ChestGenHooks instance = new ChestGenHooks();

    private ChestGenHooks() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    public void onWorldLoad(LootTableLoadEvent event) {
        LootPool mainPool = event.getTable().getPool("main");
        if (mainPool != null && lootEntryItems.containsKey(event.getName())) {
            ArrayList<LootEntryItem> entryItems = lootEntryItems.get(event.getName());
            for (LootEntryItem entry : entryItems) {
                mainPool.addEntry((LootEntry)entry);
            }
        }
        if (mainPool != null && rollVals.containsKey(event.getName())) {
            RandomValueRange rangeAdd = rollVals.get(event.getName());
            RandomValueRange range = mainPool.getRolls();
            mainPool.setRolls(new RandomValueRange(range.func_186509_a() + rangeAdd.func_186509_a(), range.func_186512_b() + rangeAdd.func_186512_b()));
        }
    }

    public static void addItem(ResourceLocation lootTable, final ItemStack item, final int minAmount, final int additionalAmount, int weight) {
        LootEntryItem itemEntry = new LootEntryItem(item.func_77973_b(), weight, 1, new LootFunction[]{new LootFunction(NO_CONDITIONS){

            public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                stack.func_77964_b(item.func_77952_i());
                stack.func_77982_d(item.func_77978_p());
                stack.func_190920_e(minAmount + rand.nextInt(additionalAmount));
                return stack;
            }
        }}, NO_CONDITIONS, "#gregtech:loot_" + item.toString());
        if (lootEntryItems.containsKey(lootTable)) {
            lootEntryItems.get(lootTable).add(itemEntry);
        } else {
            lootEntryItems.put(lootTable, Lists.newArrayList((Object[])new LootEntryItem[]{itemEntry}));
        }
    }

    public static void addRolls(ResourceLocation tableLocation, int minAdd, int maxAdd) {
        rollVals.put(tableLocation, new RandomValueRange((float)minAdd, (float)maxAdd));
    }
}

