/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.CutterRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class MaterialRecipeHandler {
    private static final List<OrePrefix> GEM_ORDER = Arrays.asList(OrePrefix.gemChipped, OrePrefix.gemFlawed, OrePrefix.gem, OrePrefix.gemFlawless, OrePrefix.gemExquisite);
    private static final Set<IngotMaterial> circuitRequiringMaterials = new HashSet<IngotMaterial>();

    public static void register() {
        OrePrefix.ingot.addProcessingHandler(IngotMaterial.class, MaterialRecipeHandler::processIngot);
        OrePrefix.nugget.addProcessingHandler(SolidMaterial.class, MaterialRecipeHandler::processNugget);
        OrePrefix.block.addProcessingHandler(DustMaterial.class, MaterialRecipeHandler::processBlock);
        OrePrefix.frameGt.addProcessingHandler(SolidMaterial.class, MaterialRecipeHandler::processFrame);
        OrePrefix.dust.addProcessingHandler(DustMaterial.class, MaterialRecipeHandler::processDust);
        OrePrefix.dustSmall.addProcessingHandler(DustMaterial.class, MaterialRecipeHandler::processSmallDust);
        OrePrefix.dustTiny.addProcessingHandler(DustMaterial.class, MaterialRecipeHandler::processTinyDust);
        for (OrePrefix orePrefix : GEM_ORDER) {
            orePrefix.addProcessingHandler(GemMaterial.class, MaterialRecipeHandler::processGem);
        }
        MaterialRecipeHandler.setMaterialRequiresCircuit(Materials.Silicon);
    }

    public static void setMaterialRequiresCircuit(IngotMaterial material) {
        circuitRequiringMaterials.add(material);
    }

    public static void processDust(OrePrefix dustPrefix, DustMaterial material) {
        if (material instanceof GemMaterial) {
            ItemStack gemStack = OreDictUnifier.get(OrePrefix.gem, material);
            ItemStack tinyDarkAshStack = OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh);
            if (material.hasFlag(GemMaterial.MatFlags.CRYSTALLISABLE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().input(dustPrefix, material)).fluidInputs(Materials.Water.getFluid(200))).chancedOutput(gemStack, 7000, 1000)).duration(1600)).EUt(24)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().input(dustPrefix, material)).fluidInputs(ModHandler.getDistilledWater(200))).chancedOutput(gemStack, 8000, 1000)).duration(1200)).EUt(24)).buildAndRegister();
            } else if (!material.hasFlag(Material.MatFlags.EXPLOSIVE) && !material.hasFlag(Material.MatFlags.FLAMMABLE)) {
                ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder().input(dustPrefix, material, 4)).outputs(GTUtility.copyAmount(3, gemStack), GTUtility.copyAmount(2, tinyDarkAshStack))).explosivesAmount(4).buildAndRegister();
            }
        } else if (material instanceof IngotMaterial) {
            IngotMaterial metalMaterial = (IngotMaterial)material;
            if (!material.hasFlag(Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING)) {
                boolean hasHotIngot = OrePrefix.ingotHot.doGenerateItem(metalMaterial);
                ItemStack ingotStack = OreDictUnifier.get(hasHotIngot ? OrePrefix.ingotHot : OrePrefix.ingot, metalMaterial);
                ItemStack nuggetStack = OreDictUnifier.get(OrePrefix.nugget, metalMaterial);
                if (metalMaterial.blastFurnaceTemperature <= 0) {
                    ModHandler.addSmeltingRecipe(new UnificationEntry(dustPrefix, metalMaterial), ingotStack);
                    ModHandler.addSmeltingRecipe(new UnificationEntry(OrePrefix.dustTiny, metalMaterial), nuggetStack);
                } else {
                    int duration = Math.max(1, (int)(material.getAverageMass() * (long)metalMaterial.blastFurnaceTemperature / 50L));
                    ModHandler.removeFurnaceSmelting(new UnificationEntry(OrePrefix.ingot, metalMaterial));
                    BlastRecipeBuilder ingotSmeltingBuilder = (BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().input(dustPrefix, material)).outputs(ingotStack)).blastFurnaceTemp(metalMaterial.blastFurnaceTemperature).duration(duration)).EUt(120);
                    if (circuitRequiringMaterials.contains(material)) {
                        ingotSmeltingBuilder.inputs(new CountableIngredient(new IntCircuitIngredient(0), 0));
                    }
                    ingotSmeltingBuilder.buildAndRegister();
                    if (!hasHotIngot) {
                        BlastRecipeBuilder nuggetSmeltingBuilder = (BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().input(OrePrefix.dustTiny, material)).outputs(nuggetStack)).blastFurnaceTemp(metalMaterial.blastFurnaceTemperature).duration(Math.max(1, duration / 9))).EUt(120);
                        if (circuitRequiringMaterials.contains(material)) {
                            nuggetSmeltingBuilder.inputs(IntCircuitIngredient.getIntegratedCircuit(0));
                        }
                        nuggetSmeltingBuilder.buildAndRegister();
                    }
                    if (hasHotIngot) {
                        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder().input(OrePrefix.ingotHot, metalMaterial)).outputs(OreDictUnifier.get(OrePrefix.ingot, metalMaterial))).duration(metalMaterial.blastFurnaceTemperature / 16)).buildAndRegister();
                    }
                    if (metalMaterial.blastFurnaceTemperature <= 1000) {
                        ModHandler.addRCFurnaceRecipe(new UnificationEntry(dustPrefix, metalMaterial), ingotStack, duration);
                        ModHandler.addRCFurnaceRecipe(new UnificationEntry(OrePrefix.nugget, metalMaterial), nuggetStack, Math.max(1, duration / 9));
                    }
                }
            }
        } else if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE) && !material.hasFlag(DustMaterial.MatFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(dustPrefix, material)).outputs(OreDictUnifier.get(OrePrefix.plate, material))).buildAndRegister();
        }
    }

    public static void processSmallDust(OrePrefix orePrefix, DustMaterial material) {
        ItemStack smallDustStack = OreDictUnifier.get(orePrefix, material);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        ModHandler.addShapedRecipe(String.format("small_dust_disassembling_%s", material.toString()), GTUtility.copyAmount(4, smallDustStack), "  ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.dust, material));
        ModHandler.addShapedRecipe(String.format("small_dust_assembling_%s", material.toString()), dustStack, "XX", "XX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(orePrefix, material, 4)).inputs(new CountableIngredient(new IntCircuitIngredient(2), 0))).outputs(dustStack)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.UNPACKER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).inputs(new CountableIngredient(new IntCircuitIngredient(2), 0))).outputs(GTUtility.copyAmount(4, smallDustStack))).buildAndRegister();
    }

    public static void processTinyDust(OrePrefix orePrefix, DustMaterial material) {
        ItemStack tinyDustStack = OreDictUnifier.get(orePrefix, material);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        ModHandler.addShapedRecipe(String.format("tiny_dust_disassembling_%s", material.toString()), GTUtility.copyAmount(9, tinyDustStack), "X ", "  ", Character.valueOf('X'), new UnificationEntry(OrePrefix.dust, material));
        ModHandler.addShapedRecipe(String.format("tiny_dust_assembling_%s", material.toString()), dustStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(orePrefix, material, 9)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).outputs(dustStack)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.UNPACKER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).outputs(GTUtility.copyAmount(9, tinyDustStack))).buildAndRegister();
    }

    public static void processIngot(OrePrefix ingotPrefix, IngotMaterial material) {
        if (material.hasFlag(SolidMaterial.MatFlags.MORTAR_GRINDABLE)) {
            ModHandler.addShapedRecipe(String.format("mortar_grind_%s", material.toString()), OreDictUnifier.get(OrePrefix.dust, material), "X", "m", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
        }
        if (!material.hasFlag(DustMaterial.MatFlags.NO_SMASHING) && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("wrench_%s", material.toString()), MetaItems.WRENCH.getStackForm(material), "IhI", "III", " I ", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material));
        }
        if (material.hasFlag(SolidMaterial.MatFlags.GENERATE_ROD)) {
            ModHandler.addShapedRecipe(String.format("stick_%s", material.toString()), OreDictUnifier.get(OrePrefix.stick, material, 1), "f ", " X", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
            if (!material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(ingotPrefix, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD)).outputs(OreDictUnifier.get(OrePrefix.stick, material, 2))).duration((int)material.getAverageMass() * 2)).EUt(6 * MaterialRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
            }
        }
        if (material.shouldGenerateFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(ingotPrefix, material))).duration(20)).EUt(8)).buildAndRegister();
        }
        if (material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_INGOT)).outputs(OreDictUnifier.get(OrePrefix.ingot, material))).duration(10)).EUt(4 * MaterialRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE) && !material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            ItemStack plateStack = OreDictUnifier.get(OrePrefix.plate, material);
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(0).input(ingotPrefix, material)).outputs(plateStack)).EUt(24)).duration((int)material.getAverageMass())).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(ingotPrefix, material, 3)).outputs(GTUtility.copyAmount(2, plateStack))).EUt(16)).duration((int)(material.getAverageMass() * 2L))).buildAndRegister();
            int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(ingotPrefix, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_PLATE)).outputs(OreDictUnifier.get(OrePrefix.plate, material))).duration((int)material.getAverageMass())).EUt(8 * voltageMultiplier)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(ingotPrefix, material, 2)).notConsumable(MetaItems.SHAPE_MOLD_PLATE)).outputs(OreDictUnifier.get(OrePrefix.plate, material))).duration((int)material.getAverageMass() * 2)).EUt(2 * voltageMultiplier)).buildAndRegister();
            ModHandler.addShapedRecipe(String.format("plate_%s", material.toString()), plateStack, "h", "I", "I", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material));
            if (material.hasFlag(IngotMaterial.MatFlags.GENERATE_DENSE)) {
                ItemStack denseStack = OreDictUnifier.get(OrePrefix.plateDense, material);
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(ingotPrefix, material, 9)).outputs(denseStack)).circuitMeta(5).EUt(96)).duration((int)(material.getAverageMass() * 9L))).buildAndRegister();
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 9)).outputs(denseStack)).circuitMeta(5).EUt(96)).duration((int)(material.getAverageMass() * 2L))).buildAndRegister();
            }
        }
    }

    public static void processGem(OrePrefix gemPrefix, GemMaterial material) {
        OrePrefix prevPrefix;
        ItemStack prevStack;
        long materialAmount = gemPrefix.materialAmount;
        ItemStack crushedStack = OreDictUnifier.getDust(material, materialAmount);
        if (material.hasFlag(SolidMaterial.MatFlags.MORTAR_GRINDABLE)) {
            ModHandler.addShapedRecipe(String.format("gem_to_dust_%s_%s", new Object[]{material, gemPrefix}), crushedStack, "X", "m", Character.valueOf('X'), new UnificationEntry(gemPrefix, material));
        }
        ItemStack itemStack = prevStack = (prevPrefix = (OrePrefix)GTUtility.getItem(GEM_ORDER, GEM_ORDER.indexOf((Object)gemPrefix) - 1, null)) == null ? ItemStack.field_190927_a : OreDictUnifier.get(prevPrefix, material, 2);
        if (!prevStack.func_190926_b()) {
            ModHandler.addShapelessRecipe(String.format("gem_to_gem_%s_%s", new Object[]{prevPrefix, material}), prevStack, "h", new UnificationEntry(gemPrefix, material));
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(gemPrefix, material)).outputs(prevStack)).duration(20)).EUt(16)).buildAndRegister();
        }
    }

    public static void processNugget(OrePrefix orePrefix, SolidMaterial material) {
        ItemStack nuggetStack = OreDictUnifier.get(orePrefix, material);
        if (material instanceof IngotMaterial) {
            ItemStack ingotStack = OreDictUnifier.get(OrePrefix.ingot, material);
            ModHandler.addShapelessRecipe(String.format("nugget_disassembling_%s", material.toString()), GTUtility.copyAmount(9, nuggetStack), new UnificationEntry(OrePrefix.ingot, material));
            ModHandler.addShapedRecipe(String.format("nugget_assembling_%s", material.toString()), ingotStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.UNPACKER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).outputs(GTUtility.copyAmount(9, nuggetStack))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(orePrefix, material, 9)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).outputs(ingotStack)).buildAndRegister();
            if (material.shouldGenerateFluid()) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_NUGGET)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(orePrefix, material, 9))).duration((int)material.getAverageMass())).EUt(8)).buildAndRegister();
            }
        } else if (material instanceof GemMaterial) {
            ItemStack gemStack = OreDictUnifier.get(OrePrefix.gem, material);
            ModHandler.addShapelessRecipe(String.format("nugget_disassembling_%s", material.toString()), GTUtility.copyAmount(9, nuggetStack), new UnificationEntry(OrePrefix.gem, material));
            ModHandler.addShapedRecipe(String.format("nugget_assembling_%s", material.toString()), gemStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        }
    }

    public static void processFrame(OrePrefix framePrefix, SolidMaterial material) {
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD)) {
            boolean isWoodenFrame = ModHandler.isMaterialWood(material);
            ItemStack frameStack = OreDictUnifier.get(framePrefix, material, 4);
            ModHandler.addShapedRecipe(String.format("frame_%s", material), frameStack, "PPP", "SSS", isWoodenFrame ? "SsS" : "SwS", Character.valueOf('P'), new UnificationEntry(isWoodenFrame ? OrePrefix.plank : OrePrefix.plate, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material));
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 3)).input(OrePrefix.stick, material, 5)).circuitMeta(1).outputs(frameStack)).EUt(8)).duration(200)).buildAndRegister();
        }
    }

    public static void processBlock(OrePrefix blockPrefix, DustMaterial material) {
        ItemStack blockStack = OreDictUnifier.get(blockPrefix, material);
        long materialAmount = blockPrefix.getMaterialAmount(material);
        if (material.shouldGenerateFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(material.getFluid((int)(materialAmount * 144L / 3628800L)))).outputs(blockStack)).duration((int)material.getAverageMass())).EUt(8)).buildAndRegister();
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE)) {
            ItemStack plateStack = OreDictUnifier.get(OrePrefix.plate, material);
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(blockPrefix, material)).outputs(GTUtility.copyAmount((int)(materialAmount / 3628800L), plateStack))).duration((int)(material.getAverageMass() * 8L))).EUt(30)).buildAndRegister();
        }
        UnificationEntry blockEntry = material instanceof GemMaterial ? new UnificationEntry(OrePrefix.gem, material) : (material instanceof IngotMaterial ? new UnificationEntry(OrePrefix.ingot, material) : new UnificationEntry(OrePrefix.dust, material));
        ArrayList<UnificationEntry> result = new ArrayList<UnificationEntry>();
        int index = 0;
        while ((long)index < materialAmount / 3628800L) {
            result.add(blockEntry);
            ++index;
        }
        if (!material.hasFlag(DustMaterial.MatFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            ModHandler.addShapelessRecipe(String.format("block_compress_%s", material.toString()), blockStack, result.toArray());
            ModHandler.addShapelessRecipe(String.format("block_decompress_%s", material.toString()), GTUtility.copyAmount((int)(materialAmount / 3628800L), OreDictUnifier.get(blockEntry)), new UnificationEntry(blockPrefix, material));
            if (material instanceof IngotMaterial) {
                int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).notConsumable(MetaItems.SHAPE_EXTRUDER_BLOCK)).outputs(blockStack)).duration(10)).EUt(8 * voltageMultiplier)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).outputs(blockStack)).duration(5)).EUt(4 * voltageMultiplier)).buildAndRegister();
            }
        }
    }

    private static int getVoltageMultiplier(Material material) {
        return material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature >= 2800 ? 32 : 8;
    }
}

