/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import com.google.common.base.CaseFormat;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.CokeOvenRecipeBuilder;
import gregtech.api.recipes.builders.CutterRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.PBFRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockConcrete;
import gregtech.common.blocks.BlockGranite;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMineral;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneBlock;
import gregtech.common.blocks.wood.BlockGregLog;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.loaders.recipe.AssemblyLineRecipeLoader;
import gregtech.loaders.recipe.ChemistryRecipes;
import gregtech.loaders.recipe.FuelRecipes;
import gregtech.loaders.recipe.RecyclingRecipes;
import gregtech.loaders.recipe.WoodMachineRecipes;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MachineRecipeLoader {
    private static final MaterialStack[] solderingList = new MaterialStack[]{new MaterialStack(Materials.Tin, 2L), new MaterialStack(Materials.SolderingAlloy, 1L)};
    private static final MaterialStack[][] alloySmelterList = new MaterialStack[][]{{new MaterialStack(Materials.Copper, 3L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.Bronze, 4L)}, {new MaterialStack(Materials.Copper, 3L), new MaterialStack(Materials.Zinc, 1L), new MaterialStack(Materials.Brass, 4L)}, {new MaterialStack(Materials.Copper, 1L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Cupronickel, 2L)}, {new MaterialStack(Materials.Copper, 1L), new MaterialStack(Materials.Redstone, 4L), new MaterialStack(Materials.RedAlloy, 1L)}, {new MaterialStack(Materials.AnnealedCopper, 3L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.Bronze, 4L)}, {new MaterialStack(Materials.AnnealedCopper, 3L), new MaterialStack(Materials.Zinc, 1L), new MaterialStack(Materials.Brass, 4L)}, {new MaterialStack(Materials.AnnealedCopper, 1L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Cupronickel, 2L)}, {new MaterialStack(Materials.AnnealedCopper, 1L), new MaterialStack(Materials.Redstone, 4L), new MaterialStack(Materials.RedAlloy, 1L)}, {new MaterialStack(Materials.Iron, 1L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.TinAlloy, 2L)}, {new MaterialStack(Materials.WroughtIron, 1L), new MaterialStack(Materials.Tin, 1L), new MaterialStack(Materials.TinAlloy, 2L)}, {new MaterialStack(Materials.Iron, 2L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Invar, 3L)}, {new MaterialStack(Materials.WroughtIron, 2L), new MaterialStack(Materials.Nickel, 1L), new MaterialStack(Materials.Invar, 3L)}, {new MaterialStack(Materials.Tin, 9L), new MaterialStack(Materials.Antimony, 1L), new MaterialStack(Materials.SolderingAlloy, 10L)}, {new MaterialStack(Materials.Lead, 4L), new MaterialStack(Materials.Antimony, 1L), new MaterialStack(Materials.BatteryAlloy, 5L)}, {new MaterialStack(Materials.Gold, 1L), new MaterialStack(Materials.Silver, 1L), new MaterialStack(Materials.Electrum, 2L)}, {new MaterialStack(Materials.Magnesium, 1L), new MaterialStack(Materials.Aluminium, 2L), new MaterialStack(Materials.Magnalium, 3L)}};

    public static void init() {
        ChemistryRecipes.init();
        FuelRecipes.registerFuels();
        WoodMachineRecipes.init();
        RecyclingRecipes.init();
        AssemblyLineRecipeLoader.registerAssemblyLineRecipes();
        MachineRecipeLoader.registerCircuitRecipes();
        MachineRecipeLoader.registerCutterRecipes();
        MachineRecipeLoader.registerChemicalRecipes();
        MachineRecipeLoader.registerChemicalBathRecipes();
        MachineRecipeLoader.registerDecompositionRecipes();
        MachineRecipeLoader.registerBlastFurnaceRecipes();
        MachineRecipeLoader.registerAssemblerRecipes();
        MachineRecipeLoader.registerAlloyRecipes();
        MachineRecipeLoader.registerBendingCompressingRecipes();
        MachineRecipeLoader.registerCokeOvenRecipes();
        MachineRecipeLoader.registerFluidRecipes();
        MachineRecipeLoader.registerMixingCrystallizationRecipes();
        MachineRecipeLoader.registerPrimitiveBlastFurnaceRecipes();
        MachineRecipeLoader.registerRecyclingRecipes();
        MachineRecipeLoader.registerStoneBricksRecipes();
        MachineRecipeLoader.registerOrganicRecyclingRecipes();
    }

    private static void registerBendingCompressingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150432_aD, 2, Short.MAX_VALUE))).outputs(new ItemStack(Blocks.field_150403_cj))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Ice, 1)).outputs(new ItemStack(Blocks.field_150432_aD))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151015_O, 9))).outputs(new ItemStack(Blocks.field_150407_cf))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Fireclay)).outputs(MetaItems.COMPRESSED_FIRECLAY.getStackForm())).duration(100)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(100)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_CREDIT.getStackForm())).input(OrePrefix.plate, Materials.Cupronickel, 1)).outputs(MetaItems.CREDIT_CUPRONICKEL.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(100)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_CREDIT.getStackForm())).input(OrePrefix.plate, Materials.Brass, 1)).outputs(MetaItems.COIN_DOGE.getStackForm(4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.plate, Materials.Iron, 12)).outputs(new ItemStack(Items.field_151133_ar, 4))).duration(800)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.plate, Materials.WroughtIron, 12)).outputs(new ItemStack(Items.field_151133_ar, 4))).duration(800)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12).input(OrePrefix.plate, Materials.Iron, 2)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(200)).EUt(30)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 2)).notConsumable(MetaItems.SHAPE_EXTRUDER_CELL)).outputs(MetaItems.FLUID_CELL.getStackForm())).duration(200)).EUt(30)).buildAndRegister();
    }

    private static void registerPrimitiveBlastFurnaceRecipes() {
        PBFRecipeBuilder.start().input(OrePrefix.ingot, Materials.Iron).output(OreDictUnifier.get(OrePrefix.ingot, Materials.Steel)).duration(1500).fuelAmount(2).buildAndRegister();
        PBFRecipeBuilder.start().input(OrePrefix.block, Materials.Iron).output(OreDictUnifier.get(OrePrefix.block, Materials.Steel)).duration(13500).fuelAmount(18).buildAndRegister();
        PBFRecipeBuilder.start().input(OrePrefix.ingot, Materials.WroughtIron).output(OreDictUnifier.get(OrePrefix.ingot, Materials.Steel)).duration(600).fuelAmount(2).buildAndRegister();
        PBFRecipeBuilder.start().input(OrePrefix.block, Materials.WroughtIron).output(OreDictUnifier.get(OrePrefix.block, Materials.Steel)).duration(5600).fuelAmount(18).buildAndRegister();
    }

    private static void registerCokeOvenRecipes() {
        CokeOvenRecipeBuilder.start().input(OrePrefix.log, Materials.Wood).output(OreDictUnifier.get(OrePrefix.gem, Materials.Charcoal)).fluidOutput(Materials.Creosote.getFluid(250)).duration(900).buildAndRegister();
        CokeOvenRecipeBuilder.start().input(OrePrefix.gem, Materials.Coal).output(OreDictUnifier.get(OrePrefix.gem, Materials.Coke)).fluidOutput(Materials.Creosote.getFluid(500)).duration(900).buildAndRegister();
        CokeOvenRecipeBuilder.start().input(OrePrefix.block, Materials.Coal).output(OreDictUnifier.get(OrePrefix.block, Materials.Coke)).fluidOutput(Materials.Creosote.getFluid(4500)).duration(8100).buildAndRegister();
    }

    private static void registerStoneBricksRecipes() {
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.CONCRETE, BlockConcrete.ConcreteVariant.LIGHT_CONCRETE, BlockConcrete.ConcreteVariant.LIGHT_BRICKS);
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.CONCRETE, BlockConcrete.ConcreteVariant.DARK_CONCRETE, BlockConcrete.ConcreteVariant.DARK_BRICKS);
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.GRANITE, BlockGranite.GraniteVariant.BLACK_GRANITE, BlockGranite.GraniteVariant.BLACK_GRANITE_BRICKS);
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.GRANITE, BlockGranite.GraniteVariant.RED_GRANITE, BlockGranite.GraniteVariant.RED_GRANITE_BRICKS);
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.MINERAL, BlockMineral.MineralVariant.MARBLE, BlockMineral.MineralVariant.MARBLE_BRICKS);
        MachineRecipeLoader.registerBrickRecipe(MetaBlocks.MINERAL, BlockMineral.MineralVariant.BASALT, BlockMineral.MineralVariant.BASALT_BRICKS);
        MachineRecipeLoader.registerChiselingRecipes(MetaBlocks.CONCRETE);
        MachineRecipeLoader.registerChiselingRecipes(MetaBlocks.GRANITE);
        MachineRecipeLoader.registerChiselingRecipes(MetaBlocks.MINERAL);
    }

    private static void registerCircuitRecipes() {
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(9000)).EUt(120)).input(OrePrefix.dust, Materials.Silicon, 32)).input(OrePrefix.dustTiny, Materials.Gallium)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).outputs(MetaItems.SILICON_BOULE.getStackForm())).blastFurnaceTemp(1784).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(12000)).EUt(480)).input(OrePrefix.dust, Materials.Silicon, 64)).input(OrePrefix.dust, Materials.Glowstone, 8)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).fluidInputs(Materials.Nitrogen.getFluid(8000))).outputs(MetaItems.GLOWSTONE_BOULE.getStackForm())).blastFurnaceTemp(2484).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(1500)).EUt(1920)).input(OrePrefix.block, Materials.Silicon, 9)).input(OrePrefix.ingot, Materials.Naquadah)).inputs(new CountableIngredient(new IntCircuitIngredient(1), 0))).fluidInputs(Materials.Argon.getFluid(8000))).outputs(MetaItems.NAQUADAH_BOULE.getStackForm())).blastFurnaceTemp(5400).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(900)).EUt(120)).inputs(MetaItems.SILICON_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Red)).outputs(MetaItems.INTEGRATED_LOGIC_CIRCUIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Red)).outputs(MetaItems.INTEGRATED_LOGIC_CIRCUIT_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Red)).outputs(MetaItems.INTEGRATED_LOGIC_CIRCUIT_WAFER.getStackForm(8))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(900)).EUt(120)).inputs(MetaItems.SILICON_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Silver)).outputs(MetaItems.RANDOM_ACCESS_MEMORY_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Silver)).outputs(MetaItems.RANDOM_ACCESS_MEMORY_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Silver)).outputs(MetaItems.RANDOM_ACCESS_MEMORY_WAFER.getStackForm(8))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.LightBlue)).outputs(MetaItems.NAND_MEMORY_CHIP_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.LightBlue)).outputs(MetaItems.NAND_MEMORY_CHIP_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Lime)).outputs(MetaItems.NOR_MEMORY_CHIP_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Lime)).outputs(MetaItems.NOR_MEMORY_CHIP_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(900)).EUt(120)).inputs(MetaItems.SILICON_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(MetaItems.CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(MetaItems.CENTRAL_PROCESSING_UNIT_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(MetaItems.CENTRAL_PROCESSING_UNIT_WAFER.getStackForm(8))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Yellow)).outputs(MetaItems.SYSTEM_ON_CHIP_WAFER.getStackForm(2))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Orange)).outputs(MetaItems.ADVANCED_SYSTEM_ON_CHIP_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(500)).EUt(480)).inputs(MetaItems.GLOWSTONE_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Blue)).outputs(MetaItems.POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(200)).EUt(1920)).inputs(MetaItems.NAQUADAH_WAFER.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Blue)).outputs(MetaItems.POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(1200)).EUt(1920)).inputs(MetaItems.POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm())).input(OrePrefix.dust, Materials.IndiumGalliumPhosphide, 2)).fluidInputs(Materials.RedAlloy.getFluid(288))).outputs(MetaItems.HIGH_POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(400)).EUt(480)).inputs(MetaItems.CENTRAL_PROCESSING_UNIT_WAFER.getStackForm(), MetaItems.CARBON_FIBERS.getStackForm(16))).fluidInputs(Materials.Glowstone.getFluid(576))).outputs(MetaItems.NANO_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(400)).EUt(1920)).inputs(MetaItems.NANO_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm(), MetaItems.QUANTUM_EYE.getStackForm(2))).fluidInputs(Materials.GalliumArsenide.getFluid(288))).outputs(MetaItems.QBIT_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(600)).EUt(1920)).inputs(MetaItems.NANO_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).input(OrePrefix.cableGtSingle, MarkerMaterials.Tier.Superconductor, 8)).outputs(MetaItems.QBIT_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(200)).EUt(8)).inputs(MetaItems.SILICON_BOULE.getStackForm())).outputs(MetaItems.SILICON_WAFER.getStackForm(16))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(400)).EUt(64)).inputs(MetaItems.GLOWSTONE_BOULE.getStackForm())).outputs(MetaItems.GLOWSTONE_WAFER.getStackForm(32))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(800)).EUt(384)).inputs(MetaItems.NAQUADAH_BOULE.getStackForm())).outputs(MetaItems.NAQUADAH_WAFER.getStackForm(64))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.ADVANCED_SYSTEM_ON_CHIP_WAFER.getStackForm())).outputs(MetaItems.ADVANCED_SYSTEM_ON_CHIP.getStackForm(6))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.SYSTEM_ON_CHIP_WAFER.getStackForm())).outputs(MetaItems.SYSTEM_ON_CHIP.getStackForm(6))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.RANDOM_ACCESS_MEMORY_WAFER.getStackForm())).outputs(MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(32))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.QBIT_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).outputs(MetaItems.QBIT_CENTRAL_PROCESSING_UNIT.getStackForm(5))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm())).outputs(MetaItems.POWER_INTEGRATED_CIRCUIT.getStackForm(4))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.HIGH_POWER_INTEGRATED_CIRCUIT_WAFER.getStackForm())).outputs(MetaItems.HIGH_POWER_INTEGRATED_CIRCUIT.getStackForm(2))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.NOR_MEMORY_CHIP_WAFER.getStackForm())).outputs(MetaItems.NOR_MEMORY_CHIP.getStackForm(16))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.NAND_MEMORY_CHIP_WAFER.getStackForm())).outputs(MetaItems.NAND_MEMORY_CHIP.getStackForm(32))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).outputs(MetaItems.CENTRAL_PROCESSING_UNIT.getStackForm(8))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.INTEGRATED_LOGIC_CIRCUIT_WAFER.getStackForm())).outputs(MetaItems.INTEGRATED_LOGIC_CIRCUIT.getStackForm(8))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(600)).EUt(48)).inputs(MetaItems.NANO_CENTRAL_PROCESSING_UNIT_WAFER.getStackForm())).outputs(MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm(7))).buildAndRegister();
        for (MaterialStack stack : solderingList) {
            IngotMaterial material = (IngotMaterial)stack.material;
            int multiplier = (int)stack.amount;
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(8)).inputs(MetaItems.PHENOLIC_BOARD.getStackForm(), MetaItems.INTEGRATED_LOGIC_CIRCUIT.getStackForm(), MetaItems.RESISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.Copper)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.BASIC_ELECTRONIC_CIRCUIT_LV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(8)).inputs(MetaItems.PHENOLIC_BOARD.getStackForm(), MetaItems.INTEGRATED_LOGIC_CIRCUIT.getStackForm(), MetaItems.SMD_RESISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.Copper)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.BASIC_ELECTRONIC_CIRCUIT_LV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(60)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.CENTRAL_PROCESSING_UNIT.getStackForm(4), MetaItems.RESISTOR.getStackForm(4), MetaItems.CAPACITOR.getStackForm(4), MetaItems.TRANSISTOR.getStackForm(4))).input(OrePrefix.wireFine, Materials.Copper, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_PARTS_LV.getStackForm(4))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(60)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.CENTRAL_PROCESSING_UNIT.getStackForm(4), MetaItems.SMD_RESISTOR.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.SMD_TRANSISTOR.getStackForm(4))).input(OrePrefix.wireFine, Materials.Copper, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_PARTS_LV.getStackForm(4))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(600)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.SYSTEM_ON_CHIP.getStackForm(1))).input(OrePrefix.wireFine, Materials.Copper, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_PARTS_LV.getStackForm(4))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(16)).inputs(MetaItems.PHENOLIC_BOARD.getStackForm(), MetaItems.BASIC_ELECTRONIC_CIRCUIT_LV.getStackForm(3), MetaItems.RESISTOR.getStackForm(4))).input(OrePrefix.wireFine, Materials.Electrum, 8)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.GOOD_INTEGRATED_CIRCUIT_MV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(16)).inputs(MetaItems.PHENOLIC_BOARD.getStackForm(), MetaItems.BASIC_ELECTRONIC_CIRCUIT_LV.getStackForm(3), MetaItems.SMD_RESISTOR.getStackForm(4))).input(OrePrefix.wireFine, Materials.Electrum, 8)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.GOOD_INTEGRATED_CIRCUIT_MV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(60)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.RESISTOR.getStackForm(2), MetaItems.CAPACITOR.getStackForm(2), MetaItems.TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.RedAlloy, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_MV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(60)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.SMD_RESISTOR.getStackForm(2), MetaItems.SMD_CAPACITOR.getStackForm(2), MetaItems.SMD_TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.RedAlloy, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_MV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(2400)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.SYSTEM_ON_CHIP.getStackForm())).input(OrePrefix.wireFine, Materials.RedAlloy, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.ADVANCED_CIRCUIT_MV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(90)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.ADVANCED_CIRCUIT_MV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.RedAlloy, 12)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.PROCESSOR_ASSEMBLY_HV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(90)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.ADVANCED_CIRCUIT_MV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.RedAlloy, 12)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.PROCESSOR_ASSEMBLY_HV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(480)).inputs(MetaItems.EPOXY_BOARD.getStackForm(), MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.SMD_RESISTOR.getStackForm(2), MetaItems.SMD_CAPACITOR.getStackForm(2), MetaItems.SMD_TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.Electrum, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.NANO_PROCESSOR_HV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(9600)).inputs(MetaItems.EPOXY_BOARD.getStackForm(), MetaItems.SYSTEM_ON_CHIP.getStackForm())).input(OrePrefix.wireFine, Materials.Electrum, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.NANO_PROCESSOR_HV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(480)).inputs(MetaItems.EPOXY_BOARD.getStackForm(), MetaItems.NANO_PROCESSOR_HV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.Electrum, 6)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.NANO_PROCESSOR_ASSEMBLY_EV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(1960)).inputs(MetaItems.FIBER_BOARD.getStackForm(), MetaItems.QBIT_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.SMD_CAPACITOR.getStackForm(2), MetaItems.SMD_TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.Platinum, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.QUANTUM_PROCESSOR_EV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(32000)).inputs(MetaItems.FIBER_BOARD.getStackForm(), MetaItems.ADVANCED_SYSTEM_ON_CHIP.getStackForm())).input(OrePrefix.wireFine, Materials.Platinum, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.QUANTUM_PROCESSOR_EV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(1960)).inputs(MetaItems.FIBER_BOARD.getStackForm(), MetaItems.QUANTUM_PROCESSOR_EV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.Platinum, 6)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.DATA_CONTROL_CIRCUIT_IV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(7600)).inputs(MetaItems.MULTILAYER_FIBER_BOARD.getStackForm(), MetaItems.CRYSTAL_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.SMD_CAPACITOR.getStackForm(2), MetaItems.SMD_TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.NiobiumTitanium, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.CRYSTAL_PROCESSOR_IV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(31900)).inputs(MetaItems.MULTILAYER_FIBER_BOARD.getStackForm(), MetaItems.CRYSTAL_SYSTEM_ON_CHIP.getStackForm())).input(OrePrefix.wireFine, Materials.NiobiumTitanium, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.CRYSTAL_PROCESSOR_IV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(7600)).inputs(MetaItems.MULTILAYER_FIBER_BOARD.getStackForm(), MetaItems.CRYSTAL_PROCESSOR_IV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.NiobiumTitanium, 6)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.ENERGY_FLOW_CIRCUIT_LUV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(200)).EUt(32800)).inputs(MetaItems.WETWARE_BOARD.getStackForm(), MetaItems.CRYSTAL_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm(), MetaItems.SMD_CAPACITOR.getStackForm(2), MetaItems.SMD_TRANSISTOR.getStackForm(2))).input(OrePrefix.wireFine, Materials.YttriumBariumCuprate, 2)).fluidInputs(material.getFluid(72 * multiplier))).outputs(MetaItems.WETWARE_PROCESSOR_LUV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(34400)).inputs(MetaItems.WETWARE_BOARD.getStackForm(), MetaItems.WETWARE_PROCESSOR_LUV.getStackForm(2), MetaItems.SMALL_COIL.getStackForm(4), MetaItems.SMD_CAPACITOR.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.YttriumBariumCuprate, 6)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.WETWARE_PROCESSOR_ASSEMBLY_ZPM.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(34400)).inputs(MetaItems.WETWARE_BOARD.getStackForm(2), MetaItems.WETWARE_PROCESSOR_ASSEMBLY_ZPM.getStackForm(3), MetaItems.SMD_DIODE.getStackForm(4), MetaItems.NOR_MEMORY_CHIP.getStackForm(4), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.YttriumBariumCuprate, 6)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.WETWARE_SUPER_COMPUTER_UV.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(512)).EUt(1024)).inputs(MetaItems.FIBER_BOARD.getStackForm(), MetaItems.POWER_INTEGRATED_CIRCUIT.getStackForm(4), MetaItems.ENGRAVED_LAPOTRON_CHIP.getStackForm(18), MetaItems.NANO_CENTRAL_PROCESSING_UNIT.getStackForm())).input(OrePrefix.wireFine, Materials.Platinum, 16)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.ENERGY_LAPOTRONIC_ORB.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1024)).EUt(4096)).inputs(MetaItems.FIBER_BOARD.getStackForm(), MetaItems.HIGH_POWER_INTEGRATED_CIRCUIT.getStackForm(4), MetaItems.ENERGY_LAPOTRONIC_ORB.getStackForm(8), MetaItems.QBIT_CENTRAL_PROCESSING_UNIT.getStackForm())).input(OrePrefix.wireFine, Materials.Platinum, 16)).input(OrePrefix.plate, Materials.Europium, 4)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.ENERGY_LAPOTRONIC_ORB2.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(90)).inputs(MetaItems.PLASTIC_BOARD.getStackForm(), MetaItems.ADVANCED_CIRCUIT_MV.getStackForm(), MetaItems.NAND_MEMORY_CHIP.getStackForm(32), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4))).input(OrePrefix.wireFine, Materials.RedAlloy, 8)).input(OrePrefix.plate, Materials.Plastic, 4)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.TOOL_DATA_STICK.getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(1200)).inputs(MetaItems.EPOXY_BOARD.getStackForm(), MetaItems.NANO_PROCESSOR_HV.getStackForm(), MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(4), MetaItems.NOR_MEMORY_CHIP.getStackForm(32), MetaItems.NAND_MEMORY_CHIP.getStackForm(64))).input(OrePrefix.wireFine, Materials.Platinum, 32)).fluidInputs(material.getFluid(144 * multiplier))).outputs(MetaItems.TOOL_DATA_ORB.getStackForm())).buildAndRegister();
        }
        ModHandler.addShapedRecipe("vacuum_tube_wire", MetaItems.VACUUM_TUBE.getStackForm(), "PTP", "WWW", Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('T'), MetaItems.GLASS_TUBE.getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Copper));
        ModHandler.addShapedRecipe("vacuum_tube_wire_fine", MetaItems.VACUUM_TUBE.getStackForm(), "PTP", "WWW", Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('T'), MetaItems.GLASS_TUBE.getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.Copper));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(120)).EUt(8)).inputs(MetaItems.GLASS_TUBE.getStackForm(), new ItemStack(Items.field_151121_aF, 2))).input(OrePrefix.wireGtSingle, Materials.Copper, 2)).outputs(MetaItems.VACUUM_TUBE.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(120)).EUt(8)).inputs(MetaItems.GLASS_TUBE.getStackForm(), new ItemStack(Items.field_151121_aF, 2))).input(OrePrefix.wireFine, Materials.Copper, 2)).outputs(MetaItems.VACUUM_TUBE.getStackForm())).buildAndRegister();
        ModHandler.addShapedRecipe("basic_circuit", MetaItems.BASIC_CIRCUIT_LV.getStackForm(), "RPR", "VBV", "CCC", Character.valueOf('R'), MetaItems.RESISTOR.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('V'), MetaItems.VACUUM_TUBE.getStackForm(), Character.valueOf('B'), MetaItems.COATED_BOARD.getStackForm(), Character.valueOf('C'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.RedAlloy));
        ModHandler.addShapedRecipe("good_circuit", MetaItems.GOOD_INTEGRATED_CIRCUIT_MV.getStackForm(), "RCP", "CDC", "PCR", Character.valueOf('R'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.RedAlloy), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('C'), MetaItems.BASIC_CIRCUIT_LV.getStackForm(), Character.valueOf('D'), MetaItems.DIODE.getStackForm());
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(160)).EUt(8)).input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_MOLD_BALL)).outputs(MetaItems.GLASS_TUBE.getStackForm())).buildAndRegister();
        ModHandler.addShapedRecipe("resistor_wire", MetaItems.RESISTOR.getStackForm(3), " P ", "WCW", " P ", Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtSingle, Materials.Copper), Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Coal));
        ModHandler.addShapedRecipe("resistor_wire_fine", MetaItems.RESISTOR.getStackForm(3), " P ", "WCW", " P ", Character.valueOf('P'), new ItemStack(Items.field_151121_aF), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.Copper), Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Coal));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(160)).EUt(6)).input(OrePrefix.dust, Materials.Coal)).input(OrePrefix.wireFine, Materials.Copper, 4)).outputs(MetaItems.RESISTOR.getStackForm(12))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(96)).input(OrePrefix.plate, Materials.Plastic)).input(OrePrefix.foil, Materials.Aluminium, 2)).outputs(MetaItems.CAPACITOR.getStackForm(2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(24)).input(OrePrefix.plate, Materials.Silicon)).input(OrePrefix.foil, Materials.Tin, 6)).fluidInputs(Materials.Plastic.getFluid(144))).outputs(MetaItems.TRANSISTOR.getStackForm(8))).buildAndRegister();
        ModHandler.addShapedRecipe("diode", MetaItems.DIODE.getStackForm(4), "DG ", "TWT", "DG ", Character.valueOf('D'), "dyeBlack", Character.valueOf('G'), "paneGlass", Character.valueOf('T'), new UnificationEntry(OrePrefix.wireFine, Materials.Tin), Character.valueOf('W'), new UnificationEntry(OrePrefix.dustTiny, Materials.Gallium));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(48)).input(OrePrefix.wireFine, Materials.AnnealedCopper, 4)).input(OrePrefix.dustSmall, Materials.Gallium)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaItems.DIODE.getStackForm(16))).buildAndRegister();
        ModHandler.addShapedRecipe("small_coil_copper_steel", MetaItems.SMALL_COIL.getStackForm(2), "WWW", "WBW", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.Copper), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Steel));
        ModHandler.addShapedRecipe("small_coil_annealed_copper_steel", MetaItems.SMALL_COIL.getStackForm(2), "WWW", "WBW", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.AnnealedCopper), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Steel));
        ModHandler.addShapedRecipe("small_coil_copper_ferrite", MetaItems.SMALL_COIL.getStackForm(4), "WWW", "WBW", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.Copper), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.NickelZincFerrite));
        ModHandler.addShapedRecipe("small_coil_annealed_copper_ferrite", MetaItems.SMALL_COIL.getStackForm(4), "WWW", "WBW", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.wireFine, Materials.AnnealedCopper), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.NickelZincFerrite));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(8)).input(OrePrefix.wireFine, Materials.Copper)).input(OrePrefix.bolt, Materials.Steel)).outputs(MetaItems.SMALL_COIL.getStackForm(2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(8)).input(OrePrefix.wireFine, Materials.AnnealedCopper)).input(OrePrefix.bolt, Materials.Steel)).outputs(MetaItems.SMALL_COIL.getStackForm(2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(8)).input(OrePrefix.wireFine, Materials.Copper)).input(OrePrefix.bolt, Materials.NickelZincFerrite)).outputs(MetaItems.SMALL_COIL.getStackForm(4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(8)).input(OrePrefix.wireFine, Materials.AnnealedCopper)).input(OrePrefix.bolt, Materials.NickelZincFerrite)).outputs(MetaItems.SMALL_COIL.getStackForm(4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(96)).input(OrePrefix.dust, Materials.Carbon)).input(OrePrefix.wireFine, Materials.Electrum, 4)).fluidInputs(Materials.Plastic.getFluid(144))).outputs(MetaItems.SMD_RESISTOR.getStackForm(24))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(120)).input(OrePrefix.dustSmall, Materials.Gallium)).input(OrePrefix.wireFine, Materials.Platinum, 4)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaItems.SMD_DIODE.getStackForm(32))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(96)).input(OrePrefix.plate, Materials.Gallium)).input(OrePrefix.wireFine, Materials.AnnealedCopper, 6)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaItems.SMD_TRANSISTOR.getStackForm(32))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(120)).input(OrePrefix.foil, Materials.PolyvinylChloride, 4)).input(OrePrefix.foil, Materials.Aluminium)).fluidInputs(Materials.Plastic.getFluid(36))).outputs(MetaItems.SMD_CAPACITOR.getStackForm(16))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(60)).EUt(120)).input(OrePrefix.foil, Materials.SiliconeRubber, 4)).input(OrePrefix.foil, Materials.Aluminium)).fluidInputs(Materials.Plastic.getFluid(36))).outputs(MetaItems.SMD_CAPACITOR.getStackForm(16))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().duration(45)).EUt(40)).input(OrePrefix.dust, Materials.Carbon)).fluidInputs(Materials.Palladium.getFluid(1))).chancedOutput(MetaItems.CARBON_FIBERS.getStackForm(2), 8500, 750)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().duration(45)).EUt(40)).input(OrePrefix.dust, Materials.Carbon)).fluidInputs(Materials.Platinum.getFluid(1))).chancedOutput(MetaItems.CARBON_FIBERS.getStackForm(2), 8000, 750)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(4000)).EUt(120)).inputs(MetaItems.PLATE_IRIDIUM_ALLOY.getStackForm())).input(OrePrefix.plate, Materials.Beryllium, 32)).input(OrePrefix.plate, Materials.TungstenCarbide, 4)).fluidInputs(Materials.TinAlloy.getFluid(4608))).outputs(MetaItems.NEUTRON_REFLECTOR.getStackForm())).buildAndRegister();
        ModHandler.addShapedRecipe("coated_board", MetaItems.COATED_BOARD.getStackForm(3), " R ", "PPP", " R ", Character.valueOf('R'), MetaItems.RUBBER_DROP.getStackForm(), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Wood));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(160)).EUt(8)).input(OrePrefix.plate, Materials.Wood, 8)).inputs(MetaItems.RUBBER_DROP.getStackForm())).fluidInputs(Materials.Glue.getFluid(100))).outputs(MetaItems.COATED_BOARD.getStackForm(8))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(30)).EUt(8)).input(OrePrefix.dust, Materials.Wood)).notConsumable(MetaItems.SHAPE_MOLD_PLATE.getStackForm())).fluidInputs(Materials.Glue.getFluid(100))).outputs(MetaItems.PHENOLIC_BOARD.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(30)).EUt(8)).input(OrePrefix.dust, Materials.Wood)).notConsumable(MetaItems.SHAPE_MOLD_PLATE.getStackForm())).fluidInputs(Materials.BisphenolA.getFluid(100))).outputs(MetaItems.PHENOLIC_BOARD.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(600)).EUt(10)).input(OrePrefix.plate, Materials.Plastic)).input(OrePrefix.foil, Materials.Copper)).fluidInputs(Materials.SulfuricAcid.getFluid(125))).outputs(MetaItems.PLASTIC_BOARD.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(600)).EUt(10)).input(OrePrefix.plate, Materials.PolyvinylChloride)).input(OrePrefix.foil, Materials.Copper)).fluidInputs(Materials.SulfuricAcid.getFluid(125))).outputs(MetaItems.PLASTIC_BOARD.getStackForm(2))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(600)).EUt(10)).input(OrePrefix.plate, Materials.Polytetrafluoroethylene)).input(OrePrefix.foil, Materials.Copper)).fluidInputs(Materials.SulfuricAcid.getFluid(125))).outputs(MetaItems.PLASTIC_BOARD.getStackForm(4))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).EUt(10)).input(OrePrefix.plate, Materials.Epoxid)).input(OrePrefix.foil, Materials.Copper)).fluidInputs(Materials.SulfuricAcid.getFluid(125))).outputs(MetaItems.EPOXY_BOARD.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).EUt(10)).input(OrePrefix.plate, Materials.ReinforcedEpoxyResin)).input(OrePrefix.foil, Materials.Copper)).fluidInputs(Materials.SulfuricAcid.getFluid(125))).outputs(MetaItems.FIBER_BOARD.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(100)).EUt(480)).inputs(MetaItems.FIBER_BOARD.getStackForm())).input(OrePrefix.foil, Materials.Electrum, 16)).fluidInputs(Materials.SulfuricAcid.getFluid(250))).outputs(MetaItems.MULTILAYER_FIBER_BOARD.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(400)).EUt(480)).inputs(MetaItems.MULTILAYER_FIBER_BOARD.getStackForm())).input(OrePrefix.circuit, MarkerMaterials.Tier.Good)).fluidInputs(Materials.Polystyrene.getFluid(144))).outputs(MetaItems.WETWARE_BOARD.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(100)).EUt(32000)).inputs(MetaItems.CRYSTAL_CENTRAL_PROCESSING_UNIT.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Blue)).outputs(MetaItems.CRYSTAL_SYSTEM_ON_CHIP.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(100)).EUt(7600)).inputs(MetaItems.ENGRAVED_CRYSTAL_CHIP.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Lime)).outputs(MetaItems.CRYSTAL_CENTRAL_PROCESSING_UNIT.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().duration(256)).EUt(480)).inputs(MetaItems.LAPOTRON_CRYSTAL.getStackForm())).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.Blue)).outputs(MetaItems.ENGRAVED_LAPOTRON_CHIP.getStackForm(3))).buildAndRegister();
        ModHandler.addShapelessRecipe("reinforcing_epoxy_resin_by_glass", OreDictUnifier.get(OrePrefix.dust, Materials.ReinforcedEpoxyResin), new UnificationEntry(OrePrefix.dust, Materials.Epoxid), MetaItems.GLASS_FIBER.getStackForm());
        ModHandler.addShapelessRecipe("reinforcing_epoxy_resin_by_carbon", OreDictUnifier.get(OrePrefix.dust, Materials.ReinforcedEpoxyResin), new UnificationEntry(OrePrefix.dust, Materials.Epoxid), MetaItems.CARBON_FIBERS.getStackForm());
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(240)).EUt(16)).inputs(MetaItems.GLASS_FIBER.getStackForm())).fluidInputs(Materials.Epoxid.getFluid(144))).outputs(OreDictUnifier.get(OrePrefix.plate, Materials.ReinforcedEpoxyResin))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(240)).EUt(16)).inputs(MetaItems.CARBON_FIBERS.getStackForm())).fluidInputs(Materials.Epoxid.getFluid(144))).outputs(OreDictUnifier.get(OrePrefix.plate, Materials.ReinforcedEpoxyResin))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().duration(160)).EUt(96)).input(OrePrefix.ingot, Materials.BorosilicateGlass)).notConsumable(MetaItems.SHAPE_EXTRUDER_WIRE.getStackForm())).outputs(MetaItems.GLASS_FIBER.getStackForm(8))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(900)).EUt(480)).blastFurnaceTemp(5000).input(OrePrefix.gemExquisite, Materials.Emerald)).input(OrePrefix.plate, Materials.Emerald, 10)).fluidInputs(Materials.Helium.getFluid(5000))).outputs(MetaItems.ENGRAVED_CRYSTAL_CHIP.getStackForm(10))).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(900)).EUt(480)).blastFurnaceTemp(5000).input(OrePrefix.gemExquisite, Materials.Olivine)).input(OrePrefix.plate, Materials.Olivine, 10)).fluidInputs(Materials.Helium.getFluid(5000))).outputs(MetaItems.ENGRAVED_CRYSTAL_CHIP.getStackForm(10))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(30)).EUt(4)).input(OrePrefix.dust, Materials.Tantalum)).input(OrePrefix.foil, Materials.Manganese)).fluidInputs(Materials.Plastic.getFluid(144))).outputs(MetaItems.BATTERY_RE_ULV_TANTALUM.getStackForm(8))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(480)).EUt(384)).input(OrePrefix.gem, Materials.EnderEye, 1)).fluidInputs(Materials.Plutonium.getFluid(288))).outputs(MetaItems.QUANTUM_EYE.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(1920)).EUt(384)).input(OrePrefix.gem, Materials.NetherStar, 1)).fluidInputs(Materials.Plutonium.getFluid(1152))).outputs(MetaItems.QUANTUM_STAR.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().duration(480)).EUt(7680)).input(OrePrefix.gem, Materials.NetherStar, 1)).fluidInputs(Materials.Darmstadtium.getFluid(288))).outputs(MetaItems.GRAVI_STAR.getStackForm())).buildAndRegister();
    }

    private static void registerMixingCrystallizationRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Stone, 1)).fluidInputs(Materials.Lubricant.getFluid(20), ModHandler.getWater(1000))).fluidOutputs(Materials.DrillingFluid.getFluid(5000))).duration(64)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Clay, 1)).input(OrePrefix.dust, Materials.Stone, 3)).fluidInputs(Materials.Water.getFluid(500))).fluidOutputs(Materials.Concrete.getFluid(576))).duration(20)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().inputs(MetaBlocks.CONCRETE.getItemVariant(BlockConcrete.ConcreteVariant.LIGHT_CONCRETE, StoneBlock.ChiselingVariant.NORMAL))).fluidInputs(Materials.Water.getFluid(144))).outputs(MetaBlocks.CONCRETE.getItemVariant(BlockConcrete.ConcreteVariant.DARK_CONCRETE, StoneBlock.ChiselingVariant.NORMAL))).duration(12)).EUt(4)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(64)).EUt(16)).fluidInputs(Materials.Water.getFluid(1000))).input("sand", 2)).input(OrePrefix.dust, Materials.Stone, 6)).input(OrePrefix.dust, Materials.Flint)).fluidOutputs(Materials.ConstructionFoam.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(1200)).EUt(16)).input(OrePrefix.dust, Materials.Ruby, 9)).input(OrePrefix.dust, Materials.Redstone, 9)).outputs(MetaItems.ENERGIUM_DUST.getStackForm(9))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(MetaItems.ENERGIUM_DUST.getStackForm(9))).fluidInputs(Materials.Water.getFluid(1800))).outputs(MetaItems.ENERGY_CRYSTAL.getStackForm())).duration(2000)).EUt(120)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(MetaItems.ENERGIUM_DUST.getStackForm(9))).fluidInputs(ModHandler.getDistilledWater(1800))).outputs(MetaItems.ENERGY_CRYSTAL.getStackForm())).duration(1500)).EUt(120)).buildAndRegister();
    }

    private static void registerOrganicRecyclingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(800)).EUt(3)).input("treeSapling", 1)).fluidInputs(Materials.Water.getFluid(100))).fluidOutputs(Materials.Biomass.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack(Items.field_151174_bG))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack(Items.field_151172_bF))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack((Block)Blocks.field_150434_aF))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack(Items.field_151120_aE))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack((Block)Blocks.field_150338_P))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack((Block)Blocks.field_150337_Q))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(160)).EUt(3)).inputs(new ItemStack(Items.field_185164_cV))).fluidInputs(Materials.Water.getFluid(20))).fluidOutputs(Materials.Biomass.getFluid(20))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(144)).EUt(5)).inputs(new ItemStack(Items.field_151075_bm))).fluidOutputs(Materials.Methane.getFluid(18))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(144)).EUt(5)).inputs(new ItemStack((Block)Blocks.field_150338_P))).fluidOutputs(Materials.Methane.getFluid(18))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(144)).EUt(5)).inputs(new ItemStack((Block)Blocks.field_150337_Q))).fluidOutputs(Materials.Methane.getFluid(18))).buildAndRegister();
        if (ConfigHolder.addFoodMethaneRecipes) {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                if (!(item instanceof ItemFood)) continue;
                ItemFood itemFood = (ItemFood)item;
                Collection<ItemStack> subItems = ModHandler.getAllSubItems(new ItemStack(item, 1, Short.MAX_VALUE));
                for (ItemStack itemStack : subItems) {
                    int healAmount = itemFood.func_150905_g(itemStack);
                    float saturationModifier = itemFood.func_150906_h(itemStack);
                    if (healAmount <= 0) continue;
                    FluidStack outputStack = Materials.Methane.getFluid(Math.round((float)(9 * healAmount) * (1.0f + saturationModifier)));
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(144)).EUt(5)).inputs(itemStack)).fluidOutputs(outputStack)).buildAndRegister();
                }
            }
        }
    }

    private static void registerChemicalRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder().duration(50)).fluidInputs(Materials.Water.getFluid(1000))).fluidOutputs(Materials.Ice.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder().duration(400)).fluidInputs(Materials.Air.getFluid(4000))).fluidOutputs(Materials.LiquidAir.getFluid(4000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(500)).EUt(2)).fluidInputs(Materials.NitricAcid.getFluid(1000), Materials.SulfuricAcid.getFluid(1000))).fluidOutputs(Materials.NitrationMixture.getFluid(2000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BREWING_RECIPES.recipeBuilder().duration(1440)).EUt(3)).inputs(MetaItems.PLANT_BALL.getStackForm())).fluidInputs(Materials.Water.getFluid(180))).fluidOutputs(Materials.Biomass.getFluid(180))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FERMENTING_RECIPES.recipeBuilder().duration(150)).EUt(2)).fluidInputs(Materials.Biomass.getFluid(100))).fluidOutputs(Materials.FermentedBiomass.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(140)).EUt(192)).inputs(new ItemStack(Items.field_151102_aT))).input(OrePrefix.dustTiny, Materials.Plastic, 1)).fluidInputs(Materials.Toluene.getFluid(133))).outputs(MetaItems.GELLED_TOLUENE.getStackForm(2))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(320)).fluidInputs(Materials.HydrogenSulfide.getFluid(2000), ModHandler.getWater(2000))).fluidOutputs(Materials.SulfuricAcid.getFluid(3000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(640)).input(OrePrefix.dust, Materials.Saltpeter, 1)).fluidInputs(Materials.Naphtha.getFluid(576))).outputs(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Potassium, 1))).fluidOutputs(Materials.Polycaprolactam.getFluid(1296))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(240)).EUt(96)).input(OrePrefix.dust, Materials.Silicon, 1)).fluidInputs(Materials.Epichlorhydrin.getFluid(144))).fluidOutputs(Materials.Silicone.getFluid(144))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(240)).EUt(30)).fluidInputs(Materials.Epichlorhydrin.getFluid(144), Materials.Naphtha.getFluid(3000), Materials.NitrogenDioxide.getFluid(1000))).fluidOutputs(Materials.Epoxid.getFluid(288))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().duration(1500)).EUt(30)).fluidInputs(Materials.Water.getFluid(3000))).fluidOutputs(Materials.Hydrogen.getFluid(2000), Materials.Oxygen.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().duration(1500)).EUt(30)).fluidInputs(ModHandler.getDistilledWater(3000))).fluidOutputs(Materials.Hydrogen.getFluid(2000), Materials.Oxygen.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151100_aR, 3))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Calcium, 1))).duration(96)).EUt(26)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150354_m, 8))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.SiliconDioxide, 1))).duration(500)).EUt(25)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROLYZER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Graphite, 1)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Carbon, 4))).duration(100)).EUt(26)).buildAndRegister();
        for (FluidMaterial material : new FluidMaterial[]{Materials.Water, Materials.DistilledWater}) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).input(OrePrefix.dust, Materials.NetherQuartz, 3)).input(OrePrefix.dust, Materials.Sodium, 1)).fluidInputs(material.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.gem, Materials.NetherQuartz, 3))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).input(OrePrefix.dust, Materials.CertusQuartz, 3)).input(OrePrefix.dust, Materials.Sodium, 1)).fluidInputs(material.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.gem, Materials.CertusQuartz, 3))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).input(OrePrefix.dust, Materials.Quartzite, 3)).input(OrePrefix.dust, Materials.Sodium, 1)).fluidInputs(material.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.gem, Materials.Quartzite, 3))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(1000)).input(OrePrefix.dust, Materials.Uraninite, 1)).input(OrePrefix.dust, Materials.Aluminium, 1)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Uranium, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(1000)).input(OrePrefix.dust, Materials.Uraninite, 1)).input(OrePrefix.dust, Materials.Magnesium, 1)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Uranium, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(500)).input(OrePrefix.dust, Materials.Calcium, 1)).input(OrePrefix.dust, Materials.Carbon, 1)).fluidInputs(Materials.Oxygen.getFluid(3000))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Calcite, 5))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(1150)).input(OrePrefix.dust, Materials.Sulfur, 1)).fluidInputs(Materials.Water.getFluid(2000))).fluidOutputs(Materials.SulfuricAcid.getFluid(3000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).EUt(30)).input(OrePrefix.crushedPurified, Materials.Chalcopyrite)).fluidInputs(Materials.NitricAcid.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.dustTiny, Materials.PlatinumGroupSludge))).fluidOutputs(Materials.CopperSulfateSolution.getFluid(9000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).EUt(30)).input(OrePrefix.crushedPurified, Materials.Pentlandite)).fluidInputs(Materials.NitricAcid.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.dustTiny, Materials.PlatinumGroupSludge))).fluidOutputs(Materials.NickelSulfateSolution.getFluid(9000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(80)).EUt(30)).input(OrePrefix.dust, Materials.Quicklime)).fluidInputs(Materials.CarbonDioxide.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Calcite))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(80)).EUt(30)).input(OrePrefix.dust, Materials.Magnesia)).fluidInputs(Materials.CarbonDioxide.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Magnesite))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(240)).EUt(30)).input(OrePrefix.dust, Materials.Calcite)).notConsumable(new IntCircuitIngredient(1))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Quicklime))).fluidOutputs(Materials.CarbonDioxide.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(240)).EUt(30)).input(OrePrefix.dust, Materials.Magnesite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Magnesia))).fluidOutputs(Materials.CarbonDioxide.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(8000)).input(OrePrefix.dust, Materials.Sulfur, 1)).input(OrePrefix.dust, Materials.Sodium, 1)).fluidInputs(Materials.Oxygen.getFluid(4000))).fluidOutputs(Materials.SodiumPersulfate.getFluid(6000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(2700)).input(OrePrefix.dust, Materials.Carbon, 1)).fluidInputs(Materials.Water.getFluid(2000), Materials.Nitrogen.getFluid(1000))).fluidOutputs(Materials.Glyceryl.getFluid(4000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(600)).EUt(16)).input(OrePrefix.dust, Materials.RawRubber, 9)).input(OrePrefix.dust, Materials.Sulfur, 1)).fluidOutputs(Materials.Rubber.getFluid(1296))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).inputs(new ItemStack(Items.field_151127_ba, 1, Short.MAX_VALUE))).input(OrePrefix.nugget, Materials.Gold, 8)).outputs(new ItemStack(Items.field_151060_bw))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).inputs(new ItemStack(Items.field_151172_bF, 1, Short.MAX_VALUE))).input(OrePrefix.nugget, Materials.Gold, 8)).outputs(new ItemStack(Items.field_151150_bK))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).inputs(new ItemStack(Items.field_151034_e, 1, Short.MAX_VALUE))).input(OrePrefix.ingot, Materials.Gold, 8)).outputs(new ItemStack(Items.field_151153_ao))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(50)).inputs(new ItemStack(Items.field_151034_e, 1, Short.MAX_VALUE))).input(OrePrefix.block, Materials.Gold, 8)).outputs(new ItemStack(Items.field_151153_ao, 1, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder().duration(200)).EUt(24)).inputs(MetaItems.GELLED_TOLUENE.getStackForm(4))).fluidInputs(Materials.SulfuricAcid.getFluid(250))).outputs(new ItemStack(Blocks.field_150335_W))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().duration(80)).EUt(48)).input(OrePrefix.ingot, Materials.Polycaprolactam, 1)).outputs(new ItemStack(Items.field_151007_F, 32))).buildAndRegister();
    }

    private static void registerAlloyRecipes() {
        for (MaterialStack[] stack : alloySmelterList) {
            if (stack[0].material instanceof IngotMaterial) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.ingot, stack[0].material, (int)stack[0].amount)).input(OrePrefix.dust, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            if (stack[1].material instanceof IngotMaterial) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.dust, stack[0].material, (int)stack[0].amount)).input(OrePrefix.ingot, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            if (stack[0].material instanceof IngotMaterial && stack[1].material instanceof IngotMaterial) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.ingot, stack[0].material, (int)stack[0].amount)).input(OrePrefix.ingot, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)stack[2].amount * 50)).EUt(16)).input(OrePrefix.dust, stack[0].material, (int)stack[0].amount)).input(OrePrefix.dust, stack[1].material, (int)stack[1].amount)).outputs(OreDictUnifier.get(OrePrefix.ingot, stack[2].material, (int)stack[2].amount))).buildAndRegister();
        }
        for (OrePrefix prefix : Arrays.asList(OrePrefix.dust, OrePrefix.dustSmall, OrePrefix.dustTiny)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(800L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Boron, 1)).input(prefix, Materials.Glass, 7)).outputs(OreDictUnifier.getDust(Materials.BorosilicateGlass, 8L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(100L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Indium, 1)).input(prefix, Materials.Gallium, 1)).input(prefix, Materials.Phosphorus, 1)).outputs(OreDictUnifier.getDust(Materials.IndiumGalliumPhosphide, 3L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(600L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Nickel, 1)).input(prefix, Materials.Zinc, 1)).input(prefix, Materials.Iron, 4)).outputs(OreDictUnifier.getDust(Materials.FerriteMixture, 6L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(100L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.EnderPearl, 1)).input(prefix, Materials.Blaze, 1)).outputs(OreDictUnifier.getDust(Materials.EnderEye, prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(200L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Gold, 1)).input(prefix, Materials.Silver, 1)).outputs(OreDictUnifier.getDust(Materials.Electrum, 2L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(300L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Iron, 2)).input(prefix, Materials.Nickel, 1)).outputs(OreDictUnifier.getDust(Materials.Invar, 3L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(900L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Iron, 4)).input(prefix, Materials.Invar, 3)).input(prefix, Materials.Manganese, 1)).input(prefix, Materials.Chrome, 1)).outputs(OreDictUnifier.getDust(Materials.StainlessSteel, 9L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(300L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Iron, 1)).input(prefix, Materials.Aluminium, 1)).input(prefix, Materials.Chrome, 1)).outputs(OreDictUnifier.getDust(Materials.Kanthal, 3L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(600L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 3)).input(prefix, Materials.Barium, 2)).input(prefix, Materials.Yttrium, 1)).outputs(OreDictUnifier.getDust(Materials.YttriumBariumCuprate, 6L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(400L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 3)).input(prefix, Materials.Zinc, 1)).outputs(OreDictUnifier.getDust(Materials.Brass, 4L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(400L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 3)).input(prefix, Materials.Tin, 1)).outputs(OreDictUnifier.getDust(Materials.Bronze, 4L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(200L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 1)).input(prefix, Materials.Nickel, 1)).outputs(OreDictUnifier.getDust(Materials.Cupronickel, 2L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(500L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 1)).input(prefix, Materials.Gold, 4)).outputs(OreDictUnifier.getDust(Materials.RoseGold, 5L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(500L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 1)).input(prefix, Materials.Silver, 4)).outputs(OreDictUnifier.getDust(Materials.SterlingSilver, 5L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(500L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Copper, 3)).input(prefix, Materials.Electrum, 2)).outputs(OreDictUnifier.getDust(Materials.BlackBronze, 5L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(500L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Bismuth, 1)).input(prefix, Materials.Brass, 4)).outputs(OreDictUnifier.getDust(Materials.BismuthBronze, 5L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(500L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.BlackBronze, 1)).input(prefix, Materials.Nickel, 1)).input(prefix, Materials.Steel, 3)).outputs(OreDictUnifier.getDust(Materials.BlackSteel, 5L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(800L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.SterlingSilver, 1)).input(prefix, Materials.BismuthBronze, 1)).input(prefix, Materials.BlackSteel, 4)).input(prefix, Materials.Steel, 2)).outputs(OreDictUnifier.getDust(Materials.RedSteel, 8L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(800L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.RoseGold, 1)).input(prefix, Materials.Brass, 1)).input(prefix, Materials.BlackSteel, 4)).input(prefix, Materials.Steel, 2)).outputs(OreDictUnifier.getDust(Materials.BlueSteel, 8L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(900L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Cobalt, 5)).input(prefix, Materials.Chrome, 2)).input(prefix, Materials.Nickel, 1)).input(prefix, Materials.Molybdenum, 1)).outputs(OreDictUnifier.getDust(Materials.Ultimet, 9L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(900L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Brass, 7)).input(prefix, Materials.Aluminium, 1)).input(prefix, Materials.Cobalt, 1)).outputs(OreDictUnifier.getDust(Materials.CobaltBrass, 9L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(400L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Saltpeter, 2)).input(prefix, Materials.Sulfur, 1)).input(prefix, Materials.Coal, 1)).outputs(OreDictUnifier.getDust(Materials.Gunpowder, 4L * prefix.materialAmount))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration((int)(300L * prefix.materialAmount / 3628800L))).EUt(8)).input(prefix, Materials.Saltpeter, 2)).input(prefix, Materials.Sulfur, 1)).input(prefix, Materials.Charcoal, 1)).outputs(OreDictUnifier.getDust(Materials.Gunpowder, 3L * prefix.materialAmount))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(MetaItems.INGOT_MIXED_METAL.getStackForm())).outputs(MetaItems.ADVANCED_ALLOY_PLATE.getStackForm())).buildAndRegister();
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder().inputs(MetaItems.INGOT_IRIDIUM_ALLOY.getStackForm())).outputs(MetaItems.PLATE_IRIDIUM_ALLOY.getStackForm())).explosivesAmount(8).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(MetaItems.CARBON_MESH.getStackForm())).outputs(MetaItems.CARBON_PLATE.getStackForm())).buildAndRegister();
    }

    private static void registerAssemblerRecipes() {
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            String colorName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumDyeColor.func_176610_l());
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(MetaItems.SPRAY_EMPTY.getStackForm())).input("dye" + colorName, 1)).outputs(MetaItems.SPRAY_CAN_DYES[enumDyeColor.func_176765_a()].getStackForm())).EUt(8)).duration(200)).buildAndRegister();
        }
        for (IngotMaterial ingotMaterial : new IngotMaterial[]{Materials.YttriumBariumCuprate, Materials.NiobiumTitanium, Materials.VanadiumGallium}) {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, ingotMaterial, 3)).input(OrePrefix.plate, Materials.TungstenSteel, 3)).inputs(MetaItems.ELECTRIC_PUMP_LV.getStackForm())).fluidInputs(Materials.Nitrogen.getFluid(2000))).outputs(OreDictUnifier.get(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor, 3))).duration(20)).EUt(512)).buildAndRegister();
        }
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(4096)).EUt(4096)).inputs(MetaItems.ENERGY_LAPOTRONIC_ORB2.getStackForm(8))).input(OrePrefix.plate, Materials.Darmstadtium, 16)).outputs(MetaItems.ZPM2.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Rubber, 2)).input(OrePrefix.plate, Materials.Aluminium, 2)).outputs(MetaItems.COVER_SHUTTER.getStackForm(4))).EUt(16)).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Aluminium, 2)).input(OrePrefix.dust, Materials.Redstone)).outputs(MetaItems.COVER_MACHINE_CONTROLLER.getStackForm(1))).EUt(16)).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1800)).EUt(30)).input(OrePrefix.dust, Materials.EnderPearl, 1)).input(OrePrefix.circuit, MarkerMaterials.Tier.Basic, 4)).fluidInputs(Materials.Osmium.getFluid(288))).outputs(MetaItems.FIELD_GENERATOR_LV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1800)).EUt(120)).input(OrePrefix.dust, Materials.EnderEye, 1)).input(OrePrefix.circuit, MarkerMaterials.Tier.Good, 4)).fluidInputs(Materials.Osmium.getFluid(576))).outputs(MetaItems.FIELD_GENERATOR_MV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1800)).EUt(480)).inputs(MetaItems.QUANTUM_EYE.getStackForm())).input(OrePrefix.circuit, MarkerMaterials.Tier.Advanced, 4)).fluidInputs(Materials.Osmium.getFluid(1152))).outputs(MetaItems.FIELD_GENERATOR_HV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1800)).EUt(1920)).input(OrePrefix.dust, Materials.NetherStar, 1)).input(OrePrefix.circuit, MarkerMaterials.Tier.Elite, 4)).fluidInputs(Materials.Osmium.getFluid(2304))).outputs(MetaItems.FIELD_GENERATOR_EV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1800)).EUt(7680)).inputs(MetaItems.QUANTUM_STAR.getStackForm())).input(OrePrefix.circuit, MarkerMaterials.Tier.Master, 4)).fluidInputs(Materials.Osmium.getFluid(4608))).outputs(MetaItems.FIELD_GENERATOR_IV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(480)).EUt(240)).input(OrePrefix.dust, Materials.Graphite, 8)).input(OrePrefix.foil, Materials.Silicon, 1)).fluidInputs(Materials.Glue.getFluid(250))).outputs(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Graphene, 1))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).inputs(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE))).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 4))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.Gold, 2)).outputs(new ItemStack(Blocks.field_150445_bS, 1))).circuitMeta(2).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.Iron, 2)).outputs(new ItemStack(Blocks.field_150443_bT, 1))).circuitMeta(2).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.Iron, 6)).outputs(new ItemStack(Items.field_151139_aw, 3))).circuitMeta(6).duration(600)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.Iron, 7)).outputs(new ItemStack(Items.field_151066_bu, 1))).circuitMeta(7).duration(700)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.stick, Materials.Iron, 3)).outputs(new ItemStack(Blocks.field_150411_aY, 4))).circuitMeta(3).duration(300)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.WroughtIron, 2)).outputs(new ItemStack(Blocks.field_150443_bT, 1))).circuitMeta(2).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.WroughtIron, 6)).outputs(new ItemStack(Items.field_151139_aw, 3))).circuitMeta(6).duration(600)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.plate, Materials.WroughtIron, 7)).outputs(new ItemStack(Items.field_151066_bu, 1))).circuitMeta(7).duration(700)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.stick, Materials.WroughtIron, 3)).outputs(new ItemStack(Blocks.field_150411_aY, 4))).circuitMeta(3).duration(300)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.stick, Materials.Wood, 3)).outputs(new ItemStack(Blocks.field_180407_aO, 1))).circuitMeta(3).duration(300)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.stick, Materials.Wood, 2)).input(OrePrefix.ring, Materials.Iron, 2)).outputs(new ItemStack((Block)Blocks.field_150479_bC, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.stick, Materials.Wood, 2)).input(OrePrefix.ring, Materials.WroughtIron, 2)).outputs(new ItemStack((Block)Blocks.field_150479_bC, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Items.field_151007_F, 3, Short.MAX_VALUE))).input(OrePrefix.stick, Materials.Wood, 3)).outputs(new ItemStack((Item)Items.field_151031_f, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150348_b))).outputs(new ItemStack(Blocks.field_150417_aV, 1, 0))).circuitMeta(4).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150322_A))).outputs(new ItemStack(Blocks.field_150322_A, 1, 2))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150322_A, 1, 1))).outputs(new ItemStack(Blocks.field_150322_A, 1, 0))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150322_A, 1, 2))).outputs(new ItemStack(Blocks.field_150322_A, 1, 0))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.WroughtIron, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV))).circuitMeta(8).duration(25)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Steel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Aluminium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.StainlessSteel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Titanium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.TungstenSteel, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Chrome, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Iridium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Osmium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).circuitMeta(8).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Darmstadtium, 8)).outputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX))).circuitMeta(8).duration(50)).buildAndRegister();
        for (BlockWireCoil.CoilType coilType : BlockWireCoil.CoilType.values()) {
            if (coilType.getMaterial() == null) continue;
            ItemStack outputStack = MetaBlocks.WIRE_COIL.getItemVariant(coilType);
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().circuitMeta(8).input(OrePrefix.wireGtDouble, coilType.getMaterial(), 8)).outputs(outputStack)).duration(50)).EUt(16)).buildAndRegister();
        }
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Invar, 6)).input(OrePrefix.frameGt, Materials.Invar, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Steel, 6)).input(OrePrefix.frameGt, Materials.Steel, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STEEL_SOLID, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Aluminium, 6)).input(OrePrefix.frameGt, Materials.Aluminium, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.TungstenSteel, 6)).input(OrePrefix.frameGt, Materials.TungstenSteel, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.StainlessSteel, 6)).input(OrePrefix.frameGt, Materials.StainlessSteel, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Titanium, 6)).input(OrePrefix.frameGt, Materials.Titanium, 1)).outputs(MetaBlocks.METAL_CASING.getItemVariant(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).input(OrePrefix.plate, Materials.TungstenSteel, 6)).outputs(MetaBlocks.MUTLIBLOCK_CASING.getItemVariant(BlockMultiblockCasing.MultiblockCasingType.FUSION_CASING))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).input(OrePrefix.plate, Materials.Magnalium, 6)).input(OrePrefix.frameGt, Materials.BlueSteel, 1)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.StainlessSteel, 6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.Titanium, 6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TITANIUM_TURBINE_CASING, 3))).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(16)).inputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING))).input(OrePrefix.plate, Materials.TungstenSteel, 6)).outputs(MetaBlocks.TURBINE_CASING.getItemVariant(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING, 3))).duration(50)).buildAndRegister();
        if (ConfigHolder.harderMachineHulls) {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(25)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV))).input(OrePrefix.cableGtSingle, Materials.Lead, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[0].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV))).input(OrePrefix.cableGtSingle, Materials.Tin, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[1].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.Copper, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.AnnealedCopper, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV))).input(OrePrefix.cableGtSingle, Materials.Gold, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[3].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV))).input(OrePrefix.cableGtSingle, Materials.Aluminium, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[4].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV))).input(OrePrefix.cableGtSingle, Materials.Tungsten, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[5].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).input(OrePrefix.cableGtSingle, Materials.VanadiumGallium, 2)).fluidInputs(Materials.Plastic.getFluid(288))).outputs(MetaTileEntities.HULL[6].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).input(OrePrefix.cableGtSingle, Materials.Naquadah, 2)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(288))).outputs(MetaTileEntities.HULL[7].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).input(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy, 2)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(288))).outputs(MetaTileEntities.HULL[8].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX))).input(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor, 2)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(288))).outputs(MetaTileEntities.HULL[9].getStackForm())).buildAndRegister();
        } else {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(25)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ULV))).input(OrePrefix.cableGtSingle, Materials.Lead, 2)).outputs(MetaTileEntities.HULL[0].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LV))).input(OrePrefix.cableGtSingle, Materials.Tin, 2)).outputs(MetaTileEntities.HULL[1].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.Copper, 2)).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MV))).input(OrePrefix.cableGtSingle, Materials.AnnealedCopper, 2)).outputs(MetaTileEntities.HULL[2].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.HV))).input(OrePrefix.cableGtSingle, Materials.Gold, 2)).outputs(MetaTileEntities.HULL[3].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.EV))).input(OrePrefix.cableGtSingle, Materials.Aluminium, 2)).outputs(MetaTileEntities.HULL[4].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.IV))).input(OrePrefix.cableGtSingle, Materials.Tungsten, 2)).outputs(MetaTileEntities.HULL[5].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.LuV))).input(OrePrefix.cableGtSingle, Materials.VanadiumGallium, 2)).outputs(MetaTileEntities.HULL[6].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.ZPM))).input(OrePrefix.cableGtSingle, Materials.Naquadah, 2)).outputs(MetaTileEntities.HULL[7].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.UV))).input(OrePrefix.wireGtQuadruple, Materials.NaquadahAlloy, 2)).outputs(MetaTileEntities.HULL[8].getStackForm())).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(50)).EUt(16)).inputs(MetaBlocks.MACHINE_CASING.getItemVariant(BlockMachineCasing.MachineCasingType.MAX))).input(OrePrefix.wireGtSingle, MarkerMaterials.Tier.Superconductor, 2)).outputs(MetaTileEntities.HULL[9].getStackForm())).buildAndRegister();
        }
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(800)).EUt(1)).input(OrePrefix.cableGtSingle, Materials.Tin, 1)).input(OrePrefix.plate, Materials.BatteryAlloy, 1)).fluidInputs(Materials.Plastic.getFluid(144))).outputs(MetaItems.BATTERY_HULL_LV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1600)).EUt(2)).input(OrePrefix.cableGtSingle, Materials.Copper, 2)).input(OrePrefix.plate, Materials.BatteryAlloy, 3)).fluidInputs(Materials.Plastic.getFluid(432))).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(1600)).EUt(2)).input(OrePrefix.cableGtSingle, Materials.AnnealedCopper, 2)).input(OrePrefix.plate, Materials.BatteryAlloy, 3)).fluidInputs(Materials.Plastic.getFluid(432))).outputs(MetaItems.BATTERY_HULL_MV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(3200)).EUt(4)).input(OrePrefix.cableGtSingle, Materials.Gold, 4)).input(OrePrefix.plate, Materials.BatteryAlloy, 9)).fluidInputs(Materials.Plastic.getFluid(1296))).outputs(MetaItems.BATTERY_HULL_HV.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack(Items.field_151007_F, 4, Short.MAX_VALUE), new ItemStack(Items.field_151123_aH, 1, Short.MAX_VALUE))).outputs(new ItemStack(Items.field_151058_ca, 2))).duration(200)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack((Block)Blocks.field_150486_ae, 1, Short.MAX_VALUE))).input(OrePrefix.plate, Materials.Iron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack(Blocks.field_150447_bR, 1, Short.MAX_VALUE))).input(OrePrefix.plate, Materials.Iron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack((Block)Blocks.field_150486_ae, 1, Short.MAX_VALUE))).input(OrePrefix.plate, Materials.WroughtIron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack(Blocks.field_150447_bR, 1, Short.MAX_VALUE))).input(OrePrefix.plate, Materials.WroughtIron, 5)).outputs(new ItemStack((Block)Blocks.field_150438_bZ))).duration(800)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack(Items.field_151065_br))).input(OrePrefix.gem, Materials.EnderPearl, 1)).outputs(new ItemStack(Items.field_151061_bv, 1, 0))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).inputs(new ItemStack(Items.field_151072_bj))).input(OrePrefix.gem, Materials.EnderPearl, 6)).outputs(new ItemStack(Items.field_151061_bv, 6, 0))).duration(2500)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(2)).input(OrePrefix.gear, Materials.CobaltBrass, 1)).input(OrePrefix.dust, Materials.Diamond, 1)).outputs(MetaItems.COMPONENT_SAW_BLADE_DIAMOND.getStackForm(1))).duration(1600)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.dust, Materials.Redstone, 4)).input(OrePrefix.dust, Materials.Glowstone, 4)).outputs(new ItemStack(Blocks.field_150379_bu, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.dust, Materials.Redstone, 1)).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150429_aA, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.dust, Materials.Redstone, 1)).input(OrePrefix.plate, Materials.Iron, 4)).outputs(new ItemStack(Items.field_151111_aL, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.dust, Materials.Redstone, 1)).input(OrePrefix.plate, Materials.WroughtIron, 4)).outputs(new ItemStack(Items.field_151111_aL, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).input(OrePrefix.dust, Materials.Redstone, 1)).input(OrePrefix.plate, Materials.Gold, 4)).outputs(new ItemStack(Items.field_151113_aN, 1))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.stick, Materials.Wood, 1)).input(OrePrefix.dust, Materials.Sulfur, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 2))).duration(400)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.stick, Materials.Wood, 1)).input(OrePrefix.dust, Materials.Phosphorus, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 6))).duration(400)).buildAndRegister();
    }

    private static void registerBlastFurnaceRecipes() {
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration((int)Math.max(Materials.TungstenSteel.getAverageMass() / 80L, 1L) * Materials.TungstenSteel.blastFurnaceTemperature)).EUt(480)).input(OrePrefix.ingot, Materials.Tungsten, 1)).input(OrePrefix.ingot, Materials.Steel, 1)).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.TungstenSteel, 2), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(Materials.TungstenSteel.blastFurnaceTemperature).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration((int)Math.max(Materials.TungstenCarbide.getAverageMass() / 40L, 1L) * Materials.TungstenCarbide.blastFurnaceTemperature)).EUt(480)).input(OrePrefix.ingot, Materials.Tungsten, 1)).input(OrePrefix.dust, Materials.Carbon, 1)).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.TungstenCarbide, 1), OreDictUnifier.get(OrePrefix.dustSmall, Materials.Ash, 2))).blastFurnaceTemp(Materials.TungstenCarbide.blastFurnaceTemperature).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration((int)Math.max(Materials.VanadiumGallium.getAverageMass() / 40L, 1L) * Materials.VanadiumGallium.blastFurnaceTemperature)).EUt(480)).input(OrePrefix.ingot, Materials.Vanadium, 3)).input(OrePrefix.ingot, Materials.Gallium, 1)).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.VanadiumGallium, 4), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 2))).blastFurnaceTemp(Materials.VanadiumGallium.blastFurnaceTemperature).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration((int)Math.max(Materials.NiobiumTitanium.getAverageMass() / 80L, 1L) * Materials.NiobiumTitanium.blastFurnaceTemperature)).EUt(480)).input(OrePrefix.ingot, Materials.Niobium, 1)).input(OrePrefix.ingot, Materials.Titanium, 1)).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.NiobiumTitanium, 2), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(Materials.NiobiumTitanium.blastFurnaceTemperature).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration((int)Math.max(Materials.Nichrome.getAverageMass() / 32L, 1L) * Materials.Nichrome.blastFurnaceTemperature)).EUt(480)).input(OrePrefix.ingot, Materials.Nickel, 4)).input(OrePrefix.ingot, Materials.Chrome, 1)).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.Nichrome, 5), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 2))).blastFurnaceTemp(Materials.Nichrome.blastFurnaceTemperature).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.Ruby, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.Ruby, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.GreenSapphire, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.GreenSapphire, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(100)).input(OrePrefix.dust, Materials.Sapphire, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(320)).EUt(100)).input(OrePrefix.gem, Materials.Sapphire, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Aluminium, 5), OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh, 4))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(800)).EUt(500)).input(OrePrefix.dust, Materials.Ilmenite, 1)).input(OrePrefix.dust, Materials.Carbon, 1)).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.WroughtIron, 4), OreDictUnifier.get(OrePrefix.dustTiny, Materials.Rutile, 5))).blastFurnaceTemp(1700).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(800)).EUt(480)).input(OrePrefix.dust, Materials.Magnesium, 2)).fluidInputs(Materials.TitaniumTetrachloride.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.Titanium, 1), OreDictUnifier.get(OrePrefix.dust, Materials.MagnesiumChloride, 2))).blastFurnaceTemp(Materials.Titanium.blastFurnaceTemperature + 200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(500)).input(OrePrefix.dust, Materials.Galena, 1)).fluidInputs(Materials.Oxygen.getFluid(2000))).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.Silver, 4), OreDictUnifier.get(OrePrefix.nugget, Materials.Lead, 4))).blastFurnaceTemp(1500).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(400)).EUt(500)).input(OrePrefix.dust, Materials.Magnetite, 1)).fluidInputs(Materials.Oxygen.getFluid(2000))).outputs(OreDictUnifier.get(OrePrefix.nugget, Materials.WroughtIron, 4), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(120)).input(OrePrefix.ingot, Materials.Iron, 1)).fluidInputs(Materials.Oxygen.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingot, Materials.Steel, 1), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(100)).EUt(120)).input(OrePrefix.ingot, Materials.PigIron, 1)).fluidInputs(Materials.Oxygen.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingot, Materials.Steel, 1), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(100)).EUt(120)).input(OrePrefix.ingot, Materials.WroughtIron, 1)).fluidInputs(Materials.Oxygen.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingot, Materials.Steel, 1), OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh, 1))).blastFurnaceTemp(1000).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(120)).input(OrePrefix.dust, Materials.Copper, 1)).fluidInputs(Materials.Oxygen.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingot, Materials.AnnealedCopper, 1))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(120)).input(OrePrefix.ingot, Materials.Copper, 1)).fluidInputs(Materials.Oxygen.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingot, Materials.AnnealedCopper, 1))).blastFurnaceTemp(1200).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(1920)).input(OrePrefix.ingot, Materials.Iridium, 3)).input(OrePrefix.ingot, Materials.Osmium, 1)).fluidInputs(Materials.Helium.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.Osmiridium, 4))).blastFurnaceTemp(2900).buildAndRegister();
        ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().duration(500)).EUt(30720)).input(OrePrefix.ingot, Materials.Naquadah, 1)).input(OrePrefix.ingot, Materials.Osmiridium, 1)).fluidInputs(Materials.Argon.getFluid(1000))).outputs(OreDictUnifier.get(OrePrefix.ingotHot, Materials.NaquadahAlloy, 2))).blastFurnaceTemp(Materials.NaquadahAlloy.blastFurnaceTemperature).buildAndRegister();
    }

    private static void registerDecompositionRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(1600)).EUt(8)).fluidInputs(Materials.Air.getFluid(10000))).fluidOutputs(Materials.Nitrogen.getFluid(3900), Materials.Oxygen.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(MetaItems.RUBBER_DROP.getStackForm())).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.RawRubber, 4))).duration(200)).EUt(5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(400)).EUt(5)).inputs(MetaItems.RUBBER_DROP.getStackForm())).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.RawRubber, 3))).chancedOutput(MetaItems.PLANT_BALL.getStackForm(), 1000, 850)).fluidOutputs(Materials.Glue.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(200)).EUt(20)).inputs(MetaBlocks.LOG.getItem(BlockGregLog.LogVariant.RUBBER_WOOD))).chancedOutput(MetaItems.RUBBER_DROP.getStackForm(), 5000, 1200)).chancedOutput(MetaItems.PLANT_BALL.getStackForm(), 3750, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Carbon), 2500, 600)).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Wood), 2500, 700)).fluidOutputs(Materials.Methane.getFluid(60))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(250)).EUt(30)).inputs(new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE))).chancedOutput(MetaItems.PLANT_BALL.getStackForm(), 1250, 700)).chancedOutput(new ItemStack((Block)Blocks.field_150354_m), 5000, 1200)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Clay, 1), 4000, 900)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(250)).EUt(30)).inputs(new ItemStack((Block)Blocks.field_150349_c))).chancedOutput(MetaItems.PLANT_BALL.getStackForm(), 3000, 1200)).chancedOutput(new ItemStack((Block)Blocks.field_150354_m), 5000, 1200)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Clay, 1), 5000, 900)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(650)).EUt(30)).inputs(new ItemStack((Block)Blocks.field_150391_bh))).chancedOutput(new ItemStack((Block)Blocks.field_150337_Q), 2500, 900)).chancedOutput(new ItemStack((Block)Blocks.field_150338_P), 2500, 900)).chancedOutput(new ItemStack((Block)Blocks.field_150354_m), 5000, 1200)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Clay, 1), 5000, 900)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.BrownLimonite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.BrownLimonite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.YellowLimonite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.YellowLimonite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Nickel)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Nickel))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Pentlandite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Pentlandite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.BandedIron)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.BandedIron))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Ilmenite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Ilmenite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Pyrite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Pyrite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Tin)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Tin))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Chromite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Chromite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Iron), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Iron), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Monazite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Monazite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Neodymium), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Neodymium), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Bastnasite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Bastnasite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Neodymium), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Neodymium), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.VanadiumMagnetite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.VanadiumMagnetite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Gold), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Gold), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().duration(400)).EUt(24)).input(OrePrefix.dustPure, Materials.Magnetite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Magnetite))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Gold), 4000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Gold), 2000, 600)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(240)).EUt(30)).input(OrePrefix.dust, Materials.Ash)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Quicklime, 2), 9500, 0)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Potash), 6400, 0)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Magnesia), 6000, 0)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.PhosphorousPentoxide), 500, 0)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.SodaAsh), 5000, 0)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(50)).EUt(30)).input(OrePrefix.dust, Materials.DarkAsh, 2)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Ash, 1), OreDictUnifier.get(OrePrefix.dust, Materials.Carbon, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(488)).EUt(80)).input(OrePrefix.dust, Materials.Glowstone, 1)).outputs(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Redstone, 2), OreDictUnifier.get(OrePrefix.dustSmall, Materials.Gold, 2))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(800)).EUt(320)).input(OrePrefix.dust, Materials.Uranium, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Plutonium, 1), 200, 80)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Uranium235, 1), 2000, 350)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(1600)).EUt(320)).input(OrePrefix.dust, Materials.Plutonium, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Uranium, 1), 3000, 450)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Plutonium241, 1), 2000, 300)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(3200)).EUt(320)).input(OrePrefix.dust, Materials.Naquadah, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Naquadria, 1), 1000, 300)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.NaquadahEnriched, 1), 5000, 750)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(6400)).EUt(640)).input(OrePrefix.dust, Materials.NaquadahEnriched, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Naquadah, 1), 3000, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Naquadria, 1), 2000, 450)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(320)).EUt(20)).input(OrePrefix.dust, Materials.Endstone, 1)).chancedOutput(new ItemStack((Block)Blocks.field_150354_m), 9000, 300)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Tungstate, 1), 1250, 450)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Platinum, 1), 625, 150)).fluidOutputs(Materials.Helium.getFluid(140))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(160)).EUt(20)).input(OrePrefix.dust, Materials.Netherrack, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Redstone, 1), 5625, 850)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Gold, 1), 625, 120)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Sulfur, 1), 9900, 100)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Coal, 1), 5625, 850)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(200)).EUt(80)).inputs(new ItemStack(Blocks.field_150425_aM))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Saltpeter, 1), 8000, 480)).chancedOutput(new ItemStack((Block)Blocks.field_150354_m), 9000, 130)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Coal, 1), 2000, 340)).fluidOutputs(Materials.Oil.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(80)).EUt(80)).fluidInputs(Materials.Lava.getFluid(100))).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Tantalum, 1), 250, 90)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Gold, 1), 250, 80)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Tin, 1), 1000, 270)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Tungstate, 1), 250, 70)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Copper, 1), 2000, 320)).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Silver, 1), 250, 80)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(64)).EUt(20)).input(OrePrefix.dust, Materials.RareEarth, 1)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Cadmium, 1), 2500, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Neodymium, 1), 2500, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Caesium, 1), 2500, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Cerium, 1), 2500, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Yttrium, 1), 2500, 400)).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Lanthanum, 1), 2500, 400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(900)).EUt(30)).input(OrePrefix.dust, Materials.PlatinumGroupSludge)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.SiliconDioxide), OreDictUnifier.get(OrePrefix.dustTiny, Materials.Gold), OreDictUnifier.get(OrePrefix.dustTiny, Materials.Platinum))).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Palladium), 8000, 900)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Iridium), 6000, 850)).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Osmium), 6000, 850)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(160)).EUt(20)).fluidInputs(Materials.Hydrogen.getFluid(160))).fluidOutputs(Materials.Deuterium.getFluid(40))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(160)).EUt(80)).fluidInputs(Materials.Deuterium.getFluid(160))).fluidOutputs(Materials.Tritium.getFluid(40))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().duration(160)).EUt(80)).fluidInputs(Materials.Helium.getFluid(80))).fluidOutputs(Materials.Helium3.getFluid(5))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).input("treeSapling", 8)).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151015_O, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151174_bG, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151172_bF, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150434_aF, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151120_aE, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150338_P, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150337_Q, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_185164_cV, 8))).outputs(MetaItems.PLANT_BALL.getStackForm())).buildAndRegister();
    }

    private static void registerCutterRecipes() {
        for (int i = 0; i < 16; ++i) {
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(50)).EUt(8)).inputs(new ItemStack((Block)Blocks.field_150399_cn, 3, i))).outputs(new ItemStack((Block)Blocks.field_150397_co, 8, i))).buildAndRegister();
        }
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(50)).EUt(8)).inputs(new ItemStack(Blocks.field_150359_w, 3))).outputs(new ItemStack(Blocks.field_150410_aZ, 8))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150348_b))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150322_A))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 1))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150347_e))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 3))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150336_V))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 4))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150417_aV))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 5))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(25)).EUt(8)).inputs(new ItemStack(Blocks.field_150385_bj))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 6))).buildAndRegister();
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(100)).EUt(16)).inputs(new ItemStack(Blocks.field_150426_aN))).outputs(OreDictUnifier.get(OrePrefix.plate, Materials.Glowstone, 4))).buildAndRegister();
    }

    private static void registerRecyclingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.stone.name(), 1)).outputs(new ItemStack(Blocks.field_150347_e, 1))).EUt(8)).duration(200)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.cobblestone.name(), 1)).outputs(new ItemStack(Blocks.field_150351_n, 1))).EUt(8)).duration(200)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150351_n, 1))).outputs(new ItemStack((Block)Blocks.field_150354_m))).EUt(8)).duration(200)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Endstone)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Endstone))).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Tungstate), 1200, 280)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Netherrack)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Netherrack, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.nugget, Materials.Gold, 1), 500, 120)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Soapstone)).outputs(OreDictUnifier.get(OrePrefix.dustImpure, Materials.Talc, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Chromite, 1), 1000, 280)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Redrock)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Redrock))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Redrock), 1000, 380)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Marble)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Marble))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Marble), 1000, 380)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Basalt)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Basalt, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Basalt, 1), 1000, 380)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.GraniteBlack)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.GraniteBlack, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Thorium, 1), 100, 40)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.GraniteRed)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.GraniteRed, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Uranium, 1), 100, 40)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Andesite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Andesite, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Stone, 1), 100, 40)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.stone, Materials.Diorite)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Diorite, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dustSmall, Materials.Stone, 1), 100, 40)).buildAndRegister();
    }

    private static void registerFluidRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(32)).EUt(2)).inputs(new ItemStack(Items.field_151081_bc, 1, Short.MAX_VALUE))).fluidOutputs(Materials.SeedOil.getFluid(3))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(32)).EUt(2)).inputs(new ItemStack(Items.field_151080_bb, 1, Short.MAX_VALUE))).fluidOutputs(Materials.SeedOil.getFluid(6))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(100)).EUt(30)).inputs(MetaItems.BATTERY_HULL_LV.getStackForm())).fluidInputs(Materials.Mercury.getFluid(1000))).outputs(MetaItems.BATTERY_SU_LV_MERCURY.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(200)).EUt(30)).inputs(MetaItems.BATTERY_HULL_MV.getStackForm())).fluidInputs(Materials.Mercury.getFluid(4000))).outputs(MetaItems.BATTERY_SU_MV_MERCURY.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(400)).EUt(30)).inputs(MetaItems.BATTERY_HULL_HV.getStackForm())).fluidInputs(Materials.Mercury.getFluid(16000))).outputs(MetaItems.BATTERY_SU_HV_MERCURY.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(100)).EUt(30)).inputs(MetaItems.BATTERY_HULL_LV.getStackForm())).fluidInputs(Materials.SulfuricAcid.getFluid(1000))).outputs(MetaItems.BATTERY_SU_LV_SULFURIC_ACID.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(200)).EUt(30)).inputs(MetaItems.BATTERY_HULL_MV.getStackForm())).fluidInputs(Materials.SulfuricAcid.getFluid(4000))).outputs(MetaItems.BATTERY_SU_MV_SULFURIC_ACID.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_CANNER_RECIPES.recipeBuilder().duration(400)).EUt(30)).inputs(MetaItems.BATTERY_HULL_HV.getStackForm())).fluidInputs(Materials.SulfuricAcid.getFluid(16000))).outputs(MetaItems.BATTERY_SU_HV_SULFURIC_ACID.getChargedStack(Long.MAX_VALUE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(600)).EUt(28)).input(OrePrefix.dust, Materials.Quartzite, 1)).fluidOutputs(Materials.Glass.getFluid(72))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(128)).EUt(4)).inputs(new ItemStack(Items.field_151044_h, 1, 1))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Ash, 1), 1000, 200)).fluidOutputs(Materials.Creosote.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(16)).EUt(4)).input(OrePrefix.dust, Materials.Wood, 1)).chancedOutput(MetaItems.PLANT_BALL.getStackForm(), 200, 30)).fluidOutputs(Materials.Creosote.getFluid(5))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(32)).EUt(4)).input(OrePrefix.dust, Materials.HydratedCoal, 1)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Coal, 1))).fluidOutputs(Materials.Water.getFluid(100))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(32)).EUt(4)).inputs(new ItemStack(Items.field_151126_ay))).fluidOutputs(Materials.Water.getFluid(250))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().duration(128)).EUt(4)).inputs(new ItemStack(Blocks.field_150433_aE))).fluidOutputs(Materials.Water.getFluid(1000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BALL.getStackForm())).fluidInputs(Materials.Water.getFluid(250))).outputs(new ItemStack(Items.field_151126_ay))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BALL.getStackForm())).fluidInputs(ModHandler.getDistilledWater(250))).outputs(new ItemStack(Items.field_151126_ay))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(512)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(Materials.Water.getFluid(1000))).outputs(new ItemStack(Blocks.field_150433_aE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(512)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(ModHandler.getDistilledWater(1000))).outputs(new ItemStack(Blocks.field_150433_aE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(1024)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(Materials.Lava.getFluid(1000))).outputs(new ItemStack(Blocks.field_150343_Z))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(12)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(Materials.Glowstone.getFluid(576))).outputs(new ItemStack(Blocks.field_150426_aN))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(12)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(Materials.Glass.getFluid(144))).outputs(new ItemStack(Blocks.field_150359_w))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(12)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_PLATE.getStackForm())).fluidInputs(Materials.Glass.getFluid(144))).outputs(OreDictUnifier.get(OrePrefix.plate, Materials.Glass, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL.getStackForm())).fluidInputs(Materials.Iron.getFluid(4464))).outputs(new ItemStack(Blocks.field_150467_bQ))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL.getStackForm())).fluidInputs(Materials.WroughtIron.getFluid(4464))).outputs(new ItemStack(Blocks.field_150467_bQ))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(100)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_BALL.getStackForm())).fluidInputs(Materials.Toluene.getFluid(100))).outputs(MetaItems.GELLED_TOLUENE.getStackForm())).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder().duration(30)).EUt(32)).fluidInputs(Materials.Water.getFluid(6))).circuitMeta(1).fluidOutputs(Materials.Steam.getFluid(960))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder().duration(30)).EUt(32)).fluidInputs(ModHandler.getDistilledWater(6))).circuitMeta(1).fluidOutputs(Materials.Steam.getFluid(960))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron, 31)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL)).outputs(new ItemStack(Blocks.field_150467_bQ))).duration(15872)).EUt(64)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.WroughtIron, 31)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL)).outputs(new ItemStack(Blocks.field_150467_bQ))).duration(15872)).EUt(64)).buildAndRegister();
    }

    private static void registerChemicalBathRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(12)).EUt(4)).input(OrePrefix.dust, Materials.Coal, 1)).fluidInputs(Materials.Water.getFluid(125))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.HydratedCoal, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(200)).EUt(4)).input(OrePrefix.dust, Materials.Wood, 1)).fluidInputs(Materials.Water.getFluid(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(100)).EUt(4)).input(OrePrefix.dust, Materials.Paper, 1)).fluidInputs(Materials.Water.getFluid(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(100)).EUt(8)).inputs(new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE))).fluidInputs(Materials.Water.getFluid(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(12)).EUt(4)).input(OrePrefix.dust, Materials.Coal, 1)).fluidInputs(ModHandler.getDistilledWater(125))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.HydratedCoal, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(200)).EUt(4)).input(OrePrefix.dust, Materials.Wood, 1)).fluidInputs(ModHandler.getDistilledWater(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(100)).EUt(4)).input(OrePrefix.dust, Materials.Paper, 1)).fluidInputs(ModHandler.getDistilledWater(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(100)).EUt(8)).inputs(new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE))).fluidInputs(ModHandler.getDistilledWater(100))).outputs(new ItemStack(Items.field_151121_aF))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(400)).EUt(2)).inputs(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE))).fluidInputs(Materials.Chlorine.getFluid(50))).outputs(new ItemStack(Blocks.field_150325_L))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(400)).EUt(2)).inputs(new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE))).fluidInputs(Materials.Chlorine.getFluid(25))).outputs(new ItemStack(Blocks.field_150404_cg))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(400)).EUt(2)).inputs(new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE))).fluidInputs(Materials.Chlorine.getFluid(50))).outputs(new ItemStack(Blocks.field_150405_ch))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(400)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150399_cn, 1, Short.MAX_VALUE))).fluidInputs(Materials.Chlorine.getFluid(50))).outputs(new ItemStack(Blocks.field_150359_w))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(400)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150397_co, 1, Short.MAX_VALUE))).fluidInputs(Materials.Chlorine.getFluid(20))).outputs(new ItemStack(Blocks.field_150410_aZ))).buildAndRegister();
    }

    private static <T extends Enum<T>> void registerBrickRecipe(StoneBlock<T> stoneBlock, T normalVariant, T brickVariant) {
        ModHandler.addShapedRecipe(stoneBlock.getRegistryName().func_110624_b() + "_" + normalVariant + "_bricks", stoneBlock.getItemVariant(brickVariant, StoneBlock.ChiselingVariant.NORMAL, 4), "XX", "XX", Character.valueOf('X'), stoneBlock.getItemVariant(normalVariant, StoneBlock.ChiselingVariant.NORMAL));
    }

    private static <T extends Enum<T>> void registerChiselingRecipes(StoneBlock<T> stoneBlock) {
        for (Enum variant : stoneBlock.getVariantValues()) {
            boolean isBricksVariant = ((IStringSerializable)variant).func_176610_l().endsWith("_bricks");
            if (!isBricksVariant) {
                ModHandler.addSmeltingRecipe(stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.CRACKED), stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.NORMAL));
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().duration(12)).EUt(4)).inputs(stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.NORMAL))).outputs(stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.CRACKED))).buildAndRegister();
            } else {
                ModHandler.addSmeltingRecipe(stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.NORMAL), stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.CRACKED));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(12)).EUt(4)).inputs(stoneBlock.getItemVariant(variant, !isBricksVariant ? StoneBlock.ChiselingVariant.CRACKED : StoneBlock.ChiselingVariant.NORMAL))).fluidInputs(Materials.Water.getFluid(144))).outputs(stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.MOSSY))).buildAndRegister();
            ModHandler.addShapelessRecipe(stoneBlock.getRegistryName().func_110623_a() + "_chiseling_" + variant, stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.CHISELED), stoneBlock.getItemVariant(variant, StoneBlock.ChiselingVariant.NORMAL));
        }
    }
}

