/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.ArcFurnaceRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class RecyclingRecipes {
    public static void init() {
        RecyclingRecipes.initializeArcRecyclingRecipes();
    }

    private static void initializeArcRecyclingRecipes() {
        for (Map.Entry<ItemStack, ItemMaterialInfo> entry : OreDictUnifier.getAllItemInfos()) {
            ItemStack itemStack = entry.getKey();
            ItemMaterialInfo materialInfo = entry.getValue();
            ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>();
            materialStacks.add(materialInfo.material);
            materialStacks.addAll((Collection<MaterialStack>)materialInfo.additionalComponents);
            RecyclingRecipes.registerArcRecyclingRecipe(b -> b.inputs(itemStack), materialStacks, false);
        }
    }

    public static void registerArcRecyclingRecipe(Consumer<RecipeBuilder<?>> inputSupplier, List<MaterialStack> components, boolean ignoreArcSmelting) {
        List dustMaterials = components.stream().filter(stack -> stack.material instanceof DustMaterial).filter(stack -> stack.amount >= 403200L).collect(Collectors.toList());
        if (dustMaterials.isEmpty()) {
            return;
        }
        MaterialStack firstStack = (MaterialStack)dustMaterials.get(0);
        DustMaterial dustMaterial = (DustMaterial)firstStack.material;
        int voltageMultiplier = 1;
        if (dustMaterial instanceof IngotMaterial) {
            int blastFurnaceTemperature = ((IngotMaterial)dustMaterial).blastFurnaceTemperature;
            voltageMultiplier = blastFurnaceTemperature == 0 ? 1 : (blastFurnaceTemperature > 2000 ? 16 : 4);
        } else {
            ignoreArcSmelting = true;
        }
        Object maceratorRecipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().outputs(dustMaterials.stream().map(OreDictUnifier::getDust).collect(Collectors.toList()))).duration((int)Math.max(1L, firstStack.amount * 30L / 3628800L))).EUt(8 * voltageMultiplier);
        inputSupplier.accept((RecipeBuilder<?>)maceratorRecipeBuilder);
        ((RecipeBuilder)maceratorRecipeBuilder).buildAndRegister();
        if (dustMaterial.shouldGenerateFluid()) {
            Object fluidExtractorRecipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder().fluidOutputs(dustMaterial.getFluid((int)(firstStack.amount * 144L / 3628800L)))).duration((int)Math.max(1L, firstStack.amount * 80L / 3628800L))).EUt(32 * voltageMultiplier);
            inputSupplier.accept((RecipeBuilder<?>)fluidExtractorRecipeBuilder);
            ((RecipeBuilder)fluidExtractorRecipeBuilder).buildAndRegister();
        }
        if (!ignoreArcSmelting) {
            List<ItemStack> resultList = dustMaterials.stream().map(RecyclingRecipes::getArcSmeltingResult).collect(Collectors.toList());
            resultList.removeIf(ItemStack::func_190926_b);
            if (resultList.isEmpty()) {
                return;
            }
            Object arcFurnaceRecipeBuilder = ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)RecipeMaps.ARC_FURNACE_RECIPES.recipeBuilder().outputs(resultList)).duration((int)Math.max(1L, firstStack.amount * 60L / 3628800L))).EUt(30 * voltageMultiplier);
            inputSupplier.accept((RecipeBuilder<?>)arcFurnaceRecipeBuilder);
            ((RecipeBuilder)arcFurnaceRecipeBuilder).buildAndRegister();
        }
    }

    private static ItemStack getArcSmeltingResult(MaterialStack materialStack) {
        DustMaterial material = (DustMaterial)materialStack.material;
        long materialAmount = materialStack.amount;
        if (material.hasFlag(Material.MatFlags.FLAMMABLE)) {
            return OreDictUnifier.getDust(Materials.Ash, materialAmount);
        }
        if (material instanceof GemMaterial) {
            if (materialStack.material.materialComponents.stream().anyMatch(stack -> stack.material == Materials.Oxygen)) {
                return OreDictUnifier.getDust(Materials.Ash, materialAmount);
            }
            if (materialStack.material.materialComponents.stream().anyMatch(stack -> stack.material == Materials.Carbon)) {
                return OreDictUnifier.getDust(Materials.Carbon, materialAmount);
            }
            return OreDictUnifier.getDust(Materials.DarkAsh, materialAmount);
        }
        if (material instanceof IngotMaterial) {
            IngotMaterial ingotMaterial = (IngotMaterial)material;
            if (ingotMaterial.arcSmeltInto != null) {
                ingotMaterial = ingotMaterial.arcSmeltInto;
            }
            return OreDictUnifier.getIngot(ingotMaterial, materialAmount);
        }
        return OreDictUnifier.getDust(material, materialAmount);
    }
}

