/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.CutterRecipeBuilder;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.world.DummyWorld;
import gregtech.common.ConfigHolder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class WoodMachineRecipes {
    public static void init() {
        WoodMachineRecipes.initializeWoodRecipes();
        WoodMachineRecipes.registerPyrolyseOvenRecipes();
        WoodMachineRecipes.processLogOreDictionary();
    }

    private static void initializeWoodRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.log, Materials.Wood)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Wood, 6))).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Wood), 8000, 680)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood)).outputs(OreDictUnifier.get(OrePrefix.stick, Materials.Wood, 2))).duration(10)).EUt(8)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.log, Materials.Wood)).outputs(OreDictUnifier.get(OrePrefix.stickLong, Materials.Wood, 4), OreDictUnifier.get(OrePrefix.dust, Materials.Wood, 2))).duration(160)).EUt(8)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 6)).inputs(new ItemStack(Items.field_151122_aG, 3))).outputs(new ItemStack(Blocks.field_150342_X, 1))).duration(400)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 3)).circuitMeta(3).outputs(new ItemStack(Blocks.field_150415_aT, 2))).duration(300)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 8)).outputs(new ItemStack((Block)Blocks.field_150486_ae, 1))).duration(800)).EUt(4)).circuitMeta(8).buildAndRegister();
    }

    private static void processLogOreDictionary() {
        List allWoodLogs = OreDictUnifier.getAllWithOreDictionaryName("logWood").stream().flatMap(stack -> ModHandler.getAllSubItems(stack).stream()).collect(Collectors.toList());
        for (ItemStack stack2 : allWoodLogs) {
            ItemStack slabStack;
            Pair<IRecipe, ItemStack> outputPair = ModHandler.getRecipeOutput(null, stack2);
            ItemStack plankStack = (ItemStack)outputPair.getValue();
            int originalOutput = plankStack.func_190916_E();
            if (plankStack.func_190926_b()) continue;
            IRecipe outputRecipe = (IRecipe)outputPair.getKey();
            if (ConfigHolder.vanillaRecipes.nerfWoodCrafting) {
                if (originalOutput / 2 > 0) {
                    ModHandler.addShapelessRecipe(outputRecipe.getRegistryName().toString(), GTUtility.copyAmount(originalOutput / 2, plankStack), stack2);
                } else {
                    ModHandler.removeRecipeByName(outputRecipe.getRegistryName());
                }
            }
            ModHandler.addShapedRecipe(outputRecipe.getRegistryName().func_110623_a() + "_saw", GTUtility.copyAmount(originalOutput, plankStack), "s", "L", Character.valueOf('L'), stack2);
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(stack2)).fluidInputs(Materials.Lubricant.getFluid(1))).outputs(GTUtility.copyAmount((int)((double)originalOutput * 1.5), plankStack), OreDictUnifier.get(OrePrefix.dust, Materials.Wood, 2))).duration(200)).EUt(8)).buildAndRegister();
            ItemStack doorStack = (ItemStack)ModHandler.getRecipeOutput(DummyWorld.INSTANCE, plankStack, plankStack, null, plankStack, plankStack, null, plankStack, plankStack, null).getRight();
            if (!doorStack.func_190926_b()) {
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(6, plankStack))).outputs(doorStack)).duration(600)).EUt(4)).circuitMeta(6).buildAndRegister();
            }
            if ((slabStack = (ItemStack)ModHandler.getRecipeOutput(DummyWorld.INSTANCE, plankStack, plankStack, plankStack).getRight()).func_190926_b()) continue;
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(3, plankStack))).outputs(slabStack)).duration(200)).EUt(8)).buildAndRegister();
        }
    }

    private static void registerPyrolyseOvenRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(0).input(OrePrefix.gem, Materials.Coal, 16)).outputs(OreDictUnifier.get(OrePrefix.gem, Materials.Coke, 20))).fluidOutputs(Materials.Creosote.getFluid(10000))).duration(440)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(0).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(440)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(400))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(200)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2).input(OrePrefix.log, Materials.Wood, 16)).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Ash, 4))).fluidOutputs(Materials.OilHeavy.getFluid(200))).duration(280)).EUt(192)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(3).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(4).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(400))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(5).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(6).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(400))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(7).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(400))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(9).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(400))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.CharcoalByproducts.getFluid(4000))).duration(320)).EUt(96)).buildAndRegister();
    }
}

