/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.proxy;

import com.google.common.base.Function;
import java.util.Formatter;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noki.moreturtles.blocks.RegisterBlocks;
import noki.moreturtles.items.RegisterItems;
import noki.moreturtles.proxy.ProxyCommon;

public class ProxyClient
implements ProxyCommon {
    @Override
    public void registerRenderers() {
        final BlockColors blockColors = FMLClientHandler.instance().getClient().func_184125_al();
        ItemColors itemColors = FMLClientHandler.instance().getClient().getItemColors();
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{RegisterBlocks.extendedBlocks});
        itemColors.func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(iblockstate, (IBlockAccess)null, (BlockPos)null, tintIndex);
            }
        }, new Block[]{RegisterBlocks.extendedBlocks});
    }

    @Override
    public void registerItemJsonPre() {
    }

    @Override
    public void registerItemJson() {
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)0, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extension_frame", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)1, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_bucket", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)2, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_shears", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)3, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_wheat", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)4, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_bowl", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterItems.extendedItems, (int)5, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_fishing_rod", "inventory"));
    }

    @Override
    public void registerBlockJsonPre() {
    }

    @Override
    public void registerBlockJson() {
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)0, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extension_cube", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)1, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_enchanting_table", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)2, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_enchanting_table_fortune", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)3, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_enchanting_table_silk", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)4, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_enchanting_table_looting", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)5, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_enchanting_table_luck", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)6, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_daylight_detector", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)7, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_grass", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)8, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_end_stone", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)RegisterBlocks.extendedBloksItem, (int)9, (ModelResourceLocation)new ModelResourceLocation("moreturtles".toLowerCase() + ":extended_dispenser", "inventory"));
    }

    @Override
    public void registerSidedEvent() {
        MinecraftForge.EVENT_BUS.register((Object)new BakeEvent());
    }

    @Override
    public void log(String message, Object ... data) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation(new Formatter().format(message, data).toString(), new Object[0]));
    }

    private class BakeEvent {
        private BakeEvent() {
        }

        @SubscribeEvent
        public void onModelBakeEvent(ModelBakeEvent event) {
            this.loadModel(event, "turtle_biome_left");
            this.loadModel(event, "turtle_biome_right");
            this.loadModel(event, "turtle_light_left");
            this.loadModel(event, "turtle_light_right");
            this.loadModel(event, "turtle_projectile_left");
            this.loadModel(event, "turtle_projectile_right");
            this.loadModel(event, "turtle_dimensional_left");
            this.loadModel(event, "turtle_dimensional_right");
            this.loadModel(event, "turtle_fortune_left");
            this.loadModel(event, "turtle_fortune_right");
            this.loadModel(event, "turtle_silk_left");
            this.loadModel(event, "turtle_silk_right");
            this.loadModel(event, "turtle_looting_left");
            this.loadModel(event, "turtle_looting_right");
            this.loadModel(event, "turtle_luck_left");
            this.loadModel(event, "turtle_luck_right");
        }

        private void loadModel(ModelBakeEvent event, String name) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("moreturtles", "block/" + name));
                Function<ResourceLocation, TextureAtlasSprite> function = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, (java.util.function.Function)function);
                event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("moreturtles:" + name, "inventory"), (Object)bakedModel);
            }
            catch (Exception e) {
                System.out.println("Could not load model: name");
                e.printStackTrace();
            }
        }
    }
}

