/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.common;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import noki.moreturtles.MoreTurtlesCore;
import noki.moreturtles.MoreTurtlesData;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.PlayerTurtle;

public class MTTurtleAccess {
    public ITurtleAccess turtle;
    public World world;
    public BlockPos position;
    public int posX;
    public int posY;
    public int posZ;
    public EntityPlayer playerTurtle;
    public String playerTurtleName = "playerTurtle";

    public MTTurtleAccess(ITurtleAccess turtle) {
        this.turtle = turtle;
        this.setTurtleInfo();
    }

    public void setTurtleInfo() {
        this.world = this.turtle.getWorld();
        this.position = this.turtle.getPosition();
        this.posX = this.position.func_177958_n();
        this.posY = this.position.func_177956_o();
        this.posZ = this.position.func_177952_p();
        if (this.playerTurtle == null || !(this.playerTurtle instanceof FakePlayer)) {
            this.playerTurtle = new PlayerTurtle((WorldServer)this.world, new GameProfile(null, "MoreTurtles"));
        }
        this.playerTurtle.func_70107_b((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public World getWorld() {
        return this.turtle.getWorld();
    }

    public BlockPos getPosition() {
        return this.turtle.getPosition();
    }

    public boolean teleportTo(World world, BlockPos pos) {
        return this.turtle.teleportTo(world, pos);
    }

    public Vec3d getVisualPosition(float fraction) {
        return this.turtle.getVisualPosition(fraction);
    }

    public float getVisualYaw(float fraction) {
        return this.turtle.getVisualYaw(fraction);
    }

    public EnumFacing getDirection() {
        return this.turtle.getDirection();
    }

    public void setDirection(EnumFacing dir) {
        this.turtle.setDirection(dir);
    }

    public int getSelectedSlot() {
        return this.turtle.getSelectedSlot();
    }

    public void setSelectedSlot(int slot) {
        this.turtle.setSelectedSlot(slot);
    }

    public IInventory getInventory() {
        return this.turtle.getInventory();
    }

    public boolean isFuelNedded() {
        return this.turtle.isFuelNeeded();
    }

    public int getFuelLevel() {
        return this.turtle.getFuelLevel();
    }

    public void setFuelLevel(int fuel) {
        this.turtle.setFuelLevel(fuel);
    }

    public int getFuelLimit() {
        return this.turtle.getFuelLimit();
    }

    public boolean consumeFuel(int fuel) {
        if (!MoreTurtlesData.consumeFuel) {
            return true;
        }
        return this.turtle.consumeFuel(fuel);
    }

    public void addFuel(int fuel) {
        this.turtle.addFuel(fuel);
    }

    public Object[] executeCommand(ILuaContext context, ITurtleCommand command) throws LuaException, InterruptedException {
        return this.turtle.executeCommand(context, command);
    }

    public void playAnimation(TurtleAnimation animation) {
        this.turtle.playAnimation(animation);
    }

    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.turtle.getUpgrade(side);
    }

    public void setUpgrade(TurtleSide side, ITurtleUpgrade upgrade) {
        this.turtle.setUpgrade(side, upgrade);
    }

    public IPeripheral getPeripheral(TurtleSide side) {
        return this.turtle.getPeripheral(side);
    }

    public NBTTagCompound getUpgradeNBTData(TurtleSide side) {
        return this.turtle.getUpgradeNBTData(side);
    }

    public void updateUpgradeNBTData(TurtleSide side) {
        this.turtle.updateUpgradeNBTData(side);
    }

    public ITurtleUpgrade getOtherUpgrade(TurtleSide side) {
        return this.getUpgrade(MTTurtleAccess.getOppositeSide(side));
    }

    public String getOtherUpgradeName(TurtleSide side) {
        ITurtleUpgrade oppositeUpgrade = this.getOtherUpgrade(side);
        if (oppositeUpgrade != null) {
            return oppositeUpgrade.getUnlocalisedAdjective();
        }
        return null;
    }

    public ItemStack getOtherUpgradeItem(TurtleSide side) {
        ITurtleUpgrade oppositeUpgrade = this.getOtherUpgrade(side);
        if (oppositeUpgrade != null) {
            return oppositeUpgrade.getCraftingItem();
        }
        return null;
    }

    public TurtleUpgradeType getOtherUpgradeType(TurtleSide side) {
        ITurtleUpgrade oppositeUpgrade = this.getOtherUpgrade(side);
        if (oppositeUpgrade != null) {
            return oppositeUpgrade.getType();
        }
        return null;
    }

    public ItemStack getSlotContents(int slotNum) {
        IInventory inventory = this.turtle.getInventory();
        return inventory.func_70301_a(slotNum);
    }

    public void setSlotContents(int slotNum, ItemStack stack) {
        IInventory inventory = this.turtle.getInventory();
        inventory.func_70299_a(slotNum, stack);
    }

    public void removeSlotContents(int slotNum) {
        IInventory inventory = this.turtle.getInventory();
        inventory.func_70304_b(slotNum);
    }

    public boolean storeItemStack(ItemStack stack) {
        MoreTurtlesCore.log("enter into storeItemStack().", new Object[0]);
        IInventory inventory = this.turtle.getInventory();
        int currentSlot = this.getSelectedSlot();
        int slotSize = inventory.func_70302_i_();
        int i = currentSlot;
        do {
            int space;
            ItemStack currentStack;
            if ((currentStack = this.getSlotContents(i)) == null || currentStack.func_190926_b()) {
                this.setSlotContents(i, stack.func_77946_l());
                stack = null;
                return true;
            }
            if (!currentStack.func_77985_e() || !currentStack.func_77969_a(stack) || (space = currentStack.func_77976_d() - currentStack.func_190916_E()) == 0) continue;
            if (space >= stack.func_190916_E()) {
                currentStack.func_190920_e(currentStack.func_190916_E() + stack.func_190916_E());
                stack = null;
                return true;
            }
            currentStack.func_190920_e(currentStack.func_77976_d());
            stack.func_190920_e(stack.func_190916_E() - space);
        } while ((i = (i + 1) % slotSize) != currentSlot);
        return false;
    }

    public void dropItemStack(ItemStack stack, EnumFacing direction) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.func_82601_c();
            yDir = direction.func_96559_d();
            zDir = direction.func_82599_e();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)this.posX + 0.5 + xDir * 0.4;
        double yPos = (double)this.posY + 0.5 + yDir * 0.4;
        double zPos = (double)this.posZ + 0.5 + zDir * 0.4;
        EntityItem entityItem = new EntityItem(this.world, xPos, yPos, zPos, stack);
        entityItem.field_70159_w = xDir * 0.7 + (double)this.world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.field_70181_x = yDir * 0.7 + (double)this.world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.field_70179_y = zDir * 0.7 + (double)this.world.field_73012_v.nextFloat() * 0.2 - 0.1;
        entityItem.func_174869_p();
        this.world.func_72838_d((Entity)entityItem);
    }

    public void store(ItemStack stack) {
        if (!this.storeItemStack(stack)) {
            this.dropItemStack(stack, this.turtle.getDirection());
        }
    }

    public void consume(int selectedSlot) {
        ItemStack currentStack = this.getSlotContents(selectedSlot);
        currentStack.func_190920_e(currentStack.func_190916_E() - 1);
        if (currentStack.func_190916_E() == 0) {
            this.removeSlotContents(selectedSlot);
        }
    }

    public void setCurrentItem(ItemStack stack) {
        this.playerTurtle.field_71071_by.func_174888_l();
        this.playerTurtle.field_71071_by.func_70299_a(0, stack);
        this.playerTurtle.field_71071_by.field_70461_c = 0;
    }

    public void clearInventory() {
        this.playerTurtle.field_71071_by.func_174888_l();
        this.playerTurtle.field_71071_by.field_70461_c = 0;
    }

    public boolean canTurtleHarvest(ItemStack stack, Block block, BlockPos pos) {
        this.playerTurtle.field_71071_by.func_174888_l();
        this.playerTurtle.field_71071_by.func_70299_a(0, stack);
        this.playerTurtle.field_71071_by.field_70461_c = 0;
        return ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)this.playerTurtle, (IBlockAccess)this.world, (BlockPos)pos);
    }

    public float getBlockStrength(ItemStack stack, IBlockState state, int metadata, BlockPos pos) {
        this.playerTurtle.field_71071_by.func_174888_l();
        this.playerTurtle.field_71071_by.func_70299_a(0, stack);
        this.playerTurtle.field_71071_by.field_70461_c = 0;
        return ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)this.playerTurtle, (World)this.world, (BlockPos)pos);
    }

    public static TurtleCommandResult result(boolean result) {
        if (result) {
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure();
    }

    public static TurtleCommandResult result(boolean result, EFailureReason reason) {
        if (result) {
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure((String)reason.getMessage());
    }

    public static TurtleAnimation getSwingAnimation(TurtleSide side) {
        if (side == TurtleSide.Left) {
            return TurtleAnimation.SwingLeftTool;
        }
        return TurtleAnimation.SwingRightTool;
    }

    public static TurtleAnimation getOtherSwingAnimation(TurtleSide side) {
        if (side == TurtleSide.Left) {
            return TurtleAnimation.SwingRightTool;
        }
        return TurtleAnimation.SwingLeftTool;
    }

    public static TurtleSide getOppositeSide(TurtleSide side) {
        if (side == TurtleSide.Left) {
            return TurtleSide.Right;
        }
        return TurtleSide.Left;
    }
}

