/*
 * Decompiled with CFR 0.152.
 */
package noki.moreturtles.turtle.peripheral;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.world.biome.Biome;
import noki.moreturtles.turtle.common.EFailureReason;
import noki.moreturtles.turtle.common.MTTurtleAccess;

public class PeripheralBiomeHosted
implements IPeripheral {
    private MTTurtleAccess turtle;
    private TurtleSide side;

    public PeripheralBiomeHosted(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = new MTTurtleAccess(turtle);
        this.side = side;
    }

    public String getType() {
        return "MoreTurtles";
    }

    public String[] getMethodNames() {
        return new String[]{"getName", "getBiome", "getBiomeID", "getClimate", "getTemperature", "getStandardTemperature", "getRainfall", "isRaining", "isThundering"};
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return false;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        this.turtle.setTurtleInfo();
        switch (method) {
            case 0: {
                return this.getName();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.getAboutBiome(method, arguments);
            }
            case 7: 
            case 8: {
                return this.getWeather(method, arguments);
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }

    private Object[] getName() {
        return new Object[]{"Biome"};
    }

    private Object[] getAboutBiome(int method, Object[] arguments) throws LuaException, InterruptedException {
        Biome biome = this.turtle.world.func_180494_b(this.turtle.getPosition());
        switch (method) {
            case 1: {
                return new Object[]{biome.func_185359_l()};
            }
            case 2: {
                return new Object[]{Biome.func_185362_a((Biome)biome)};
            }
            case 3: {
                return new Object[]{this.getClimateString(biome.func_150561_m(), biome)};
            }
            case 4: {
                return new Object[]{Float.valueOf(biome.func_180626_a(this.turtle.getPosition()))};
            }
            case 5: {
                return new Object[]{Float.valueOf(biome.func_185353_n())};
            }
            case 6: {
                return new Object[]{Float.valueOf(biome.func_76727_i())};
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }

    private String getClimateString(Biome.TempCategory category, Biome biome) {
        switch (category) {
            case COLD: {
                if (biome.func_185353_n() < 2.0f) {
                    return "snowy";
                }
                return "cold";
            }
            case MEDIUM: {
                return "medium";
            }
            case WARM: {
                return "warm";
            }
        }
        return "ocean";
    }

    private Object[] getWeather(int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 7: {
                return new Object[]{this.turtle.world.func_72896_J()};
            }
            case 8: {
                return new Object[]{this.turtle.world.func_72911_I()};
            }
        }
        return new Object[]{false, EFailureReason.UNKNOWN.getMessage()};
    }
}

